/*
 * Decompiled with CFR 0.152.
 */
package it.zerono.mods.extremereactors.api.coolant;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import io.netty.buffer.ByteBuf;
import it.zerono.mods.extremereactors.api.internal.AbstractNamedValue;
import it.zerono.mods.zerocore.lib.data.ModCodecs;
import it.zerono.mods.zerocore.lib.data.gfx.Colour;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;

public class Coolant
extends AbstractNamedValue {
    public static final Coolant EMPTY = new Coolant("empty", Colour.WHITE, Float.MAX_VALUE, 0.0f, "gui.zerocore.base.generic.empty");
    public static final ModCodecs<Coolant, ByteBuf> CODECS = new ModCodecs(RecordCodecBuilder.create(instance -> instance.group((App)Codec.STRING.fieldOf("name").forGetter(AbstractNamedValue::getName), (App)Colour.CODECS.field("colour", Coolant::getColour), (App)Codec.FLOAT.fieldOf("boiling").forGetter(Coolant::getBoilingPoint), (App)Codec.FLOAT.fieldOf("enthalpy").forGetter(Coolant::getEnthalpyOfVaporization), (App)Codec.STRING.fieldOf("translation").forGetter(AbstractNamedValue::getTranslationKey)).apply((Applicative)instance, Coolant::new)), StreamCodec.composite((StreamCodec)ByteBufCodecs.STRING_UTF8, AbstractNamedValue::getName, (StreamCodec)Colour.CODECS.streamCodec(), Coolant::getColour, (StreamCodec)ByteBufCodecs.FLOAT, Coolant::getBoilingPoint, (StreamCodec)ByteBufCodecs.FLOAT, Coolant::getEnthalpyOfVaporization, (StreamCodec)ByteBufCodecs.STRING_UTF8, AbstractNamedValue::getTranslationKey, Coolant::new));
    private final float _boilingPoint;
    private final float _enthalpyOfVaporization;
    private final Colour _colour;

    Coolant(String name, Colour colour, float boilingPoint, float enthalpyOfVaporization, String translationKey) {
        super(name, translationKey);
        this._boilingPoint = Math.max(0.0f, boilingPoint);
        this._enthalpyOfVaporization = Math.max(0.0f, enthalpyOfVaporization);
        this._colour = colour;
    }

    public float getBoilingPoint() {
        return this._boilingPoint;
    }

    public float getEnthalpyOfVaporization() {
        return this._enthalpyOfVaporization;
    }

    public Coolant copy() {
        return new Coolant(this.getName(), this.getColour(), this.getBoilingPoint(), this.getEnthalpyOfVaporization(), this.getTranslationKey());
    }

    public Colour getColour() {
        return this._colour;
    }

    @Override
    public boolean equals(Object obj) {
        return this == obj || obj instanceof Coolant && super.equals(obj) && this.getBoilingPoint() == ((Coolant)obj).getBoilingPoint() && this.getEnthalpyOfVaporization() == ((Coolant)obj).getEnthalpyOfVaporization();
    }
}

