/*
 * Decompiled with CFR 0.152.
 */
package sonar.fluxnetworks.client;

import it.unimi.dsi.fastutil.ints.Int2ObjectLinkedOpenHashMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectOpenHashMap;
import java.util.Collection;
import java.util.List;
import javax.annotation.Nonnull;
import net.minecraft.core.GlobalPos;
import net.minecraft.nbt.CompoundTag;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import sonar.fluxnetworks.FluxNetworks;
import sonar.fluxnetworks.api.device.IFluxDevice;
import sonar.fluxnetworks.common.connection.ClientFluxNetwork;
import sonar.fluxnetworks.common.connection.FluxNetwork;
import sonar.fluxnetworks.common.util.FluxUtils;

@OnlyIn(value=Dist.CLIENT)
public final class ClientCache {
    private static final int MAX_RECENT_PASSWORD_COUNT = 5;
    private static final Int2ObjectOpenHashMap<FluxNetwork> sNetworks = new Int2ObjectOpenHashMap();
    private static final Int2ObjectLinkedOpenHashMap<String> sRecentPasswords = new Int2ObjectLinkedOpenHashMap(5);
    public static boolean sSuperAdmin = false;
    public static int sWirelessMode = 0;
    public static int sWirelessNetwork = -1;
    public static boolean sDetailedNetworkView = false;
    public static int sAdminViewingNetwork = -1;

    private ClientCache() {
    }

    public static void release() {
        sNetworks.clear();
        sNetworks.trim();
        sRecentPasswords.clear();
        sAdminViewingNetwork = -1;
        FluxNetworks.LOGGER.info("Released client Flux Networks cache");
    }

    public static void cleanup() {
        sNetworks.values().forEach(FluxNetwork::onDelete);
    }

    public static void updateNetwork(@Nonnull Int2ObjectMap<CompoundTag> map, byte type) {
        for (Int2ObjectMap.Entry e : map.int2ObjectEntrySet()) {
            ((FluxNetwork)sNetworks.computeIfAbsent(e.getIntKey(), ClientFluxNetwork::new)).readCustomTag((CompoundTag)e.getValue(), type);
        }
    }

    public static void updateConnections(int networkID, @Nonnull List<CompoundTag> tags) {
        FluxNetwork network = (FluxNetwork)sNetworks.get(networkID);
        if (network != null) {
            for (CompoundTag tag : tags) {
                GlobalPos pos = FluxUtils.readGlobalPos(tag);
                IFluxDevice device = network.getConnectionByPos(pos);
                if (device == null) continue;
                device.readCustomTag(tag, (byte)20);
            }
        }
    }

    @Nonnull
    public static FluxNetwork getNetwork(int id) {
        return (FluxNetwork)sNetworks.getOrDefault(id, (Object)FluxNetwork.INVALID);
    }

    @Nonnull
    public static Collection<FluxNetwork> getAllNetworks() {
        return sNetworks.values();
    }

    public static void deleteNetwork(int id) {
        sNetworks.remove(id);
    }

    @Nonnull
    public static String getRecentPassword(int id) {
        return (String)sRecentPasswords.getOrDefault(id, (Object)"");
    }

    public static void updateRecentPassword(int id, String password) {
        for (int i = 5; i < sRecentPasswords.size(); ++i) {
            sRecentPasswords.removeFirst();
        }
        sRecentPasswords.put(id, (Object)password);
    }
}

