/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.api.crafting;

import blusunrize.immersiveengineering.api.crafting.IERecipeSerializer;
import blusunrize.immersiveengineering.api.crafting.IERecipeTypes;
import blusunrize.immersiveengineering.api.crafting.IngredientWithSize;
import blusunrize.immersiveengineering.api.crafting.MultiblockRecipe;
import blusunrize.immersiveengineering.api.crafting.TagOutput;
import blusunrize.immersiveengineering.api.crafting.cache.CachedRecipeList;
import blusunrize.immersiveengineering.api.utils.SetRestrictedField;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import net.minecraft.core.NonNullList;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.level.Level;
import net.neoforged.neoforge.fluids.FluidStack;
import net.neoforged.neoforge.fluids.crafting.SizedFluidIngredient;
import net.neoforged.neoforge.registries.DeferredHolder;

public class MixerRecipe
extends MultiblockRecipe {
    public static DeferredHolder<RecipeSerializer<?>, IERecipeSerializer<MixerRecipe>> SERIALIZER;
    public static final CachedRecipeList<MixerRecipe> RECIPES;
    public static final SetRestrictedField<MultiblockRecipe.RecipeMultiplier> MULTIPLIERS;
    public final List<IngredientWithSize> itemInputs;
    public final SizedFluidIngredient fluidInput;
    public final FluidStack fluidOutput;
    public final int fluidAmount;

    public MixerRecipe(FluidStack fluidOutput, SizedFluidIngredient fluidInput, List<IngredientWithSize> itemInputs, int energy) {
        super(TagOutput.EMPTY, IERecipeTypes.MIXER, fluidOutput.getAmount(), energy, MULTIPLIERS);
        this.fluidOutput = fluidOutput;
        this.fluidAmount = fluidOutput.getAmount();
        this.fluidInput = fluidInput;
        this.itemInputs = itemInputs;
        this.fluidInputList = Lists.newArrayList((Object[])new SizedFluidIngredient[]{this.fluidInput});
        this.setInputListWithSizes(Lists.newArrayList(this.itemInputs));
        this.fluidOutputList = Lists.newArrayList((Object[])new FluidStack[]{this.fluidOutput});
    }

    protected IERecipeSerializer<MixerRecipe> getIESerializer() {
        return (IERecipeSerializer)SERIALIZER.get();
    }

    public static RecipeHolder<MixerRecipe> findRecipe(Level level, FluidStack fluid, NonNullList<ItemStack> components) {
        if (fluid.isEmpty()) {
            return null;
        }
        for (RecipeHolder<MixerRecipe> recipe : RECIPES.getRecipes(level)) {
            if (!((MixerRecipe)recipe.value()).matches(fluid, components)) continue;
            return recipe;
        }
        return null;
    }

    public FluidStack getFluidOutput(FluidStack input, NonNullList<ItemStack> components) {
        return this.fluidOutput;
    }

    public boolean matches(FluidStack fluid, NonNullList<ItemStack> components) {
        return this.compareToInputs(fluid, components, this.fluidInput, this.itemInputs);
    }

    protected boolean compareToInputs(FluidStack fluid, NonNullList<ItemStack> components, SizedFluidIngredient fluidInput, List<IngredientWithSize> itemInputs) {
        if (fluidInput.test(fluid)) {
            ArrayList<ItemStack> queryList = new ArrayList<ItemStack>(components.size());
            for (ItemStack s : components) {
                if (s.isEmpty()) continue;
                queryList.add(s.copy());
            }
            for (IngredientWithSize add : itemInputs) {
                if (add == null) continue;
                int addAmount = add.getCount();
                Iterator it = queryList.iterator();
                while (it.hasNext()) {
                    ItemStack query = (ItemStack)it.next();
                    if (query.isEmpty()) continue;
                    if (add.test(query)) {
                        if (query.getCount() > addAmount) {
                            query.shrink(addAmount);
                            addAmount = 0;
                        } else {
                            addAmount -= query.getCount();
                            query.setCount(0);
                        }
                    }
                    if (query.getCount() <= 0) {
                        it.remove();
                    }
                    if (addAmount > 0) continue;
                    break;
                }
                if (addAmount <= 0) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    public int[] getUsedSlots(FluidStack input, NonNullList<ItemStack> components) {
        HashSet<Integer> usedSlotSet = new HashSet<Integer>();
        block0: for (IngredientWithSize ingr : this.itemInputs) {
            for (int j = 0; j < components.size(); ++j) {
                if (usedSlotSet.contains(j) || ((ItemStack)components.get(j)).isEmpty() || !ingr.test((ItemStack)components.get(j))) continue;
                usedSlotSet.add(j);
                continue block0;
            }
        }
        int it = 0;
        int[] processSlots = new int[usedSlotSet.size()];
        for (Integer slot : usedSlotSet) {
            processSlots[it++] = slot;
        }
        return processSlots;
    }

    @Override
    public int getMultipleProcessTicks() {
        return 7;
    }

    @Override
    public boolean shouldCheckItemAvailability() {
        return false;
    }

    static {
        RECIPES = new CachedRecipeList<MixerRecipe>(IERecipeTypes.MIXER);
        MULTIPLIERS = SetRestrictedField.common();
    }
}

