/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.api.wires.impl;

import blusunrize.immersiveengineering.api.wires.ConnectorBlockEntityHelper;
import blusunrize.immersiveengineering.api.wires.GlobalWireNetwork;
import blusunrize.immersiveengineering.api.wires.IImmersiveConnectable;
import blusunrize.immersiveengineering.api.wires.LocalWireNetwork;
import it.unimi.dsi.fastutil.ints.Int2ObjectArrayMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import net.minecraft.core.BlockPos;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;

public abstract class ImmersiveConnectableBlockEntity
extends BlockEntity
implements IImmersiveConnectable {
    protected GlobalWireNetwork globalNet;
    private boolean isUnloaded = false;
    private final Int2ObjectMap<LocalWireNetwork> cachedLocalNets = new Int2ObjectArrayMap();

    public ImmersiveConnectableBlockEntity(BlockEntityType<?> tileEntityTypeIn, BlockPos pos, BlockState state) {
        super(tileEntityTypeIn, pos, state);
    }

    public void setLevel(Level world) {
        super.setLevel(world);
        this.globalNet = GlobalWireNetwork.getNetwork(world);
    }

    public void onChunkUnloaded() {
        super.onChunkUnloaded();
        ConnectorBlockEntityHelper.onChunkUnload(this.globalNet, this);
        this.isUnloaded = true;
    }

    public void onLoad() {
        super.onLoad();
        ConnectorBlockEntityHelper.onChunkLoad(this, this.level);
        this.isUnloaded = false;
    }

    public void setRemoved() {
        super.setRemoved();
        if (!this.isUnloaded) {
            ConnectorBlockEntityHelper.remove(this.level, this);
        }
    }

    protected LocalWireNetwork getLocalNet(int cpIndex) {
        return ConnectorBlockEntityHelper.getLocalNetWithCache(this.globalNet, this.getBlockPos(), cpIndex, this.cachedLocalNets);
    }

    @Override
    public BlockPos getPosition() {
        return this.worldPosition;
    }
}

