/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.common.blocks.generic;

import blusunrize.immersiveengineering.common.blocks.IEBaseBlock;
import javax.annotation.Nonnull;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;

public class ScaffoldingBlock
extends IEBaseBlock.IELadderBlock {
    private static final VoxelShape COLLISION_SHAPE = ScaffoldingBlock.box((double)1.0, (double)0.0, (double)1.0, (double)15.0, (double)16.0, (double)15.0);
    private static final VoxelShape FULL_SHAPE = Shapes.or((VoxelShape)ScaffoldingBlock.box((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)4.0, (double)16.0), (VoxelShape)ScaffoldingBlock.box((double)0.0, (double)12.0, (double)0.0, (double)16.0, (double)16.0, (double)16.0));
    public static final VoxelShape CHECK_SHAPE = Shapes.box((double)0.0, (double)-20.0, (double)0.0, (double)1.0, (double)-19.0, (double)1.0);

    public ScaffoldingBlock(BlockBehaviour.Properties material) {
        super(material);
        this.lightOpacity = 0;
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        super.createBlockStateDefinition(builder);
        builder.add(new Property[]{BlockStateProperties.WATERLOGGED});
    }

    @Nonnull
    public VoxelShape getShape(@Nonnull BlockState state, @Nonnull BlockGetter worldIn, @Nonnull BlockPos pos, @Nonnull CollisionContext context) {
        return Shapes.block();
    }

    @Nonnull
    public VoxelShape getCollisionShape(@Nonnull BlockState state, @Nonnull BlockGetter worldIn, @Nonnull BlockPos pos, CollisionContext context) {
        boolean checkForClimbing = context.isAbove(CHECK_SHAPE, pos, false);
        if (checkForClimbing) {
            return COLLISION_SHAPE;
        }
        return FULL_SHAPE;
    }

    public boolean skipRendering(@Nonnull BlockState state, BlockState adjState, @Nonnull Direction side) {
        return adjState.getBlock() instanceof ScaffoldingBlock || super.skipRendering(state, adjState, side);
    }
}

