/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.common.blocks.multiblocks.shapes;

import java.util.Set;
import java.util.function.Function;
import net.minecraft.core.BlockPos;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;

public class AutoWorkbenchShapes
implements Function<BlockPos, VoxelShape> {
    public static final Function<BlockPos, VoxelShape> SHAPE_GETTER = new AutoWorkbenchShapes();
    private static final Set<BlockPos> HIGH_FULL_BLOCKS = Set.of(new BlockPos(0, 1, 2), new BlockPos(0, 1, 1));
    private static final Set<BlockPos> CONVEYORS = Set.of(new BlockPos(1, 1, 1), new BlockPos(2, 1, 1), new BlockPos(0, 1, 0), new BlockPos(1, 1, 0));

    private AutoWorkbenchShapes() {
    }

    @Override
    public VoxelShape apply(BlockPos posInMultiblock) {
        if (posInMultiblock.getY() == 0 || HIGH_FULL_BLOCKS.contains(posInMultiblock)) {
            return Shapes.box((double)0.0, (double)0.0, (double)0.0, (double)1.0, (double)1.0, (double)1.0);
        }
        if (CONVEYORS.contains(posInMultiblock)) {
            return Shapes.box((double)0.0, (double)0.0, (double)0.0, (double)1.0, (double)0.125, (double)1.0);
        }
        float xMin = 0.0f;
        float yMin = 0.0f;
        float zMin = 0.0f;
        float xMax = 1.0f;
        float yMax = 1.0f;
        float zMax = 1.0f;
        if (Set.of(new BlockPos(1, 1, 2), new BlockPos(2, 1, 2)).contains(posInMultiblock)) {
            boolean is11 = new BlockPos(2, 1, 2).equals((Object)posInMultiblock);
            yMax = 0.8125f;
            zMin = 0.1875f;
            if (is11) {
                xMax = 0.875f;
            }
        }
        if (new BlockPos(2, 1, 0).equals((Object)posInMultiblock)) {
            yMax = 0.3125f;
            zMin = 0.25f;
            xMax = 0.875f;
        }
        return Shapes.box((double)xMin, (double)yMin, (double)zMin, (double)xMax, (double)yMax, (double)zMax);
    }
}

