/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.common.items;

import blusunrize.immersiveengineering.api.tool.ToolboxHandler;
import blusunrize.immersiveengineering.common.items.InternalStorageItem;
import blusunrize.immersiveengineering.common.register.IEBlocks;
import blusunrize.immersiveengineering.common.register.IEMenuTypes;
import java.util.AbstractCollection;
import java.util.AbstractList;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.advancements.CriteriaTriggers;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Holder;
import net.minecraft.core.NonNullList;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.SlotAccess;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.ClickAction;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.inventory.tooltip.BundleTooltip;
import net.minecraft.world.inventory.tooltip.TooltipComponent;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.component.BundleContents;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.gameevent.GameEvent;
import net.neoforged.neoforge.capabilities.Capabilities;
import net.neoforged.neoforge.items.IItemHandler;

public class ToolboxItem
extends InternalStorageItem {
    public static final int SLOT_COUNT = 23;

    public ToolboxItem() {
        super(new Item.Properties().stacksTo(1), 23);
    }

    @Nonnull
    public InteractionResultHolder<ItemStack> use(Level world, Player player, @Nonnull InteractionHand hand) {
        ItemStack stack = player.getItemInHand(hand);
        if (!world.isClientSide) {
            this.openGui(player, hand);
        }
        return new InteractionResultHolder(InteractionResult.SUCCESS, (Object)stack);
    }

    public boolean overrideOtherStackedOnMe(ItemStack toolbox, ItemStack otherStack, Slot slot, ClickAction action, Player player, SlotAccess slotAccess) {
        if (action == ClickAction.SECONDARY && slot.allowModification(player) && !otherStack.isEmpty()) {
            int i = this.addItem(toolbox, otherStack);
            if (i > 0) {
                player.playSound(SoundEvents.BUNDLE_INSERT, 0.8f, 0.8f + player.level().getRandom().nextFloat() * 0.4f);
                otherStack.shrink(i);
            }
            return true;
        }
        return false;
    }

    private int addItem(ItemStack toolbox, ItemStack other) {
        int iSlot;
        int[] slots = Arrays.stream(ToolboxHandler.ToolboxCategory.values()).filter(cat -> cat.accepts(other)).map(ToolboxHandler.ToolboxCategory::getSlots).findFirst().orElse(new int[0]);
        if (slots.length < 1) {
            return 0;
        }
        IItemHandler handler = (IItemHandler)toolbox.getCapability(Capabilities.ItemHandler.ITEM);
        if (handler == null) {
            return 0;
        }
        ItemStack remain = other.copy();
        int[] nArray = slots;
        int n = nArray.length;
        for (int i = 0; i < n && !(remain = handler.insertItem(iSlot = nArray[i], remain, false)).isEmpty(); ++i) {
        }
        return other.getCount() - remain.getCount();
    }

    @Override
    @Nullable
    protected IEMenuTypes.ItemContainerTypeNew<?> getContainerTypeNew() {
        return IEMenuTypes.TOOLBOX;
    }

    @Nonnull
    public InteractionResult useOn(@Nonnull UseOnContext context) {
        BlockPlaceContext ctx;
        BlockPos pos = context.getClickedPos();
        Direction side = context.getClickedFace();
        Level level = context.getLevel();
        BlockState state = level.getBlockState(pos);
        if (!state.canBeReplaced(ctx = new BlockPlaceContext(context))) {
            pos = pos.relative(side);
        }
        ItemStack stack = context.getItemInHand();
        Player player = context.getPlayer();
        if (player != null && player.isShiftKeyDown()) {
            if (!ctx.canPlace()) {
                return InteractionResult.FAIL;
            }
            if (player.mayUseItemAt(pos, side, stack)) {
                BlockState toolbox = IEBlocks.MetalDevices.TOOLBOX.defaultBlockState();
                if (!level.setBlockAndUpdate(pos, toolbox)) {
                    return InteractionResult.FAIL;
                }
                state = level.getBlockState(pos);
                if (state.is(toolbox.getBlock())) {
                    IEBlocks.MetalDevices.TOOLBOX.get().onIEBlockPlacedBy(ctx, toolbox);
                    state.getBlock().setPlacedBy(level, pos, state, (LivingEntity)player, stack);
                    if (player instanceof ServerPlayer) {
                        CriteriaTriggers.PLACED_BLOCK.trigger((ServerPlayer)player, pos, stack);
                    }
                }
                SoundType soundtype = state.getSoundType((LevelReader)level, pos, (Entity)ctx.getPlayer());
                level.playSound(player, pos, soundtype.getPlaceSound(), SoundSource.BLOCKS, (soundtype.getVolume() + 1.0f) / 2.0f, soundtype.getPitch() * 0.8f);
                level.gameEvent((Holder)GameEvent.BLOCK_PLACE, pos, GameEvent.Context.of((Entity)player, (BlockState)state));
                if (!player.getAbilities().instabuild) {
                    stack.shrink(1);
                }
                return InteractionResult.SUCCESS;
            }
        }
        return super.useOn(context);
    }

    public boolean canFitInsideContainerItems() {
        return false;
    }

    @Nonnull
    public Optional<TooltipComponent> getTooltipImage(@Nonnull ItemStack stack) {
        NonNullList items = ToolboxItem.getContainedItems(stack).stream().filter(s -> !s.isEmpty()).collect(NonNullList::create, AbstractList::add, AbstractCollection::addAll);
        if (!items.isEmpty()) {
            return Optional.of(new BundleTooltip(new BundleContents((List)items)));
        }
        return super.getTooltipImage(stack);
    }
}

