/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.common.items.bullets;

import blusunrize.immersiveengineering.api.IEApi;
import blusunrize.immersiveengineering.api.tool.BulletHandler;
import blusunrize.immersiveengineering.api.utils.Color4;
import blusunrize.immersiveengineering.client.utils.FontUtils;
import blusunrize.immersiveengineering.common.entities.RevolvershotFlareEntity;
import java.util.List;
import java.util.UUID;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.HitResult;

public class FlareBullet
implements BulletHandler.IBullet<Color4> {
    static ResourceLocation[] textures = new ResourceLocation[]{IEApi.ieLoc("item/bullet_flare"), IEApi.ieLoc("item/bullet_flare_layer")};
    private static final BulletHandler.CodecsAndDefault<Color4> CODEC = new BulletHandler.CodecsAndDefault<Color4>(Color4.CODECS, Color4.fromRGB(13381126));

    @Override
    public BulletHandler.CodecsAndDefault<Color4> getCodec() {
        return CODEC;
    }

    @Override
    public Entity getProjectile(Player shooter, Color4 color, Entity projectile, boolean electro) {
        RevolvershotFlareEntity flare = shooter != null ? new RevolvershotFlareEntity(projectile.level(), (LivingEntity)shooter, projectile.getDeltaMovement().x * 1.5, projectile.getDeltaMovement().y * 1.5, projectile.getDeltaMovement().z * 1.5, color) : new RevolvershotFlareEntity(projectile.level(), projectile.getX(), projectile.getY(), projectile.getZ(), 0.0, 0.0, 0.0, color);
        flare.setDeltaMovement(projectile.getDeltaMovement());
        flare.bulletElectro = electro;
        return flare;
    }

    @Override
    public void onHitTarget(Level world, HitResult target, UUID shooter, Entity projectile, boolean headshot, Color4 bulletData) {
    }

    @Override
    public ItemStack getCasing(ItemStack stack) {
        return BulletHandler.emptyShell.asItem().getDefaultInstance();
    }

    @Override
    public ResourceLocation[] getTextures() {
        return textures;
    }

    @Override
    public void addTooltip(Color4 color, Item.TooltipContext world, List<Component> list, TooltipFlag flag) {
        list.add((Component)FontUtils.withAppendColoredColour(Component.translatable((String)"desc.immersiveengineering.info.bullet.flareColour"), color.toInt()));
    }

    @Override
    public Color4 getColour(Color4 color, int layer) {
        if (layer != 1) {
            return Color4.WHITE;
        }
        return color;
    }

    @Override
    public boolean isValidForTurret() {
        return true;
    }
}

