/*
 * Decompiled with CFR 0.152.
 */
package mekanism.client.gui.element.button;

import java.lang.runtime.SwitchBootstraps;
import java.util.List;
import java.util.function.Function;
import java.util.function.IntConsumer;
import java.util.function.IntSupplier;
import java.util.function.ObjIntConsumer;
import mekanism.api.text.EnumColor;
import mekanism.client.gui.GuiUtils;
import mekanism.client.gui.IGuiWrapper;
import mekanism.client.gui.element.button.FilterButton;
import mekanism.client.gui.element.button.FilterSelectButton;
import mekanism.client.gui.tooltip.TooltipUtils;
import mekanism.client.render.MekanismRenderer;
import mekanism.common.MekanismLang;
import mekanism.common.content.filter.FilterManager;
import mekanism.common.content.filter.IFilter;
import mekanism.common.content.filter.IItemStackFilter;
import mekanism.common.content.filter.IModIDFilter;
import mekanism.common.content.filter.ITagFilter;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Tooltip;
import net.minecraft.world.item.ItemStack;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class MovableFilterButton
extends FilterButton {
    private static final Tooltip MOVE_UP = TooltipUtils.create(MekanismLang.MOVE_UP, MekanismLang.MOVE_TO_TOP);
    private static final Tooltip MOVE_DOWN = TooltipUtils.create(MekanismLang.MOVE_DOWN, MekanismLang.MOVE_TO_BOTTOM);
    private final FilterSelectButton upButton;
    private final FilterSelectButton downButton;

    public MovableFilterButton(IGuiWrapper gui, int x, int y, int index, IntSupplier filterIndex, FilterManager<?> filterManager, IntConsumer upButtonPress, IntConsumer downButtonPress, ObjIntConsumer<IFilter<?>> onPress, IntConsumer toggleButtonPress, Function<IFilter<?>, List<ItemStack>> renderStackSupplier) {
        this(gui, x, y, 156, 29, index, filterIndex, filterManager, upButtonPress, downButtonPress, onPress, toggleButtonPress, renderStackSupplier);
    }

    public MovableFilterButton(IGuiWrapper gui, int x, int y, int width, int height, int index, IntSupplier filterIndex, FilterManager<?> filterManager, IntConsumer upButtonPress, IntConsumer downButtonPress, ObjIntConsumer<IFilter<?>> onPress, IntConsumer toggleButtonPress, Function<IFilter<?>, List<ItemStack>> renderStackSupplier) {
        super(gui, x, y, width, height, index, filterIndex, filterManager, onPress, toggleButtonPress, renderStackSupplier);
        int arrowX = this.relativeX + this.width - 14;
        int halfHeight = this.height / 2;
        this.upButton = this.addChild(new FilterSelectButton(gui, arrowX, this.relativeY + halfHeight - 8, false, (element, mouseX, mouseY) -> {
            upButtonPress.accept(this.getActualIndex());
            return true;
        }));
        this.upButton.setTooltip(MOVE_UP);
        this.downButton = this.addChild(new FilterSelectButton(gui, arrowX, this.relativeY + halfHeight + 1, true, (element, mouseX, mouseY) -> {
            downButtonPress.accept(this.getActualIndex());
            return true;
        }));
        this.downButton.setTooltip(MOVE_DOWN);
    }

    @Override
    protected int getToggleXShift() {
        return 17;
    }

    @Override
    protected void setVisibility(boolean visible) {
        super.setVisibility(visible);
        if (visible) {
            this.updateButtonVisibility(this.getFilter());
        } else {
            this.upButton.visible = false;
            this.downButton.visible = false;
        }
    }

    private void updateButtonVisibility(@Nullable IFilter<?> filter) {
        int index = this.getActualIndex();
        this.upButton.visible = filter != null && index > 0;
        this.downButton.visible = filter != null && index < this.filterManager.count() - 1;
    }

    @Override
    public void drawBackground(@NotNull GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTicks) {
        EnumColor color;
        IFilter<?> filter;
        super.drawBackground(guiGraphics, mouseX, mouseY, partialTicks);
        IFilter<?> iFilter = filter = this.getFilter();
        int n = 0;
        switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{IItemStackFilter.class, ITagFilter.class, IModIDFilter.class}, iFilter, n)) {
            case 0: {
                IItemStackFilter stackFilter = (IItemStackFilter)iFilter;
                EnumColor enumColor = EnumColor.INDIGO;
                break;
            }
            case 1: {
                ITagFilter tagFilter = (ITagFilter)iFilter;
                EnumColor enumColor = EnumColor.BRIGHT_GREEN;
                break;
            }
            case 2: {
                IModIDFilter modIDFilter = (IModIDFilter)iFilter;
                EnumColor enumColor = EnumColor.RED;
                break;
            }
            default: {
                EnumColor enumColor = color = null;
            }
        }
        if (color != null) {
            GuiUtils.fill(guiGraphics, this.getButtonX(), this.getButtonY(), this.getButtonWidth(), this.getButtonHeight(), MekanismRenderer.getColorARGB(color, 0.3f));
        }
        this.updateButtonVisibility(filter);
    }
}

