/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.content.network;

import it.unimi.dsi.fastutil.longs.Long2ObjectMap;
import it.unimi.dsi.fastutil.objects.ObjectIterator;
import java.util.ArrayList;
import java.util.Collection;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import mekanism.api.RelativeSide;
import mekanism.api.text.EnumColor;
import mekanism.common.MekanismLang;
import mekanism.common.content.network.transmitter.LogisticalTransporterBase;
import mekanism.common.content.transporter.PathfinderCache;
import mekanism.common.content.transporter.TransporterManager;
import mekanism.common.content.transporter.TransporterPathfinder;
import mekanism.common.content.transporter.TransporterStack;
import mekanism.common.lib.inventory.TransitRequest;
import mekanism.common.lib.transmitter.DynamicNetwork;
import mekanism.common.tile.interfaces.ISideConfiguration;
import mekanism.common.util.WorldUtils;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.GlobalPos;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.chunk.ChunkAccess;
import net.neoforged.neoforge.items.IItemHandler;
import org.jetbrains.annotations.NotNull;

public class InventoryNetwork
extends DynamicNetwork<IItemHandler, InventoryNetwork, LogisticalTransporterBase> {
    public InventoryNetwork(UUID networkID) {
        super(networkID);
    }

    public InventoryNetwork(Collection<InventoryNetwork> networks) {
        this(UUID.randomUUID());
        this.adoptAllAndRegister(networks);
    }

    public List<AcceptorData> calculateAcceptors(TransitRequest request, TransporterStack stack, Long2ObjectMap<ChunkAccess> chunkMap, Map<GlobalPos, Set<TransporterStack>> additionalFlowingStacks, LogisticalTransporterBase start) {
        ArrayList<AcceptorData> toReturn = new ArrayList<AcceptorData>();
        ObjectIterator iterator = this.acceptorCache.getAcceptorFastIterator();
        while (iterator.hasNext()) {
            Long2ObjectMap.Entry entry = (Long2ObjectMap.Entry)iterator.next();
            long pos = entry.getLongKey();
            if (pos == stack.homeLocation) continue;
            BlockPos blockPos = BlockPos.of((long)pos);
            BlockEntity acceptor = WorldUtils.getTileEntity((LevelAccessor)this.getWorld(), chunkMap, blockPos);
            HashMap<TransitRequest.TransitResponse, AcceptorData> dataMap = new HashMap<TransitRequest.TransitResponse, AcceptorData>();
            GlobalPos position = GlobalPos.of((ResourceKey)this.getWorld().dimension(), (BlockPos)blockPos);
            for (Map.Entry acceptorEntry : ((Map)entry.getValue()).entrySet()) {
                TransitRequest.TransitResponse response;
                EnumColor configColor;
                ISideConfiguration config;
                IItemHandler handler = (IItemHandler)acceptorEntry.getValue();
                Direction side = (Direction)acceptorEntry.getKey();
                PathfinderCache.CachedPath cachedPath = PathfinderCache.getSingleCache(start, blockPos, side);
                if (cachedPath != null && !TransporterPathfinder.checkPath(this, cachedPath.path(), stack) || acceptor instanceof ISideConfiguration && (config = (ISideConfiguration)acceptor).getEjector().hasStrictInput() && (configColor = config.getEjector().getInputColor(RelativeSide.fromDirections(config.getDirection(), side))) != null && configColor != stack.color || (response = TransporterManager.getPredictedInsert(position, side, handler, request, additionalFlowingStacks)).isEmpty()) continue;
                Direction opposite = side.getOpposite();
                AcceptorData data = (AcceptorData)dataMap.get(response);
                if (data == null) {
                    data = new AcceptorData(blockPos, response, opposite);
                    dataMap.put(response, data);
                    toReturn.add(data);
                    continue;
                }
                data.sides.add(opposite);
            }
        }
        return toReturn;
    }

    @Override
    public void commit() {
        super.commit();
        PathfinderCache.onChanged(this);
    }

    @Override
    public void deregister() {
        super.deregister();
        PathfinderCache.onChanged(this);
    }

    public String toString() {
        return "[InventoryNetwork] " + this.transmittersSize() + " transmitters, " + this.getAcceptorCount() + " acceptors.";
    }

    @Override
    @NotNull
    public Component getTextComponent() {
        return MekanismLang.NETWORK_DESCRIPTION.translate(MekanismLang.INVENTORY_NETWORK, this.transmittersSize(), this.getAcceptorCount());
    }

    public static class AcceptorData {
        private final BlockPos location;
        private final TransitRequest.TransitResponse response;
        private final Set<Direction> sides;

        protected AcceptorData(BlockPos pos, TransitRequest.TransitResponse ret, Direction side) {
            this.location = pos;
            this.response = ret;
            this.sides = EnumSet.of(side);
        }

        public TransitRequest.TransitResponse getResponse() {
            return this.response;
        }

        public BlockPos getLocation() {
            return this.location;
        }

        public Set<Direction> getSides() {
            return this.sides;
        }
    }
}

