/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.content.qio.filter;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import io.netty.buffer.ByteBuf;
import java.util.function.Function;
import mekanism.common.content.filter.FilterType;
import mekanism.common.content.filter.IModIDFilter;
import mekanism.common.content.qio.filter.QIOFilter;
import mekanism.common.lib.inventory.Finder;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;

public class QIOModIDFilter
extends QIOFilter<QIOModIDFilter>
implements IModIDFilter<QIOModIDFilter> {
    public static final MapCodec<QIOModIDFilter> CODEC = RecordCodecBuilder.mapCodec(instance -> QIOModIDFilter.baseQIOCodec(instance).and((App)Codec.STRING.fieldOf("modid").forGetter(QIOModIDFilter::getModID)).apply((Applicative)instance, QIOModIDFilter::new));
    public static final StreamCodec<ByteBuf, QIOModIDFilter> STREAM_CODEC = StreamCodec.composite(QIOModIDFilter.baseQIOStreamCodec(QIOModIDFilter::new), Function.identity(), (StreamCodec)ByteBufCodecs.STRING_UTF8, QIOModIDFilter::getModID, (filter, modID) -> {
        filter.modID = modID;
        return filter;
    });
    private String modID;

    public QIOModIDFilter() {
    }

    protected QIOModIDFilter(boolean enabled, String modID) {
        super(enabled);
        this.modID = modID;
    }

    public QIOModIDFilter(QIOModIDFilter filter) {
        super(filter);
        this.modID = filter.modID;
    }

    @Override
    public Finder getFinder() {
        return Finder.modID(this.modID);
    }

    @Override
    public int hashCode() {
        return 31 * super.hashCode() + this.modID.hashCode();
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass() || !super.equals(o)) {
            return false;
        }
        QIOModIDFilter other = (QIOModIDFilter)o;
        return this.modID.equals(other.modID);
    }

    @Override
    public QIOModIDFilter clone() {
        return new QIOModIDFilter(this);
    }

    @Override
    public FilterType getFilterType() {
        return FilterType.QIO_MODID_FILTER;
    }

    @Override
    public void setModID(String id) {
        this.modID = id;
    }

    @Override
    public String getModID() {
        return this.modID;
    }
}

