/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.integration.crafttweaker.recipe.handler;

import com.blamejared.crafttweaker.api.item.IItemStack;
import com.blamejared.crafttweaker.api.recipe.component.IDecomposedRecipe;
import com.blamejared.crafttweaker.api.recipe.handler.IRecipeHandler;
import com.blamejared.crafttweaker.api.recipe.manager.base.IRecipeManager;
import java.util.Optional;
import mekanism.api.recipes.ChemicalCrystallizerRecipe;
import mekanism.api.recipes.ingredients.ChemicalStackIngredient;
import mekanism.common.integration.crafttweaker.CrTRecipeComponents;
import mekanism.common.integration.crafttweaker.CrTUtils;
import mekanism.common.integration.crafttweaker.recipe.handler.MekanismRecipeHandler;
import mekanism.common.integration.crafttweaker.recipe.manager.ChemicalCrystallizerRecipeManager;
import net.minecraft.core.RegistryAccess;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeHolder;

@IRecipeHandler.For(value=ChemicalCrystallizerRecipe.class)
public class ChemicalCrystallizerRecipeHandler
extends MekanismRecipeHandler<ChemicalCrystallizerRecipe> {
    public String dumpToCommandString(IRecipeManager<? super ChemicalCrystallizerRecipe> manager, RegistryAccess registryAccess, RecipeHolder<ChemicalCrystallizerRecipe> recipeHolder) {
        ChemicalCrystallizerRecipe recipe = (ChemicalCrystallizerRecipe)recipeHolder.value();
        return this.buildCommandString(manager, recipeHolder, recipe.getInput(), recipe.getOutputDefinition());
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public <U extends Recipe<?>> boolean doesConflict(IRecipeManager<? super ChemicalCrystallizerRecipe> manager, ChemicalCrystallizerRecipe recipe, U o) {
        if (!(o instanceof ChemicalCrystallizerRecipe)) return false;
        ChemicalCrystallizerRecipe other = (ChemicalCrystallizerRecipe)o;
        if (!this.chemicalIngredientConflicts(recipe.getInput(), other.getInput())) return false;
        return true;
    }

    public Optional<IDecomposedRecipe> decompose(IRecipeManager<? super ChemicalCrystallizerRecipe> manager, RegistryAccess registryAccess, ChemicalCrystallizerRecipe recipe) {
        return this.decompose(recipe.getInput(), recipe.getOutputDefinition());
    }

    public Optional<ChemicalCrystallizerRecipe> recompose(IRecipeManager<? super ChemicalCrystallizerRecipe> m, RegistryAccess registryAccess, IDecomposedRecipe recipe) {
        if (m instanceof ChemicalCrystallizerRecipeManager) {
            ChemicalCrystallizerRecipeManager manager = (ChemicalCrystallizerRecipeManager)m;
            Optional<ChemicalStackIngredient> found = CrTUtils.getSingleIfPresent(recipe, CrTRecipeComponents.CHEMICAL.input());
            ChemicalStackIngredient input = found.orElseThrow(() -> new IllegalArgumentException("No chemical input ingredient provided."));
            return Optional.of(manager.makeRecipe(input, (IItemStack)recipe.getOrThrowSingle(CrTRecipeComponents.ITEM.output())));
        }
        return Optional.empty();
    }
}

