/*
 * Decompiled with CFR 0.152.
 */
package com.blakebr0.mysticalagradditions.init;

import com.blakebr0.mysticalagradditions.MysticalAgradditions;
import java.util.function.Consumer;
import java.util.function.Supplier;
import net.minecraft.core.Registry;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvents;
import net.neoforged.neoforge.client.extensions.common.IClientFluidTypeExtensions;
import net.neoforged.neoforge.common.SoundActions;
import net.neoforged.neoforge.fluids.FluidType;
import net.neoforged.neoforge.registries.DeferredHolder;
import net.neoforged.neoforge.registries.DeferredRegister;
import net.neoforged.neoforge.registries.NeoForgeRegistries;

public final class ModFluidTypes {
    private static final ResourceLocation STILL_TEXTURE = MysticalAgradditions.resource("block/molten_still");
    private static final ResourceLocation FLOWING_TEXTURE = MysticalAgradditions.resource("block/molten_flowing");
    public static final DeferredRegister<FluidType> REGISTRY = DeferredRegister.create((Registry)NeoForgeRegistries.FLUID_TYPES, (String)"mysticalagradditions");
    public static final DeferredHolder<FluidType, FluidType> MOLTEN_INFERIUM = REGISTRY.register("molten_inferium", ModFluidTypes.newMoltenFluidType(-9138688));
    public static final DeferredHolder<FluidType, FluidType> MOLTEN_PRUDENTIUM = REGISTRY.register("molten_prudentium", ModFluidTypes.newMoltenFluidType(-16741341));
    public static final DeferredHolder<FluidType, FluidType> MOLTEN_TERTIUM = REGISTRY.register("molten_tertium", ModFluidTypes.newMoltenFluidType(-4765440));
    public static final DeferredHolder<FluidType, FluidType> MOLTEN_IMPERIUM = REGISTRY.register("molten_imperium", ModFluidTypes.newMoltenFluidType(-16744485));
    public static final DeferredHolder<FluidType, FluidType> MOLTEN_SUPREMIUM = REGISTRY.register("molten_supremium", ModFluidTypes.newMoltenFluidType(-3932160));
    public static final DeferredHolder<FluidType, FluidType> MOLTEN_SOULIUM = REGISTRY.register("molten_soulium", ModFluidTypes.newMoltenFluidType(-7580100));

    private static Supplier<FluidType> newMoltenFluidType(final int color) {
        FluidType.Properties properties = FluidType.Properties.create().density(2000).viscosity(10000).temperature(1000).sound(SoundActions.BUCKET_FILL, SoundEvents.BUCKET_FILL_LAVA).sound(SoundActions.BUCKET_EMPTY, SoundEvents.BUCKET_EMPTY_LAVA);
        return () -> new FluidType(properties){

            public void initializeClient(Consumer<IClientFluidTypeExtensions> consumer) {
                consumer.accept(new IClientFluidTypeExtensions(){

                    public int getTintColor() {
                        return color;
                    }

                    public ResourceLocation getStillTexture() {
                        return STILL_TEXTURE;
                    }

                    public ResourceLocation getFlowingTexture() {
                        return FLOWING_TEXTURE;
                    }
                });
            }
        };
    }
}

