/*
 * Decompiled with CFR 0.152.
 */
package com.blakebr0.mysticalagriculture.block;

import com.blakebr0.cucumber.iface.IColored;
import com.blakebr0.mysticalagriculture.api.crop.CropTier;
import com.blakebr0.mysticalagriculture.api.farmland.IEssenceFarmland;
import com.blakebr0.mysticalagriculture.lib.ModTooltips;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.Registry;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.FarmBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.storage.loot.LootParams;
import net.minecraft.world.level.storage.loot.parameters.LootContextParams;

public class InfusedFarmlandBlock
extends FarmBlock
implements IColored,
IEssenceFarmland {
    public static final List<InfusedFarmlandBlock> FARMLANDS = new ArrayList<InfusedFarmlandBlock>();
    private final CropTier tier;

    public InfusedFarmlandBlock(CropTier tier) {
        super(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.FARMLAND));
        this.tier = tier;
        FARMLANDS.add(this);
    }

    public void fallOn(Level level, BlockState state, BlockPos pos, Entity entity, float fallDistance) {
        entity.causeFallDamage(fallDistance, 1.0f, level.damageSources().fall());
    }

    public boolean isFertile(BlockState state, BlockGetter level, BlockPos pos) {
        return (Integer)state.getValue((Property)MOISTURE) > 0;
    }

    public void randomTick(BlockState state, ServerLevel level, BlockPos pos, RandomSource random) {
        int moisture = (Integer)state.getValue((Property)MOISTURE);
        if (!InfusedFarmlandBlock.isNearWater((LevelReader)level, (BlockPos)pos) && !level.isRainingAt(pos.above())) {
            if (moisture > 0) {
                level.setBlock(pos, (BlockState)state.setValue((Property)MOISTURE, (Comparable)Integer.valueOf(moisture - 1)), 2);
            }
        } else if (moisture < 7) {
            level.setBlock(pos, (BlockState)state.setValue((Property)MOISTURE, (Comparable)Integer.valueOf(7)), 2);
        }
    }

    public List<ItemStack> getDrops(BlockState state, LootParams.Builder builder) {
        ArrayList<ItemStack> drops = new ArrayList<ItemStack>();
        ItemStack stack = (ItemStack)builder.getOptionalParameter(LootContextParams.TOOL);
        Registry registry = builder.getLevel().registryAccess().registryOrThrow(Registries.ENCHANTMENT);
        Holder.Reference silkTouch = registry.getHolderOrThrow(Enchantments.SILK_TOUCH);
        if (stack != null && EnchantmentHelper.getTagEnchantmentLevel((Holder)silkTouch, (ItemStack)stack) > 0) {
            drops.add(new ItemStack((ItemLike)this));
        } else {
            drops.add(new ItemStack((ItemLike)Blocks.DIRT));
            RandomSource random = builder.getLevel().getRandom();
            if (random.nextInt(100) < 25) {
                drops.add(new ItemStack((ItemLike)this.tier.getEssence(), 1));
            }
        }
        return drops;
    }

    public void appendHoverText(ItemStack stack, Item.TooltipContext context, List<Component> tooltip, TooltipFlag flag) {
        tooltip.add((Component)ModTooltips.TIER.args(new Object[]{this.tier.getDisplayName()}).build());
    }

    public int getColor(int index) {
        return this.tier.getColor();
    }

    @Override
    public CropTier getTier() {
        return this.tier;
    }
}

