/*
 * Decompiled with CFR 0.152.
 */
package com.blakebr0.mysticalagriculture.crafting;

import com.blakebr0.cucumber.event.RecipeManagerLoadingEvent;
import com.blakebr0.mysticalagriculture.MysticalAgriculture;
import com.blakebr0.mysticalagriculture.api.crop.Crop;
import com.blakebr0.mysticalagriculture.config.ModConfigs;
import com.blakebr0.mysticalagriculture.crafting.recipe.InfusionRecipe;
import com.blakebr0.mysticalagriculture.crafting.recipe.ReprocessorRecipe;
import com.blakebr0.mysticalagriculture.registry.CropRegistry;
import java.util.Optional;
import net.minecraft.core.NonNullList;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.CraftingBookCategory;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.item.crafting.ShapedRecipe;
import net.minecraft.world.item.crafting.ShapedRecipePattern;
import net.minecraft.world.level.ItemLike;
import net.neoforged.bus.api.SubscribeEvent;

public class DynamicRecipeManager {
    public static final DynamicRecipeManager INSTANCE = new DynamicRecipeManager();

    @SubscribeEvent
    public void onRecipeManagerLoading(RecipeManagerLoadingEvent event) {
        for (Crop crop : CropRegistry.getInstance().getCrops()) {
            RecipeHolder<Recipe<?>> seed = DynamicRecipeManager.makeSeedRecipe(crop);
            RecipeHolder<Recipe<?>> seedRegular = DynamicRecipeManager.makeRegularSeedRecipe(crop);
            RecipeHolder<Recipe<?>> reprocessor = DynamicRecipeManager.makeReprocessorRecipe(crop);
            if (seed != null) {
                event.addRecipe(seed);
            }
            if (seedRegular != null) {
                event.addRecipe(seedRegular);
            }
            if (reprocessor == null) continue;
            event.addRecipe(reprocessor);
        }
    }

    private static RecipeHolder<Recipe<?>> makeSeedRecipe(Crop crop) {
        if (!crop.isEnabled() || !crop.getRecipeConfig().isSeedInfusionRecipeEnabled()) {
            return null;
        }
        Item essenceItem = crop.getTier().getEssence();
        if (essenceItem == null) {
            return null;
        }
        Item craftingSeedItem = crop.getType().getCraftingSeed();
        if (craftingSeedItem == null) {
            return null;
        }
        Ingredient material = crop.getCraftingMaterial();
        if (material == Ingredient.EMPTY) {
            return null;
        }
        Ingredient essence = Ingredient.of((ItemLike[])new ItemLike[]{essenceItem});
        Ingredient craftingSeed = Ingredient.of((ItemLike[])new ItemLike[]{craftingSeedItem});
        NonNullList inputs = NonNullList.of((Object)Ingredient.EMPTY, (Object[])new Ingredient[]{material, essence, material, essence, material, essence, material, essence});
        ResourceLocation id = MysticalAgriculture.resource(crop.getNameWithSuffix("seeds_infusion"));
        ItemStack result = new ItemStack((ItemLike)crop.getSeedsItem());
        return new RecipeHolder(id, (Recipe)new InfusionRecipe(craftingSeed, (NonNullList<Ingredient>)inputs, result, false));
    }

    private static RecipeHolder<Recipe<?>> makeRegularSeedRecipe(Crop crop) {
        if (!crop.isEnabled() || !crop.getRecipeConfig().isSeedCraftingRecipeEnabled()) {
            return null;
        }
        if (!((Boolean)ModConfigs.SEED_CRAFTING_RECIPES.get()).booleanValue()) {
            return null;
        }
        Item essenceItem = crop.getTier().getEssence();
        if (essenceItem == null) {
            return null;
        }
        Item craftingSeedItem = crop.getType().getCraftingSeed();
        if (craftingSeedItem == null) {
            return null;
        }
        Ingredient material = crop.getCraftingMaterial();
        if (material == Ingredient.EMPTY) {
            return null;
        }
        Ingredient essence = Ingredient.of((ItemLike[])new ItemLike[]{essenceItem});
        Ingredient craftingSeed = Ingredient.of((ItemLike[])new ItemLike[]{craftingSeedItem});
        NonNullList inputs = NonNullList.of((Object)Ingredient.EMPTY, (Object[])new Ingredient[]{material, essence, material, essence, craftingSeed, essence, material, essence, material});
        ResourceLocation id = MysticalAgriculture.resource(crop.getNameWithSuffix("seeds_vanilla"));
        ShapedRecipePattern pattern = new ShapedRecipePattern(3, 3, inputs, Optional.empty());
        ItemStack result = new ItemStack((ItemLike)crop.getSeedsItem());
        return new RecipeHolder(id, (Recipe)new ShapedRecipe("", CraftingBookCategory.MISC, pattern, result));
    }

    private static RecipeHolder<Recipe<?>> makeReprocessorRecipe(Crop crop) {
        if (!crop.isEnabled() || !crop.getRecipeConfig().isSeedReprocessorRecipeEnabled()) {
            return null;
        }
        Ingredient input = Ingredient.of((ItemLike[])new ItemLike[]{crop.getSeedsItem()});
        ResourceLocation id = MysticalAgriculture.resource(crop.getNameWithSuffix("seeds_reprocessor"));
        ItemStack result = new ItemStack((ItemLike)crop.getEssenceItem(), 2);
        return new RecipeHolder(id, (Recipe)new ReprocessorRecipe(input, result));
    }
}

