/*
 * Decompiled with CFR 0.152.
 */
package com.blakebr0.mysticalagriculture.network.payloads;

import com.blakebr0.mysticalagriculture.MysticalAgriculture;
import com.blakebr0.mysticalagriculture.util.RecipeIngredientCache;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeType;
import net.neoforged.neoforge.network.handling.IPayloadContext;

public record ReloadIngredientCachePayload(Map<RecipeType<?>, Map<Item, List<Ingredient>>> caches, Set<Item> validVesselItems) implements CustomPacketPayload
{
    public static final CustomPacketPayload.Type<ReloadIngredientCachePayload> TYPE = new CustomPacketPayload.Type(MysticalAgriculture.resource("reload_ingredient_cache"));
    public static final StreamCodec<RegistryFriendlyByteBuf, ReloadIngredientCachePayload> STREAM_CODEC = StreamCodec.of(ReloadIngredientCachePayload::toNetwork, ReloadIngredientCachePayload::fromNetwork);

    public CustomPacketPayload.Type<ReloadIngredientCachePayload> type() {
        return TYPE;
    }

    private static ReloadIngredientCachePayload fromNetwork(RegistryFriendlyByteBuf buffer) {
        HashMap caches = new HashMap();
        int types = buffer.readVarInt();
        for (int i = 0; i < types; ++i) {
            RecipeType type = (RecipeType)BuiltInRegistries.RECIPE_TYPE.get(buffer.readResourceLocation());
            int items = buffer.readVarInt();
            caches.put(type, new HashMap());
            for (int j = 0; j < items; ++j) {
                Item item = (Item)BuiltInRegistries.ITEM.get(buffer.readResourceLocation());
                int ingredients = buffer.readVarInt();
                for (int k = 0; k < ingredients; ++k) {
                    List cache = caches.get(type).computeIfAbsent(item, l -> new ArrayList());
                    Ingredient ingredient = (Ingredient)Ingredient.CONTENTS_STREAM_CODEC.decode((Object)buffer);
                    cache.add(ingredient);
                }
            }
        }
        HashSet<Item> validVesselItems = new HashSet<Item>();
        int items = buffer.readVarInt();
        for (int i = 0; i < items; ++i) {
            Item item = (Item)BuiltInRegistries.ITEM.get(buffer.readResourceLocation());
            validVesselItems.add(item);
        }
        return new ReloadIngredientCachePayload(caches, validVesselItems);
    }

    private static void toNetwork(RegistryFriendlyByteBuf buffer, ReloadIngredientCachePayload payload) {
        buffer.writeVarInt(payload.caches.size());
        for (Map.Entry<RecipeType<?>, Map<Item, List<Ingredient>>> entry : payload.caches.entrySet()) {
            ResourceLocation type = BuiltInRegistries.RECIPE_TYPE.getKey(entry.getKey());
            Map<Item, List<Ingredient>> caches = entry.getValue();
            assert (type != null);
            buffer.writeResourceLocation(type);
            buffer.writeVarInt(caches.size());
            for (Map.Entry<Item, List<Ingredient>> cache : caches.entrySet()) {
                ResourceLocation item = BuiltInRegistries.ITEM.getKey((Object)cache.getKey());
                List<Ingredient> ingredients = cache.getValue();
                buffer.writeResourceLocation(item);
                buffer.writeVarInt(ingredients.size());
                for (Ingredient ingredient : ingredients) {
                    Ingredient.CONTENTS_STREAM_CODEC.encode((Object)buffer, (Object)ingredient);
                }
            }
        }
        buffer.writeVarInt(payload.validVesselItems.size());
        for (Item item : payload.validVesselItems) {
            ResourceLocation id = BuiltInRegistries.ITEM.getKey((Object)item);
            buffer.writeResourceLocation(id);
        }
    }

    public static void handleClient(ReloadIngredientCachePayload payload, IPayloadContext context) {
        context.enqueueWork(() -> {
            RecipeIngredientCache.INSTANCE.setCaches(payload.caches);
            RecipeIngredientCache.INSTANCE.setValidVesselItems(payload.validVesselItems);
        });
    }
}

