/*
 * Decompiled with CFR 0.152.
 */
package it.zerono.mods.zerocore.base.multiblock.part.io.power.charging;

import it.zerono.mods.zerocore.base.multiblock.part.AbstractMultiblockEntity;
import it.zerono.mods.zerocore.base.multiblock.part.io.power.charging.AbstractChargingPortHandler;
import it.zerono.mods.zerocore.base.multiblock.part.io.power.charging.IChargingPort;
import it.zerono.mods.zerocore.lib.data.IoDirection;
import it.zerono.mods.zerocore.lib.data.WideAmount;
import it.zerono.mods.zerocore.lib.data.capability.ItemHandlerCapabilitySource;
import it.zerono.mods.zerocore.lib.energy.EnergySystem;
import it.zerono.mods.zerocore.lib.multiblock.cuboid.AbstractCuboidMultiblockController;
import java.util.ArrayList;
import java.util.List;
import net.neoforged.neoforge.capabilities.Capabilities;
import net.neoforged.neoforge.energy.IEnergyStorage;
import net.neoforged.neoforge.items.IItemHandler;
import net.neoforged.neoforge.items.IItemHandlerModifiable;

public class ChargingPortHandlerForgeEnergy<Controller extends AbstractCuboidMultiblockController<Controller>, Port extends AbstractMultiblockEntity<Controller> & IChargingPort>
extends AbstractChargingPortHandler<Controller, Port> {
    private final List<ItemHandlerCapabilitySource<IEnergyStorage, Void>> _remoteCapabilitySources;

    public ChargingPortHandlerForgeEnergy(Port port, int inputSlotsCount, int outputSlotsCount) {
        super(EnergySystem.ForgeEnergy, port, inputSlotsCount, outputSlotsCount);
        IItemHandlerModifiable handler = this.getItemStackHandler(IoDirection.Input);
        this._remoteCapabilitySources = new ArrayList<ItemHandlerCapabilitySource<IEnergyStorage, Void>>(this.getInputSlotsCount());
        for (int idx = 0; idx < this.getInputSlotsCount(); ++idx) {
            this._remoteCapabilitySources.add(new ItemHandlerCapabilitySource((IItemHandler)handler, idx, Capabilities.EnergyStorage.ITEM));
        }
    }

    @Override
    public WideAmount outputEnergy(WideAmount amount) {
        WideAmount maxTransfer = this.getChargingRate();
        if (amount.isZero() || maxTransfer.isZero()) {
            return WideAmount.ZERO;
        }
        WideAmount remaining = amount.copy();
        WideAmount accepted = WideAmount.ZERO;
        for (int idx = 0; idx < this.getInputSlotsCount(); ++idx) {
            IEnergyStorage capability = this._remoteCapabilitySources.get(idx).getCapability(null);
            if (null == capability || !capability.canReceive()) continue;
            WideAmount transfer = WideAmount.min(remaining, maxTransfer);
            int transferred = capability.receiveEnergy(transfer.intValue(), false);
            if (0 == transferred) {
                this.eject(idx);
            }
            accepted = accepted.add(transfer);
            if ((remaining = remaining.subtract(transfer)).isZero()) break;
        }
        return accepted;
    }
}

