/*
 * Decompiled with CFR 0.152.
 */
package it.zerono.mods.zerocore.lib.block;

import it.zerono.mods.zerocore.internal.Lib;
import it.zerono.mods.zerocore.lib.CodeHelper;
import it.zerono.mods.zerocore.lib.IDebugMessages;
import it.zerono.mods.zerocore.lib.IDebuggable;
import it.zerono.mods.zerocore.lib.block.IBlockStateUpdater;
import it.zerono.mods.zerocore.lib.block.ITileCommandDispatcher;
import it.zerono.mods.zerocore.lib.data.nbt.ISyncableEntity;
import it.zerono.mods.zerocore.lib.data.nbt.IVersionAwareSyncableEntity;
import it.zerono.mods.zerocore.lib.data.nbt.NBTHelper;
import it.zerono.mods.zerocore.lib.event.Event;
import it.zerono.mods.zerocore.lib.event.IEvent;
import it.zerono.mods.zerocore.lib.world.WorldHelper;
import java.util.Collection;
import java.util.Objects;
import java.util.function.BooleanSupplier;
import java.util.function.Consumer;
import java.util.function.DoubleSupplier;
import java.util.function.IntSupplier;
import java.util.function.LongSupplier;
import java.util.function.Supplier;
import java.util.stream.Stream;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.Connection;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.protocol.PacketFlow;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.neoforged.fml.LogicalSide;
import net.neoforged.neoforge.common.util.FakePlayer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class AbstractModBlockEntity
extends BlockEntity
implements IBlockStateUpdater,
ISyncableEntity,
IDebuggable {
    @Deprecated
    public final IEvent<Runnable> DataUpdate;
    private static final int EVENT_CLIENT_RENDER_UPDATE = 1;
    private ITileCommandDispatcher _commandDispatcher = (source, name, parameters) -> {};

    public AbstractModBlockEntity(BlockEntityType<?> type, BlockPos position, BlockState blockState) {
        super(type, position, blockState);
        this.DataUpdate = new Event<Runnable>();
    }

    public Block getBlockType() {
        return this.getBlockState().getBlock();
    }

    public ItemStack asStorableStack() {
        return ItemStack.EMPTY;
    }

    public void callOnLogicalSide(Runnable serverCode, Runnable clientCode) {
        if (null != this.level) {
            CodeHelper.callOnLogicalSide(this.level, serverCode, clientCode);
        }
    }

    public <T> T callOnLogicalSide(Supplier<T> serverCode, Supplier<T> clientCode, Supplier<T> invalidSideReturnValue) {
        if (null == this.level) {
            return invalidSideReturnValue.get();
        }
        return CodeHelper.callOnLogicalSide(this.level, serverCode, clientCode);
    }

    public boolean callOnLogicalSide(BooleanSupplier serverCode, BooleanSupplier clientCode) {
        return null != this.level && CodeHelper.callOnLogicalSide(this.level, serverCode, clientCode);
    }

    public int callOnLogicalSide(IntSupplier serverCode, IntSupplier clientCode, IntSupplier invalidSideReturnValue) {
        if (null == this.level) {
            return invalidSideReturnValue.getAsInt();
        }
        return CodeHelper.callOnLogicalSide(this.level, serverCode, clientCode);
    }

    public long callOnLogicalSide(LongSupplier serverCode, LongSupplier clientCode, LongSupplier invalidSideReturnValue) {
        if (null == this.level) {
            return invalidSideReturnValue.getAsLong();
        }
        return CodeHelper.callOnLogicalSide(this.level, serverCode, clientCode);
    }

    public double callOnLogicalSide(DoubleSupplier serverCode, DoubleSupplier clientCode, DoubleSupplier invalidSideReturnValue) {
        if (null == this.level) {
            return invalidSideReturnValue.getAsDouble();
        }
        return CodeHelper.callOnLogicalSide(this.level, serverCode, clientCode);
    }

    public void callOnLogicalServer(Runnable code) {
        if (null != this.level) {
            CodeHelper.callOnLogicalServer(this.level, code);
        }
    }

    public void callOnLogicalServer(Consumer<Level> code) {
        if (null != this.level && CodeHelper.calledByLogicalServer(this.level)) {
            code.accept(this.level);
        }
    }

    public <T> T callOnLogicalServer(Supplier<T> code, Supplier<T> invalidSideReturnValue) {
        if (null == this.level) {
            return invalidSideReturnValue.get();
        }
        return CodeHelper.callOnLogicalServer(this.level, code, invalidSideReturnValue);
    }

    public boolean callOnLogicalServer(BooleanSupplier code) {
        return null != this.level && CodeHelper.callOnLogicalServer(this.level, code);
    }

    public int callOnLogicalServer(IntSupplier code, int invalidSideReturnValue) {
        if (null == this.level) {
            return invalidSideReturnValue;
        }
        return CodeHelper.callOnLogicalServer(this.level, code, invalidSideReturnValue);
    }

    public long callOnLogicalServer(LongSupplier code, long invalidSideReturnValue) {
        if (null == this.level) {
            return invalidSideReturnValue;
        }
        return CodeHelper.callOnLogicalServer(this.level, code, invalidSideReturnValue);
    }

    public double callOnLogicalServer(DoubleSupplier code, double invalidSideReturnValue) {
        if (null == this.level) {
            return invalidSideReturnValue;
        }
        return CodeHelper.callOnLogicalServer(this.level, code, invalidSideReturnValue);
    }

    public void callOnLogicalClient(Runnable code) {
        if (null != this.level) {
            CodeHelper.callOnLogicalClient(this.level, code);
        }
    }

    public void callOnLogicalClient(Consumer<Level> code) {
        if (null != this.level && CodeHelper.calledByLogicalClient(this.level)) {
            code.accept(this.level);
        }
    }

    public <T> T callOnLogicalClient(Supplier<T> code, Supplier<T> invalidSideReturnValue) {
        if (null == this.level) {
            return invalidSideReturnValue.get();
        }
        return CodeHelper.callOnLogicalClient(this.level, code, invalidSideReturnValue);
    }

    public boolean callOnLogicalClient(BooleanSupplier code) {
        return null != this.level && CodeHelper.callOnLogicalClient(this.level, code);
    }

    public int callOnLogicalClient(IntSupplier code, int invalidSideReturnValue) {
        if (null == this.level) {
            return invalidSideReturnValue;
        }
        return CodeHelper.callOnLogicalClient(this.level, code, invalidSideReturnValue);
    }

    public long callOnLogicalClient(LongSupplier code, long invalidSideReturnValue) {
        if (null == this.level) {
            return invalidSideReturnValue;
        }
        return CodeHelper.callOnLogicalClient(this.level, code, invalidSideReturnValue);
    }

    public double callOnLogicalClient(DoubleSupplier code, double invalidSideReturnValue) {
        if (null == this.level) {
            return invalidSideReturnValue;
        }
        return CodeHelper.callOnLogicalClient(this.level, code, invalidSideReturnValue);
    }

    public boolean canOpenGui(Level world, BlockPos position, BlockState state) {
        return false;
    }

    public boolean openGui(ServerPlayer player) {
        return this.openGuiOnClient(player, buffer -> {});
    }

    public boolean openGui(ServerPlayer player, Consumer<RegistryFriendlyByteBuf> extraDataWriter) {
        return this.openGuiOnClient(player, extraDataWriter);
    }

    public static <T extends AbstractModBlockEntity> T getGuiClientBlockEntity(FriendlyByteBuf networkData) {
        return (T)((AbstractModBlockEntity)WorldHelper.getClientTile(networkData.readBlockPos()).orElseThrow(NullPointerException::new));
    }

    public void loadAdditional(CompoundTag data, HolderLookup.Provider registries) {
        super.loadAdditional(data, registries);
        this.syncEntityDataFrom(data, registries, ISyncableEntity.SyncReason.FullSync);
    }

    protected void saveAdditional(CompoundTag data, HolderLookup.Provider registries) {
        super.saveAdditional(data, registries);
        this.syncEntityDataTo(data, registries, ISyncableEntity.SyncReason.FullSync);
    }

    public void handleUpdateTag(CompoundTag data, HolderLookup.Provider registries) {
        super.handleUpdateTag(data, registries);
        this.syncEntityDataFrom(data, registries, ISyncableEntity.SyncReason.NetworkUpdate);
    }

    public CompoundTag getUpdateTag(HolderLookup.Provider registries) {
        return this.syncEntityDataTo(super.getUpdateTag(registries), registries, ISyncableEntity.SyncReason.NetworkUpdate);
    }

    public final void onDataPacket(Connection net, ClientboundBlockEntityDataPacket packet, HolderLookup.Provider registries) {
        super.onDataPacket(net, packet, registries);
        CompoundTag data = packet.getTag();
        if (null != data) {
            this.syncEntityDataFrom(packet.getTag(), registries, ISyncableEntity.SyncReason.NetworkUpdate);
        }
    }

    @Nullable
    public ClientboundBlockEntityDataPacket getUpdatePacket() {
        return ClientboundBlockEntityDataPacket.create((BlockEntity)this);
    }

    protected void onDataUpdate() {
        this.DataUpdate.raise(Runnable::run);
    }

    private void syncEntityDataFrom(CompoundTag data, HolderLookup.Provider registries, ISyncableEntity.SyncReason syncReason) {
        CompoundTag dataToSync = data;
        if (syncReason.isFullSync() && data.contains("zcvase_version") && data.contains("zcvase_payload")) {
            CompoundTag payload = dataToSync = data.getCompound("zcvase_payload");
            if (this instanceof IVersionAwareSyncableEntity) {
                IVersionAwareSyncableEntity vase = (IVersionAwareSyncableEntity)((Object)this);
                int dataVersion = data.getInt("zcvase_version");
                if (vase.syncGetDataCurrentVersion() > dataVersion) {
                    dataToSync = vase.syncGetVersionConverter(dataVersion).apply(payload);
                }
            }
        }
        this.syncDataFrom(dataToSync, registries, syncReason);
        this.onDataUpdate();
    }

    private CompoundTag syncEntityDataTo(CompoundTag data, HolderLookup.Provider registries, ISyncableEntity.SyncReason syncReason) {
        if (syncReason.isFullSync()) {
            data.putInt("zcvase_version", this.syncGetEntityDataCurrentVersion());
            data.put("zcvase_payload", (Tag)this.syncDataTo(new CompoundTag(), registries, syncReason));
            return data;
        }
        return this.syncDataTo(data, registries, syncReason);
    }

    private int syncGetEntityDataCurrentVersion() {
        return this instanceof IVersionAwareSyncableEntity ? ((IVersionAwareSyncableEntity)((Object)this)).syncGetDataCurrentVersion() : -1;
    }

    public void sendCommandToServer(String name) {
        this.sendCommandToServer(name, NBTHelper.EMPTY_COMPOUND);
    }

    public void sendCommandToServer(String name, CompoundTag parameters) {
        Lib.sendBlockEntityMessage(this, name, parameters);
    }

    public void sendCommandToPlayer(ServerPlayer player, String name) {
        this.sendCommandToPlayer(player, name, NBTHelper.EMPTY_COMPOUND);
    }

    public void sendCommandToPlayer(ServerPlayer player, String name, CompoundTag parameters) {
        Lib.sendBlockEntityMessage(player, this, name, parameters);
    }

    public void handleCommand(PacketFlow flow, String name, CompoundTag parameters) {
        this._commandDispatcher.dispatch(flow, name, parameters);
    }

    protected void setCommandDispatcher(ITileCommandDispatcher dispatcher) {
        this._commandDispatcher = Objects.requireNonNull(dispatcher);
    }

    public void markChunkDirty() {
        Level world = this.getLevel();
        if (null != world) {
            world.blockEntityChanged(this.getBlockPos());
        }
    }

    public void callNeighborBlockChange() {
        Level world = this.getLevel();
        if (null != world) {
            WorldHelper.notifyNeighborsOfStateChange(world, this.getBlockPos(), this.getBlockState().getBlock());
        }
    }

    public void notifyBlockUpdate() {
        if (this.hasLevel()) {
            this.notifyBlockUpdate(this.getBlockState(), this.getBlockState());
        }
    }

    public void notifyBlockUpdate(BlockState oldState, BlockState newState) {
        Level world = this.getLevel();
        if (null != world) {
            WorldHelper.notifyBlockUpdate(world, this.getBlockPos(), oldState, newState);
        }
    }

    public static <T extends AbstractModBlockEntity> void notifyBlockUpdate(Collection<T> entities) {
        entities.forEach(AbstractModBlockEntity::notifyBlockUpdate);
    }

    public static <T extends AbstractModBlockEntity> void notifyBlockUpdate(Stream<T> entities) {
        entities.forEach(AbstractModBlockEntity::notifyBlockUpdate);
    }

    public void notifyTileEntityUpdate() {
        Level world = this.getLevel();
        if (null != world) {
            this.setChanged();
            WorldHelper.notifyBlockUpdate(world, this.getBlockPos(), this.getBlockState(), this.getBlockState());
        }
    }

    public void markForRenderUpdate() {
        if (null != this.level && this.level.isClientSide()) {
            WorldHelper.markBlockRangeForRenderUpdate(this.level, this.getBlockPos(), this.getBlockPos());
        }
    }

    public void requestClientRenderUpdate() {
        if (null != this.level && this.level.isClientSide()) {
            CodeHelper.executeOnClientThread(() -> this.level.blockEvent(this.getBlockPos(), this.getBlockType(), 1, 0));
        }
    }

    public boolean triggerEvent(int id, int type) {
        if (null != this.level) {
            switch (id) {
                case 1: {
                    this.callOnLogicalClient(this::markForRenderUpdate);
                    return true;
                }
            }
        }
        return super.triggerEvent(id, type);
    }

    @Override
    public void updateBlockState(BlockState currentState, LevelAccessor world, BlockPos position, @Nullable BlockEntity tileEntity, int updateFlags) {
        Block block = currentState.getBlock();
        if (block instanceof IBlockStateUpdater) {
            ((IBlockStateUpdater)block).updateBlockState(currentState, world, position, tileEntity, updateFlags);
        } else {
            world.setBlock(position, this.buildUpdatedState(currentState, (BlockGetter)world, position, tileEntity), updateFlags);
        }
    }

    @Override
    @NotNull
    public BlockState buildUpdatedState(BlockState currentState, BlockGetter reader, BlockPos position, @Nullable BlockEntity tileEntity) {
        return currentState;
    }

    @Override
    public void getDebugMessages(LogicalSide side, IDebugMessages messages) {
        messages.addUnlocalized("Tile Entity class: %1$s", this.getClass().getSimpleName());
    }

    private boolean openGuiOnClient(ServerPlayer player, Consumer<RegistryFriendlyByteBuf> extraDataWriter) {
        return this.callOnLogicalServer(() -> {
            AbstractModBlockEntity patt0$temp = this;
            if (patt0$temp instanceof MenuProvider) {
                MenuProvider provider = (MenuProvider)patt0$temp;
                if (!(player instanceof FakePlayer)) {
                    Consumer<RegistryFriendlyByteBuf> positionWriter = buffer -> buffer.writeBlockPos(this.getBlockPos());
                    player.openMenu(provider, positionWriter.andThen(extraDataWriter));
                    return true;
                }
            }
            return false;
        });
    }
}

