/*
 * Decompiled with CFR 0.152.
 */
package it.zerono.mods.zerocore.lib.client.gui.control;

import it.zerono.mods.zerocore.lib.client.gui.IWindow;
import it.zerono.mods.zerocore.lib.client.gui.ModContainerScreen;
import it.zerono.mods.zerocore.lib.client.gui.Padding;
import it.zerono.mods.zerocore.lib.client.gui.control.AbstractSwitchableButtonControl;
import it.zerono.mods.zerocore.lib.client.gui.layout.HorizontalAlignment;
import it.zerono.mods.zerocore.lib.client.gui.layout.VerticalAlignment;
import it.zerono.mods.zerocore.lib.event.Event;
import it.zerono.mods.zerocore.lib.event.IEvent;
import it.zerono.mods.zerocore.lib.item.inventory.container.ModContainer;
import java.util.function.Consumer;
import net.minecraft.client.gui.GuiGraphics;
import org.jetbrains.annotations.Nullable;

public class SwitchButton
extends AbstractSwitchableButtonControl {
    public final IEvent<Consumer<SwitchButton>> Activated;
    public final IEvent<Consumer<SwitchButton>> Deactivated;
    private boolean _pressed;
    private Padding _pressedPadding;

    public SwitchButton(ModContainerScreen<? extends ModContainer> gui, String name, String text, boolean active) {
        this(gui, name, text, active, null);
    }

    public SwitchButton(ModContainerScreen<? extends ModContainer> gui, String name, String text, boolean active, @Nullable String groupName) {
        super(gui, name, text, active, groupName);
        this.setPressed(false);
        this.setPadding(3, 3, 2, 2);
        this.setHorizontalAlignment(HorizontalAlignment.Center);
        this.setVerticalAlignment(VerticalAlignment.Center);
        this.Activated = new Event<Consumer<SwitchButton>>();
        this.Deactivated = new Event<Consumer<SwitchButton>>();
    }

    @Override
    public void onWindowClosed() {
        super.onWindowClosed();
        this.Activated.unsubscribeAll();
        this.Deactivated.unsubscribeAll();
    }

    @Override
    public Padding getPadding() {
        return this.getPressed() ? this._pressedPadding : super.getPadding();
    }

    @Override
    public void setPadding(int left, int right, int top, int bottom) {
        super.setPadding(left, right, top, bottom);
        this._pressedPadding = Padding.get(left + 1, right - 1, top + 1, bottom - 1);
    }

    @Override
    public boolean onMouseClicked(IWindow wnd, int mouseX, int mouseY, int clickedButton) {
        super.onMouseClicked(wnd, mouseX, mouseY, clickedButton);
        return true;
    }

    @Override
    public void onPaintBackground(GuiGraphics gfx, float partialTicks, int mouseX, int mouseY) {
        this.paintButton3D(gfx, this.getButtonState(), 0, 0, this.getBounds().Width, this.getBounds().Height);
    }

    @Override
    protected void onActivated() {
        this.Activated.raise(c -> c.accept(this));
    }

    @Override
    protected void onDeactivated() {
        this.Deactivated.raise(c -> c.accept(this));
    }

    @Override
    protected StringBuilder toStringBuilder() {
        return super.toStringBuilder().append(" pressed:").append(this._pressed);
    }

    protected boolean getPressed() {
        return this._pressed;
    }

    protected void setPressed(boolean pressed) {
        this._pressed = pressed;
    }
}

