/*
 * Decompiled with CFR 0.152.
 */
package it.zerono.mods.zerocore.lib.compat.patchouli.component.standardpage;

import com.google.gson.annotations.SerializedName;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Axis;
import it.zerono.mods.zerocore.internal.compat.patchouli.PatchouliService;
import it.zerono.mods.zerocore.lib.compat.patchouli.IPatchouliService;
import it.zerono.mods.zerocore.lib.compat.patchouli.component.standardpage.AbstractStandardPageComponent;
import java.util.function.UnaryOperator;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.renderer.ItemBlockRenderTypes;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.block.BlockRenderDispatcher;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.Vec3i;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.neoforged.neoforge.client.model.data.ModelData;
import org.joml.Matrix4f;
import org.joml.Matrix4fc;
import org.joml.Quaternionfc;
import org.joml.Vector4f;
import vazkii.patchouli.api.IMultiblock;
import vazkii.patchouli.api.IVariable;
import vazkii.patchouli.client.base.ClientTicker;
import vazkii.patchouli.client.book.BookContentsBuilder;
import vazkii.patchouli.client.book.BookEntry;
import vazkii.patchouli.client.book.BookPage;
import vazkii.patchouli.client.book.gui.GuiBook;
import vazkii.patchouli.client.book.gui.GuiBookEntry;
import vazkii.patchouli.client.book.page.PageEmpty;
import vazkii.patchouli.common.book.Book;
import vazkii.patchouli.common.multiblock.AbstractMultiblock;
import vazkii.patchouli.common.multiblock.MultiblockRegistry;

public class Multiblock
extends AbstractStandardPageComponent<PageEmpty> {
    String name = "";
    @SerializedName(value="multiblock_id")
    String multiblockId;
    private transient Book book;
    private transient GuiBookEntry parent;
    private transient AbstractMultiblock multiblockObj;
    public transient Minecraft mc;
    private static final RandomSource RAND = RandomSource.create();

    protected Multiblock() {
        super(new PageEmpty());
    }

    public void onVariablesAvailable(UnaryOperator<IVariable> lookup, HolderLookup.Provider registries) {
        super.onVariablesAvailable(lookup, registries);
        this.multiblockId = ((IVariable)lookup.apply(IVariable.wrap((String)this.multiblockId, (HolderLookup.Provider)registries))).asString();
    }

    @Override
    public void build(BookContentsBuilder builder, BookPage page, BookEntry entry, int pageNum) {
        IMultiblock mb;
        this.book = page.book;
        if (this.multiblockId != null && (mb = (IMultiblock)MultiblockRegistry.MULTIBLOCKS.get(ResourceLocation.tryParse((String)this.multiblockId))) instanceof AbstractMultiblock) {
            this.multiblockObj = (AbstractMultiblock)mb;
        }
        if (this.multiblockObj == null) {
            throw new IllegalArgumentException("No multiblock located for " + this.multiblockId);
        }
    }

    @Override
    public void onDisplayed(BookPage page, GuiBookEntry parent, int left, int top) {
        this.parent = parent;
        this.mc = parent.getMinecraft();
    }

    @Override
    protected void renderPage(GuiGraphics graphics, int mouseX, int mouseY, float partialTicks) {
        int x = 5;
        int y = 7;
        RenderSystem.enableBlend();
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        GuiBook.drawFromTexture((GuiGraphics)graphics, (Book)this.book, (int)x, (int)y, (int)405, (int)149, (int)106, (int)106);
        this.parent.drawCenteredStringNoShadow(graphics, this.name, 58, 0, this.book.headerColor);
        if (this.multiblockObj != null) {
            this.renderMultiblock(graphics);
        }
    }

    private void renderMultiblock(GuiGraphics graphics) {
        this.multiblockObj.setWorld((Level)this.mc.level);
        PoseStack ms = graphics.pose();
        Vec3i size = this.multiblockObj.getSize();
        int sizeX = size.getX();
        int sizeY = size.getY();
        int sizeZ = size.getZ();
        float maxX = 90.0f;
        float maxY = 90.0f;
        float diag = (float)Math.sqrt(sizeX * sizeX + sizeZ * sizeZ);
        float scaleX = maxX / diag;
        float scaleY = maxY / (float)sizeY;
        float scale = -Math.min(scaleX, scaleY);
        int xPos = 58;
        int yPos = 60;
        ms.pushPose();
        ms.translate((float)xPos, (float)yPos, 100.0f);
        ms.scale(scale, scale, scale);
        ms.translate(-((float)sizeX) / 2.0f, -((float)sizeY) / 2.0f, 0.0f);
        Vector4f eye = new Vector4f(0.0f, 0.0f, -100.0f, 1.0f);
        Matrix4f rotMat = new Matrix4f();
        rotMat.identity();
        ms.mulPose(Axis.XP.rotationDegrees(-30.0f));
        rotMat.rotation((Quaternionfc)Axis.XP.rotationDegrees(30.0f));
        float offX = (float)(-sizeX) / 2.0f;
        float offZ = (float)(-sizeZ) / 2.0f + 1.0f;
        float time = (float)this.parent.ticksInBook * 0.5f;
        if (!Screen.hasShiftDown()) {
            time += ClientTicker.partialTicks;
        }
        ms.translate(-offX, 0.0f, -offZ);
        ms.mulPose(Axis.YP.rotationDegrees(time));
        rotMat.rotation((Quaternionfc)Axis.YP.rotationDegrees(-time));
        ms.mulPose(Axis.YP.rotationDegrees(45.0f));
        rotMat.rotation((Quaternionfc)Axis.YP.rotationDegrees(-45.0f));
        ms.translate(offX, 0.0f, offZ);
        eye.mul((Matrix4fc)rotMat);
        this.renderElements(ms, this.multiblockObj, BlockPos.betweenClosed((BlockPos)BlockPos.ZERO, (BlockPos)new BlockPos(sizeX - 1, sizeY - 1, sizeZ - 1)), eye);
        ms.popPose();
    }

    private void renderElements(PoseStack ms, AbstractMultiblock mb, Iterable<? extends BlockPos> blocks, Vector4f eye) {
        ms.pushPose();
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        ms.translate(0.0f, 0.0f, -1.0f);
        MultiBufferSource.BufferSource buffers = Minecraft.getInstance().renderBuffers().bufferSource();
        this.doWorldRenderPass(ms, mb, blocks, buffers, eye);
        buffers.endBatch();
        ms.popPose();
    }

    private void doWorldRenderPass(PoseStack ms, AbstractMultiblock mb, Iterable<? extends BlockPos> blocks, MultiBufferSource.BufferSource buffers, Vector4f eye) {
        BlockRenderDispatcher blockRenderer = Minecraft.getInstance().getBlockRenderer();
        Object object = IPatchouliService.SERVICE.get();
        if (!(object instanceof PatchouliService)) {
            return;
        }
        PatchouliService patchouli = (PatchouliService)object;
        for (BlockPos blockPos : blocks) {
            BlockState bs = mb.getBlockState(blockPos);
            BlockState renderBlockState = patchouli.getRenderBlockStateFor((IMultiblock)mb, bs);
            ModelData renderModelData = patchouli.getModelDataFor((IMultiblock)mb, bs);
            VertexConsumer buffer = buffers.getBuffer(ItemBlockRenderTypes.getChunkRenderType((BlockState)bs));
            ms.pushPose();
            ms.translate((float)blockPos.getX(), (float)blockPos.getY(), (float)blockPos.getZ());
            blockRenderer.renderBatched(renderBlockState, blockPos, (BlockAndTintGetter)mb, ms, buffer, false, RAND, renderModelData, null);
            ms.popPose();
        }
    }
}

