/*
 * Decompiled with CFR 0.152.
 */
package it.zerono.mods.zerocore.lib.datagen.provider.loot;

import com.google.common.base.Preconditions;
import it.unimi.dsi.fastutil.objects.ObjectOpenHashSet;
import java.util.Set;
import java.util.function.Function;
import java.util.function.Supplier;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.data.loot.BlockLootSubProvider;
import net.minecraft.world.flag.FeatureFlagSet;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.storage.loot.LootPool;
import net.minecraft.world.level.storage.loot.LootTable;
import net.minecraft.world.level.storage.loot.entries.LootItem;
import net.minecraft.world.level.storage.loot.entries.LootPoolEntryContainer;
import net.minecraft.world.level.storage.loot.functions.CopyComponentsFunction;
import net.minecraft.world.level.storage.loot.functions.LootItemFunction;
import net.minecraft.world.level.storage.loot.providers.number.ConstantValue;
import net.minecraft.world.level.storage.loot.providers.number.NumberProvider;

public abstract class ModBlockLootSubProvider
extends BlockLootSubProvider {
    private final Set<Block> _registeredBlocks = new ObjectOpenHashSet(128);

    protected ModBlockLootSubProvider(Set<Item> explosionResistantItems, FeatureFlagSet enabledFeatures, HolderLookup.Provider provider) {
        super(explosionResistantItems, enabledFeatures, provider);
    }

    protected void add(Block block, LootTable.Builder builder) {
        Preconditions.checkState((boolean)this._registeredBlocks.add(block), (String)"Block %s was already added to this sub provider", (Object)block);
        super.add(block, builder);
    }

    protected void add(Supplier<? extends Block> block, LootTable.Builder builder) {
        this.add(block.get(), builder);
    }

    protected void add(Supplier<? extends Block> block, Function<Block, LootTable.Builder> mapper) {
        this.add(block.get(), mapper);
    }

    protected void otherWhenSilkTouch(Supplier<? extends Block> block, Supplier<? extends Block> drop) {
        this.otherWhenSilkTouch(block.get(), drop.get());
    }

    protected void dropWhenSilkTouch(Supplier<? extends Block> block) {
        this.dropWhenSilkTouch(block.get());
    }

    @SafeVarargs
    protected final void dropWhenSilkTouch(Supplier<? extends Block> block, Supplier<? extends Block> ... others) {
        this.dropWhenSilkTouch(block);
        for (Supplier<? extends Block> other : others) {
            this.dropWhenSilkTouch(other);
        }
    }

    protected void dropOther(Supplier<? extends Block> block, Supplier<? extends ItemLike> drop) {
        this.dropOther(block.get(), drop.get());
    }

    protected void dropSelf(Supplier<? extends Block> block) {
        this.dropOther(block, block);
    }

    @SafeVarargs
    protected final void dropSelf(Supplier<? extends Block> block, Supplier<? extends Block> ... others) {
        this.dropSelf(block);
        for (Supplier<? extends Block> other : others) {
            this.dropSelf(other);
        }
    }

    protected void dropOre(Supplier<? extends Block> ore, Supplier<? extends Item> drop) {
        this.add(ore.get(), block -> this.createOreDrop((Block)block, (Item)drop.get()));
    }

    protected void dropWithComponents(Block block, DataComponentType<?> component, DataComponentType<?> ... otherComponents) {
        CopyComponentsFunction.Builder componentsBuilder = CopyComponentsFunction.copyComponents((CopyComponentsFunction.Source)CopyComponentsFunction.Source.BLOCK_ENTITY);
        componentsBuilder.include(component);
        for (DataComponentType<?> other : otherComponents) {
            componentsBuilder.include(other);
        }
        LootTable.Builder tableBuilder = LootTable.lootTable().withPool(LootPool.lootPool().setRolls((NumberProvider)ConstantValue.exactly((float)1.0f)).add((LootPoolEntryContainer.Builder)LootItem.lootTableItem((ItemLike)block).apply((LootItemFunction.Builder)componentsBuilder)));
        this.add(block, tableBuilder);
    }

    protected void dropWithComponents(Supplier<? extends Block> block, DataComponentType<?> component, DataComponentType<?> ... otherComponents) {
        this.dropWithComponents(block.get(), component, otherComponents);
    }

    protected Iterable<Block> getKnownBlocks() {
        return this._registeredBlocks;
    }
}

