/*
 * Decompiled with CFR 0.152.
 */
package it.zerono.mods.zerocore.lib.item.inventory.container.data.sync;

import com.google.common.base.Preconditions;
import io.netty.buffer.ByteBuf;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import it.unimi.dsi.fastutil.shorts.Short2ObjectArrayMap;
import it.unimi.dsi.fastutil.shorts.Short2ObjectMap;
import it.unimi.dsi.fastutil.shorts.Short2ObjectMaps;
import it.zerono.mods.zerocore.ZeroCore;
import it.zerono.mods.zerocore.internal.Lib;
import it.zerono.mods.zerocore.internal.Log;
import it.zerono.mods.zerocore.lib.item.inventory.container.ModContainer;
import it.zerono.mods.zerocore.lib.item.inventory.container.data.IContainerData;
import it.zerono.mods.zerocore.lib.item.inventory.container.data.sync.ISyncedSetEntry;
import it.zerono.mods.zerocore.lib.network.AbstractPlayPacket;
import java.util.List;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.neoforged.neoforge.network.handling.IPayloadContext;
import net.neoforged.neoforge.network.registration.PayloadRegistrar;
import org.jetbrains.annotations.Nullable;

public class ContainerDataHandler {
    private static final int MAX_DATA = 256;
    private final ModContainer _container;
    private final List<IContainerData> _data;
    public boolean _canSendUpdates;

    public static void registerPackets(PayloadRegistrar registrar) {
        registrar.playToClient(ContainerSyncPacket.TYPE, ContainerSyncPacket.STREAM_CODEC, ContainerSyncPacket::handlePacket);
        registrar.playToServer(ContainerSyncAckPacket.TYPE, ContainerSyncAckPacket.STREAM_CODEC, ContainerSyncAckPacket::handlePacket);
    }

    public ContainerDataHandler(ModContainer container) {
        Preconditions.checkNotNull((Object)((Object)container), (Object)"Container must not be null");
        this._container = container;
        this._data = new ObjectArrayList(8);
        this._canSendUpdates = false;
    }

    public void add(IContainerData datum) {
        if (256 == this._data.size()) {
            throw new IllegalStateException("Can't add more sync data entries");
        }
        this._data.add(datum);
    }

    public void broadcastChanges(ServerPlayer player) {
        if (this._canSendUpdates && !this._data.isEmpty()) {
            SyncSet syncSet = this.getUpdates();
            if (syncSet.isEmpty()) {
                return;
            }
            ContainerSyncPacket.send(player, syncSet);
        }
    }

    public void onScreenOpened() {
        ContainerSyncAckPacket.send(this._container.containerId);
    }

    private static void serializeSyncSet(SyncSet set, RegistryFriendlyByteBuf buffer) {
        Short2ObjectMap<ISyncedSetEntry> entries = set.entries();
        buffer.writeInt(set.containerId);
        buffer.writeShort(entries.size());
        for (Short2ObjectMap.Entry mapEntry : entries.short2ObjectEntrySet()) {
            buffer.writeShort((int)mapEntry.getShortKey());
            ((ISyncedSetEntry)mapEntry.getValue()).accept(buffer);
        }
    }

    private static SyncSet deserializeSyncSet(RegistryFriendlyByteBuf buffer) {
        ContainerDataHandler handler = ContainerDataHandler.getClientSideContainerDataHandler();
        if (null == handler) {
            buffer.clear();
            return SyncSet.EMPTY;
        }
        return handler.getUpdates(buffer);
    }

    private SyncSet getUpdates() {
        Short2ObjectArrayMap entries = new Short2ObjectArrayMap(this._data.size());
        for (short index = 0; index < this._data.size(); index = (short)(index + 1)) {
            ISyncedSetEntry entry = this._data.get(index).getChangedValue();
            if (null == entry) continue;
            entries.put(index, (Object)entry);
        }
        if (entries.isEmpty()) {
            return SyncSet.EMPTY;
        }
        return new SyncSet(this._container.containerId, (Short2ObjectMap<ISyncedSetEntry>)entries);
    }

    private SyncSet getUpdates(RegistryFriendlyByteBuf buffer) {
        int remoteContainerId = buffer.readInt();
        short count = buffer.readShort();
        if (count > 256) {
            buffer.clear();
            return SyncSet.EMPTY;
        }
        Short2ObjectArrayMap entries = new Short2ObjectArrayMap((int)count);
        for (short i = 0; i < count; i = (short)(i + 1)) {
            short index = buffer.readShort();
            if (index < 0 || index >= this._data.size()) continue;
            entries.put(index, (Object)this._data.get(index).getValueFrom(buffer));
        }
        return new SyncSet(remoteContainerId, (Short2ObjectMap<ISyncedSetEntry>)entries);
    }

    private void syncAckFrom(int containerId) {
        if (containerId == this._container.containerId) {
            this._canSendUpdates = true;
        } else {
            Log.LOGGER.warn(Log.NETWORK, "Got a sync ack from another container! Ignoring. ({} / {})", (Object)containerId, (Object)this._container.containerId);
        }
    }

    private void syncFrom(SyncSet changes) {
        if (this._container.containerId != changes.containerId) {
            return;
        }
        for (Short2ObjectMap.Entry mapEntry : changes.entries().short2ObjectEntrySet()) {
            short index = mapEntry.getShortKey();
            if (index < 0 || index >= this._data.size()) continue;
            this._data.get(index).updateFrom((ISyncedSetEntry)mapEntry.getValue());
        }
    }

    @Nullable
    private static ContainerDataHandler getClientSideContainerDataHandler() {
        ModContainer container = ZeroCore.getProxy().getCurrentClientSideModContainer();
        return null == container ? null : container.getContainerDataHandler();
    }

    public static class ContainerSyncPacket
    extends AbstractPlayPacket<ContainerSyncPacket> {
        public static final CustomPacketPayload.Type<ContainerSyncPacket> TYPE = ContainerSyncPacket.createType(ZeroCore.ROOT_LOCATION, "container_sync");
        public static final StreamCodec<RegistryFriendlyByteBuf, ContainerSyncPacket> STREAM_CODEC = StreamCodec.composite(SyncSet.STREAM_CODEC, packet -> packet._syncSet, ContainerSyncPacket::new);
        private final SyncSet _syncSet;

        static void send(ServerPlayer player, SyncSet syncSet) {
            Lib.NETWORK_HANDLER.sendToPlayer(player, new ContainerSyncPacket(syncSet), new CustomPacketPayload[0]);
        }

        @Override
        public void handlePacket(IPayloadContext context) {
            ContainerDataHandler handler = ContainerDataHandler.getClientSideContainerDataHandler();
            if (null != handler) {
                handler.syncFrom(this._syncSet);
            }
        }

        private ContainerSyncPacket(SyncSet syncSet) {
            super(TYPE);
            Preconditions.checkNotNull((Object)syncSet, (Object)"Sync set must not be null");
            this._syncSet = syncSet;
        }
    }

    public static class ContainerSyncAckPacket
    extends AbstractPlayPacket<ContainerSyncAckPacket> {
        public static final CustomPacketPayload.Type<ContainerSyncAckPacket> TYPE = ContainerSyncAckPacket.createType(ZeroCore.ROOT_LOCATION, "container_sync_ack");
        public static final StreamCodec<ByteBuf, ContainerSyncAckPacket> STREAM_CODEC = StreamCodec.composite((StreamCodec)ByteBufCodecs.INT, packet -> packet._containerId, ContainerSyncAckPacket::new);
        private final int _containerId;

        static void send(int containerId) {
            Lib.NETWORK_HANDLER.sendToServer(new ContainerSyncAckPacket(containerId), new CustomPacketPayload[0]);
        }

        @Override
        public void handlePacket(IPayloadContext context) {
            AbstractContainerMenu abstractContainerMenu = context.player().containerMenu;
            if (abstractContainerMenu instanceof ModContainer) {
                ModContainer container = (ModContainer)abstractContainerMenu;
                container.getContainerDataHandler().syncAckFrom(this._containerId);
            }
        }

        private ContainerSyncAckPacket(int containerId) {
            super(TYPE);
            this._containerId = containerId;
        }
    }

    private record SyncSet(int containerId, Short2ObjectMap<ISyncedSetEntry> entries) {
        public static final SyncSet EMPTY = new SyncSet(-1, (Short2ObjectMap<ISyncedSetEntry>)Short2ObjectMaps.emptyMap());
        public static final StreamCodec<RegistryFriendlyByteBuf, SyncSet> STREAM_CODEC = StreamCodec.ofMember(ContainerDataHandler::serializeSyncSet, ContainerDataHandler::deserializeSyncSet);

        public boolean isEmpty() {
            return this == EMPTY || this.entries.isEmpty();
        }
    }
}

