/*
 * Decompiled with CFR 0.152.
 */
package it.zerono.mods.zerocore.lib.recipe.result;

import it.zerono.mods.zerocore.lib.CodeHelper;
import it.zerono.mods.zerocore.lib.data.ModCodecs;
import it.zerono.mods.zerocore.lib.recipe.result.IRecipeResult;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;

public class ItemStackRecipeResult
implements IRecipeResult<ItemStack> {
    public static final ModCodecs<ItemStackRecipeResult, RegistryFriendlyByteBuf> CODECS = new ModCodecs(ItemStack.CODEC.xmap(ItemStackRecipeResult::from, ItemStackRecipeResult::getResult), StreamCodec.composite((StreamCodec)ItemStack.STREAM_CODEC, ItemStackRecipeResult::getResult, ItemStackRecipeResult::new));
    private final ItemStack _result;

    public static ItemStackRecipeResult from(ItemStack stack) {
        return new ItemStackRecipeResult(stack);
    }

    public static ItemStackRecipeResult from(ItemLike item) {
        return ItemStackRecipeResult.from(item, 1);
    }

    public static ItemStackRecipeResult from(ItemLike item, int amount) {
        return ItemStackRecipeResult.from(new ItemStack(item, amount));
    }

    @Override
    public ResourceLocation getId() {
        return CodeHelper.getObjectId(this._result.getItem());
    }

    @Override
    public ItemStack getResult() {
        return this._result.copy();
    }

    @Override
    public long getAmount() {
        return this._result.isEmpty() ? 0L : (long)this._result.getCount();
    }

    @Override
    public boolean isEmpty() {
        return this._result.isEmpty();
    }

    public String toString() {
        return this._result.toString();
    }

    private ItemStackRecipeResult(ItemStack stack) {
        this._result = stack;
    }
}

