/*
 * Decompiled with CFR 0.152.
 */
package com.hollingsworth.arsnouveau.api.documentation.search;

import com.hollingsworth.arsnouveau.api.documentation.entry.DocEntry;
import com.hollingsworth.arsnouveau.api.documentation.search.ConnectedSearch;
import com.hollingsworth.arsnouveau.api.documentation.search.NGramAnalyzer;
import com.hollingsworth.arsnouveau.api.registry.DocumentationRegistry;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import org.apache.lucene.ars_nouveau.analysis.Analyzer;
import org.apache.lucene.ars_nouveau.analysis.en.EnglishAnalyzer;
import org.apache.lucene.ars_nouveau.analysis.miscellaneous.PerFieldAnalyzerWrapper;
import org.apache.lucene.ars_nouveau.analysis.standard.StandardAnalyzer;
import org.apache.lucene.ars_nouveau.document.Document;
import org.apache.lucene.ars_nouveau.document.Field;
import org.apache.lucene.ars_nouveau.document.StoredField;
import org.apache.lucene.ars_nouveau.document.TextField;
import org.apache.lucene.ars_nouveau.index.DirectoryReader;
import org.apache.lucene.ars_nouveau.index.IndexWriter;
import org.apache.lucene.ars_nouveau.index.IndexWriterConfig;
import org.apache.lucene.ars_nouveau.index.StoredFields;
import org.apache.lucene.ars_nouveau.queryparser.classic.MultiFieldQueryParser;
import org.apache.lucene.ars_nouveau.queryparser.classic.ParseException;
import org.apache.lucene.ars_nouveau.queryparser.classic.QueryParser;
import org.apache.lucene.ars_nouveau.search.BooleanClause;
import org.apache.lucene.ars_nouveau.search.BooleanQuery;
import org.apache.lucene.ars_nouveau.search.IndexSearcher;
import org.apache.lucene.ars_nouveau.search.Query;
import org.apache.lucene.ars_nouveau.search.ScoreDoc;
import org.apache.lucene.ars_nouveau.search.TopDocs;
import org.apache.lucene.ars_nouveau.store.MMapDirectory;

public class Search {
    public static IndexSearcher searcher;
    public static PerFieldAnalyzerWrapper analyzer;
    public static List<ConnectedSearch> connectedSearches;
    public static Map<Item, DocEntry> itemToEntryMap;

    public static void addConnectedSearch(ConnectedSearch connectedSearch) {
        connectedSearches.add(connectedSearch);
    }

    public static void initSearchIndex() {
        try {
            Map<String, Analyzer> perFieldAnalyzer = Map.of("title", new EnglishAnalyzer(), "titleGrams", new NGramAnalyzer(2, 3), "tags", new EnglishAnalyzer());
            analyzer = new PerFieldAnalyzerWrapper(new StandardAnalyzer(), perFieldAnalyzer);
            Files.createDirectories(Path.of("./config/ars_nouveau/", new String[0]), new FileAttribute[0]);
            try (MMapDirectory directory = new MMapDirectory(Path.of("./config/ars_nouveau/search_index", new String[0]));){
                Document document;
                IndexWriter writer = new IndexWriter(directory, new IndexWriterConfig(analyzer));
                writer.deleteAll();
                for (DocEntry docEntry : DocumentationRegistry.getEntries()) {
                    document = new Document();
                    document.add(new StoredField("ID", docEntry.id().toString()));
                    document.add(new TextField("title", docEntry.entryTitle().getString(), Field.Store.YES));
                    document.add(new TextField("titleGrams", docEntry.entryTitle().getString(), Field.Store.YES));
                    for (Component tag : docEntry.searchTags()) {
                        document.add(new TextField("tags", tag.getString(), Field.Store.YES));
                    }
                    writer.addDocument(document);
                    if (docEntry.renderStack().isEmpty()) continue;
                    itemToEntryMap.put(docEntry.renderStack().getItem(), docEntry);
                }
                for (int i = 0; i < connectedSearches.size(); ++i) {
                    ConnectedSearch connectedSearch = connectedSearches.get(i);
                    document = new Document();
                    document.add(new StoredField("ID", connectedSearch.entryId().toString()));
                    document.add(new StoredField("connectedIndex", i));
                    document.add(new TextField("title", connectedSearch.title().getString(), Field.Store.YES));
                    document.add(new TextField("titleGrams", connectedSearch.title().getString(), Field.Store.YES));
                    if (!connectedSearch.icon().isEmpty()) {
                        itemToEntryMap.put(connectedSearch.icon().getItem(), DocumentationRegistry.getEntry(connectedSearch.entryId()));
                    }
                    writer.addDocument(document);
                }
                writer.commit();
                DirectoryReader reader = DirectoryReader.open(writer);
                searcher = new IndexSearcher(reader);
                writer.close();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static List<Result> search(String query) {
        if (query == null || query.isEmpty()) {
            return new ArrayList<Result>();
        }
        query = query.trim().toLowerCase();
        ArrayList<Result> results = new ArrayList<Result>();
        try {
            MultiFieldQueryParser parser = new MultiFieldQueryParser(new String[]{"title", "titleGrams", "tags"}, analyzer, Map.of("tags", Float.valueOf(2.0f), "title", Float.valueOf(4.0f), "titleGrams", Float.valueOf(0.5f)));
            parser.setDefaultOperator(QueryParser.Operator.OR);
            Query nGramQuery = parser.parse(query);
            if (nGramQuery == null) {
                return results;
            }
            BooleanQuery booleanClauses = new BooleanQuery.Builder().setMinimumNumberShouldMatch(1).add(nGramQuery, BooleanClause.Occur.SHOULD).build();
            TopDocs topDocs = searcher.search((Query)booleanClauses, 100);
            StoredFields storedFields = searcher.storedFields();
            for (ScoreDoc doc : topDocs.scoreDocs) {
                if (doc.score < 0.5f) continue;
                Document document = storedFields.document(doc.doc);
                ResourceLocation entryId = ResourceLocation.tryParse((String)document.get("ID"));
                String connectedIndex = document.get("connectedIndex");
                DocEntry entry = DocumentationRegistry.getEntry(entryId);
                if (connectedIndex != null) {
                    ConnectedSearch connectedSearch = connectedSearches.get(Integer.parseInt(connectedIndex));
                    results.add(new Result(entry, connectedSearch.title(), connectedSearch.icon()));
                    continue;
                }
                results.add(new Result(entry, entry.entryTitle(), entry.renderStack()));
            }
            String finalQuery = query;
            results.sort((a, b) -> {
                int aScore = a.entry.entryTitle().getString().toLowerCase(Locale.ROOT).startsWith(finalQuery) ? 1 : 0;
                int bScore = b.entry.entryTitle().getString().toLowerCase(Locale.ROOT).startsWith(finalQuery) ? 1 : 0;
                return bScore - aScore;
            });
        }
        catch (Exception e) {
            if (e instanceof ParseException) {
                return results;
            }
            e.printStackTrace();
        }
        return results;
    }

    static {
        analyzer = new PerFieldAnalyzerWrapper(new StandardAnalyzer());
        connectedSearches = new ArrayList<ConnectedSearch>();
        itemToEntryMap = new HashMap<Item, DocEntry>();
    }

    public record Result(DocEntry entry, Component displayTitle, ItemStack icon) {
    }
}

