/*
 * Decompiled with CFR 0.152.
 */
package com.hollingsworth.arsnouveau.common.entity.statemachine.starbuncle;

import com.hollingsworth.arsnouveau.common.entity.Starbuncle;
import com.hollingsworth.arsnouveau.common.entity.debug.DebugEvent;
import com.hollingsworth.arsnouveau.common.entity.goal.carbuncle.StarbyTransportBehavior;
import com.hollingsworth.arsnouveau.common.entity.statemachine.starbuncle.DecideStarbyActionState;
import com.hollingsworth.arsnouveau.common.entity.statemachine.starbuncle.StarbyState;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Position;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.pathfinder.Path;
import org.jetbrains.annotations.Nullable;

public class FindItemState
extends StarbyState {
    boolean itemStuck;
    List<ItemEntity> destList = new ArrayList<ItemEntity>();
    ItemEntity dest;
    int stuckTicks;
    Starbuncle starbyWithSpace;

    public FindItemState(Starbuncle starbuncle, StarbyTransportBehavior behavior, List<ItemEntity> destList) {
        super(starbuncle, behavior);
        this.destList = destList;
        this.starbyWithSpace = this.starbuncle.getStarbuncleWithSpace();
    }

    @Override
    public void onStart() {
        super.onStart();
        if (this.destList.isEmpty()) {
            return;
        }
        ArrayList<ItemEntity> validDestinations = new ArrayList<ItemEntity>();
        for (ItemEntity entity : this.destList) {
            if (this.behavior.getValidStorePos(entity.getItem()) == null) continue;
            validDestinations.add(entity);
        }
        this.destList = validDestinations;
        Collections.shuffle(this.destList);
        for (ItemEntity e : this.destList) {
            Path path = this.starbuncle.minecraftPathNav.createPath(BlockPos.containing((Position)e.position()), 1, 9);
            if (path == null || !path.canReach()) continue;
            this.dest = e;
            this.starbuncle.addGoalDebug(this, new DebugEvent("DestSet", "Dest set to " + String.valueOf(e)));
            break;
        }
    }

    public static List<ItemEntity> nearbyItems(Starbuncle starbuncle, StarbyTransportBehavior behavior) {
        return starbuncle.level.getEntitiesOfClass(ItemEntity.class, starbuncle.getAABB(), itemEntity -> !itemEntity.hasPickUpDelay() && itemEntity.isAlive() && behavior.getValidStorePos(itemEntity.getItem()) != null);
    }

    @Override
    @Nullable
    public StarbyState tick() {
        if (this.dest == null) {
            this.behavior.findItemBackoff = 30 + this.starbuncle.level.random.nextInt(30);
            this.starbuncle.addGoalDebug(this, new DebugEvent("NotReachable", "No pathable items nearby"));
            return new DecideStarbyActionState(this.starbuncle, this.behavior);
        }
        if (this.behavior.isPickupDisabled()) {
            return new DecideStarbyActionState(this.starbuncle, this.behavior);
        }
        ItemStack itemstack = this.starbyWithSpace.getHeldStack();
        if (!itemstack.isEmpty()) {
            this.starbuncle.addGoalDebug(this, new DebugEvent("ItemPickup", "Received item, ending."));
            this.starbuncle.getNavigation().stop();
            Starbuncle nextAvailableStarby = this.starbuncle.getStarbuncleWithSpace();
            List<ItemEntity> nearbyItems = FindItemState.nearbyItems(this.starbuncle, this.behavior);
            if (nextAvailableStarby != null && !nearbyItems.isEmpty()) {
                return new FindItemState(this.starbuncle, this.behavior, nearbyItems);
            }
            return new DecideStarbyActionState(this.starbuncle, this.behavior);
        }
        if (this.ticksRunning > 300) {
            this.starbuncle.addGoalDebug(this, new DebugEvent("TooLong", "Stopped finding item, time finding expired"));
            return new DecideStarbyActionState(this.starbuncle, this.behavior);
        }
        if (this.itemStuck || this.starbyWithSpace == null) {
            return new DecideStarbyActionState(this.starbuncle, this.behavior);
        }
        if (this.dest == null || this.dest.getItem().isEmpty() || this.dest.isRemoved()) {
            this.itemStuck = true;
            this.starbuncle.addGoalDebug(this, new DebugEvent("ItemRemoved", "Item removed during goal"));
            return new DecideStarbyActionState(this.starbuncle, this.behavior);
        }
        this.starbuncle.minecraftPathNav.stop();
        Path path = this.starbuncle.minecraftPathNav.createPath(BlockPos.containing((Position)this.dest.position()), 1, 9);
        if (path == null || !path.canReach()) {
            ++this.stuckTicks;
            if (this.stuckTicks > 100) {
                this.itemStuck = true;
                this.starbuncle.addGoalDebug(this, new DebugEvent("ItemStuck", "Item stuck for 5 seconds. Ending goal"));
            }
            return super.tick();
        }
        this.starbuncle.getNavigation().moveTo((Entity)this.dest, 1.4);
        this.starbuncle.addGoalDebug(this, new DebugEvent("PathTo", "Pathing to " + String.valueOf(this.dest)));
        return super.tick();
    }
}

