/*
 * Decompiled with CFR 0.152.
 */
package com.hollingsworth.arsnouveau.common.entity.statemachine.starbuncle;

import com.hollingsworth.arsnouveau.api.event.EventQueue;
import com.hollingsworth.arsnouveau.common.entity.Starbuncle;
import com.hollingsworth.arsnouveau.common.entity.debug.DebugEvent;
import com.hollingsworth.arsnouveau.common.entity.goal.carbuncle.StarbyTransportBehavior;
import com.hollingsworth.arsnouveau.common.entity.statemachine.starbuncle.DecideStarbyActionState;
import com.hollingsworth.arsnouveau.common.entity.statemachine.starbuncle.StarbyState;
import com.hollingsworth.arsnouveau.common.entity.statemachine.starbuncle.TravelToPosState;
import com.hollingsworth.arsnouveau.common.event.OpenChestEvent;
import java.util.Iterator;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.item.ItemStack;
import net.neoforged.neoforge.items.IItemHandler;

public class TakeItemState
extends TravelToPosState {
    public TakeItemState(Starbuncle starbuncle, StarbyTransportBehavior behavior, BlockPos target) {
        super(starbuncle, behavior, target, new DecideStarbyActionState(starbuncle, behavior));
    }

    @Override
    public StarbyState onDestinationReached() {
        Starbuncle passenger;
        Entity entity;
        IItemHandler iItemHandler = this.behavior.getItemCapFromTile(this.targetPos, (Direction)this.behavior.FROM_DIRECTION_MAP.get(this.targetPos.hashCode()));
        if (iItemHandler == null) {
            this.starbuncle.addGoalDebug(this, new DebugEvent("NoItemHandler", "No item handler at " + this.targetPos.toString()));
            return this.nextState;
        }
        this.giveStarbyStack(this.starbuncle, iItemHandler);
        if (this.starbuncle.getHeldStack().isEmpty()) {
            this.starbuncle.addGoalDebug(this, new DebugEvent("TakeFromChest", "No items to take? Cancelling goal."));
            return this.nextState;
        }
        this.starbuncle.addGoalDebug(this, new DebugEvent("SetHeld", "Taking " + this.starbuncle.getHeldStack().getHoverName().getString() + " from " + this.targetPos.toString()));
        this.starbuncle.level.playSound(null, this.starbuncle.getX(), this.starbuncle.getY(), this.starbuncle.getZ(), SoundEvents.ITEM_PICKUP, this.starbuncle.getSoundSource(), 1.0f, 1.0f);
        OpenChestEvent event = new OpenChestEvent((ServerLevel)this.level, this.targetPos, 20);
        event.open();
        EventQueue.getServerInstance().addEvent(event);
        Iterator iterator = this.starbuncle.getIndirectPassengers().iterator();
        while (iterator.hasNext() && (entity = (Entity)iterator.next()) instanceof Starbuncle && (passenger = (Starbuncle)entity).getHeldStack().isEmpty()) {
            this.giveStarbyStack(passenger, iItemHandler);
            if (passenger.getHeldStack().isEmpty()) break;
            this.starbuncle.addGoalDebug(this, new DebugEvent("SetHeldPassenger", "Taking " + passenger.getHeldStack().getHoverName().getString() + " from " + this.targetPos.toString()));
        }
        return this.nextState;
    }

    public void giveStarbyStack(Starbuncle starbuncle, IItemHandler iItemHandler) {
        for (int j = 0; j < iItemHandler.getSlots() && starbuncle.getHeldStack().isEmpty(); ++j) {
            int count;
            ItemStack stack = iItemHandler.getStackInSlot(j);
            if (stack.isEmpty() || (count = this.behavior.getMaxTake(iItemHandler.getStackInSlot(j))) <= 0) continue;
            starbuncle.setHeldStack(iItemHandler.extractItem(j, Math.min(count, stack.getMaxStackSize()), false));
        }
    }

    @Override
    public boolean isDestinationStillValid(BlockPos pos) {
        return this.behavior.isPositionValidTake(pos);
    }
}

