/*
 * Decompiled with CFR 0.152.
 */
package com.hollingsworth.arsnouveau.common.network;

import com.hollingsworth.arsnouveau.ArsNouveau;
import com.hollingsworth.arsnouveau.common.capability.ANPlayerData;
import com.hollingsworth.arsnouveau.common.capability.ANPlayerDataCap;
import com.hollingsworth.arsnouveau.common.network.AbstractPacket;
import com.hollingsworth.arsnouveau.setup.registry.AttachmentsRegistry;
import com.hollingsworth.arsnouveau.setup.registry.CapabilityRegistry;
import net.minecraft.client.Minecraft;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;

public class PacketSyncPlayerCap
extends AbstractPacket {
    CompoundTag tag;
    public static final CustomPacketPayload.Type<PacketSyncPlayerCap> TYPE = new CustomPacketPayload.Type(ArsNouveau.prefix("sync_player_cap"));
    public static final StreamCodec<RegistryFriendlyByteBuf, PacketSyncPlayerCap> CODEC = StreamCodec.ofMember(PacketSyncPlayerCap::toBytes, PacketSyncPlayerCap::new);

    public PacketSyncPlayerCap(RegistryFriendlyByteBuf buf) {
        this.tag = buf.readNbt();
    }

    @Override
    public void toBytes(RegistryFriendlyByteBuf buf) {
        buf.writeNbt((Tag)this.tag);
    }

    public PacketSyncPlayerCap(CompoundTag famCaps) {
        this.tag = famCaps;
    }

    @Override
    public void onClientReceived(Minecraft minecraft, Player playerEntity) {
        ANPlayerData data = new ANPlayerData();
        data.deserializeNBT((HolderLookup.Provider)playerEntity.registryAccess(), this.tag);
        playerEntity.setData(AttachmentsRegistry.PLAYER_DATA, (Object)data);
        ANPlayerDataCap cap = CapabilityRegistry.getPlayerDataCap((LivingEntity)ArsNouveau.proxy.getPlayer());
        if (cap != null) {
            cap.setPlayerData(data);
        }
    }

    public CustomPacketPayload.Type<? extends CustomPacketPayload> type() {
        return TYPE;
    }
}

