/*
 * Decompiled with CFR 0.152.
 */
package com.hollingsworth.arsnouveau.common.spell.effect;

import com.hollingsworth.arsnouveau.api.item.inv.InventoryManager;
import com.hollingsworth.arsnouveau.api.spell.AbstractAugment;
import com.hollingsworth.arsnouveau.api.spell.AbstractEffect;
import com.hollingsworth.arsnouveau.api.spell.SpellContext;
import com.hollingsworth.arsnouveau.api.spell.SpellResolver;
import com.hollingsworth.arsnouveau.api.spell.SpellSchool;
import com.hollingsworth.arsnouveau.api.spell.SpellSchools;
import com.hollingsworth.arsnouveau.api.spell.SpellStats;
import com.hollingsworth.arsnouveau.common.lib.GlyphLib;
import com.hollingsworth.arsnouveau.common.spell.augment.AugmentAOE;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Position;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.ExperienceOrb;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import net.neoforged.bus.api.Event;
import net.neoforged.neoforge.common.NeoForge;
import net.neoforged.neoforge.event.entity.player.ItemEntityPickupEvent;
import net.neoforged.neoforge.event.entity.player.PlayerXpEvent;
import org.jetbrains.annotations.NotNull;

public class EffectPickup
extends AbstractEffect {
    public static EffectPickup INSTANCE = new EffectPickup();

    private EffectPickup() {
        super(GlyphLib.EffectPickupID, "Item Pickup");
    }

    @Override
    public void onResolve(HitResult rayTraceResult, Level casterWorld, @Nullable LivingEntity shooter, SpellStats spellStats, SpellContext spellContext, SpellResolver resolver) {
        BlockPos pos = BlockPos.containing((Position)rayTraceResult.getLocation());
        double expansion = 2.0 + spellStats.getAoeMultiplier();
        Vec3 posVec = new Vec3((double)pos.getX(), (double)pos.getY(), (double)pos.getZ());
        Level world = spellContext.level;
        List entityList = world.getEntitiesOfClass(ItemEntity.class, new AABB(posVec.add(expansion, expansion, expansion), posVec.subtract(expansion, expansion, expansion)));
        InventoryManager manager = spellContext.getCaster().getInvManager().extractSlotMax(-1);
        for (ItemEntity i : entityList) {
            i.setPickUpDelay(0);
            ItemEntityPickupEvent.Pre pickupPre = (ItemEntityPickupEvent.Pre)NeoForge.EVENT_BUS.post((Event)new ItemEntityPickupEvent.Pre(this.getPlayer(shooter, (ServerLevel)world), i));
            ItemStack stack = i.getItem();
            if (stack.isEmpty() || pickupPre.canPickup().isFalse()) continue;
            stack = manager.insertStack(stack);
            i.setItem(stack);
            NeoForge.EVENT_BUS.post((Event)new ItemEntityPickupEvent.Post(this.getPlayer(shooter, (ServerLevel)casterWorld), i, stack));
        }
        List orbList = world.getEntitiesOfClass(ExperienceOrb.class, new AABB(posVec.add(expansion, expansion, expansion), posVec.subtract(expansion, expansion, expansion)));
        for (ExperienceOrb i : orbList) {
            PlayerXpEvent.PickupXp expPickup;
            Player player;
            if (!(shooter instanceof Player) || !this.isNotFakePlayer((Entity)(player = (Player)shooter)) || spellContext.castingTile != null || (expPickup = (PlayerXpEvent.PickupXp)NeoForge.EVENT_BUS.post((Event)new PlayerXpEvent.PickupXp(player, i))).isCanceled()) continue;
            player.giveExperiencePoints(i.value);
            i.remove(Entity.RemovalReason.DISCARDED);
        }
    }

    @Override
    @NotNull
    public Set<AbstractAugment> getCompatibleAugments() {
        return this.augmentSetOf(AugmentAOE.INSTANCE);
    }

    @Override
    public void addAugmentDescriptions(Map<AbstractAugment, String> map) {
        super.addAugmentDescriptions(map);
        map.put(AugmentAOE.INSTANCE, "Increases the radius of the pickup effect.");
    }

    @Override
    public String getBookDescription() {
        return "Picks up nearby items in a medium radius where this spell is activated. The range may be expanded with AOE.";
    }

    @Override
    public int getDefaultManaCost() {
        return 10;
    }

    @Override
    @NotNull
    public Set<SpellSchool> getSchools() {
        return this.setOf(SpellSchools.MANIPULATION);
    }
}

