/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.ars_nouveau.codecs;

import java.io.Closeable;
import java.io.IOException;
import java.util.ArrayList;
import org.apache.lucene.ars_nouveau.codecs.FieldsProducer;
import org.apache.lucene.ars_nouveau.codecs.NormsProducer;
import org.apache.lucene.ars_nouveau.index.Fields;
import org.apache.lucene.ars_nouveau.index.MappedMultiFields;
import org.apache.lucene.ars_nouveau.index.MergeState;
import org.apache.lucene.ars_nouveau.index.MultiFields;
import org.apache.lucene.ars_nouveau.index.ReaderSlice;

public abstract class FieldsConsumer
implements Closeable {
    protected FieldsConsumer() {
    }

    public abstract void write(Fields var1, NormsProducer var2) throws IOException;

    public void merge(MergeState mergeState, NormsProducer norms) throws IOException {
        ArrayList<FieldsProducer> fields = new ArrayList<FieldsProducer>();
        ArrayList<ReaderSlice> slices = new ArrayList<ReaderSlice>();
        int docBase = 0;
        for (int readerIndex = 0; readerIndex < mergeState.fieldsProducers.length; ++readerIndex) {
            FieldsProducer f = mergeState.fieldsProducers[readerIndex];
            int maxDoc = mergeState.maxDocs[readerIndex];
            if (f != null) {
                f.checkIntegrity();
                slices.add(new ReaderSlice(docBase, maxDoc, readerIndex));
                fields.add(f);
            }
            docBase += maxDoc;
        }
        MappedMultiFields mergedFields = new MappedMultiFields(mergeState, new MultiFields(fields.toArray(Fields.EMPTY_ARRAY), slices.toArray(ReaderSlice.EMPTY_ARRAY)));
        this.write(mergedFields, norms);
    }

    @Override
    public abstract void close() throws IOException;
}

