/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.ars_nouveau.facet;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Objects;
import org.apache.lucene.ars_nouveau.facet.Facets;
import org.apache.lucene.ars_nouveau.facet.FacetsCollector;
import org.apache.lucene.ars_nouveau.index.IndexReaderContext;
import org.apache.lucene.ars_nouveau.index.ReaderUtil;
import org.apache.lucene.ars_nouveau.search.ConjunctionUtils;
import org.apache.lucene.ars_nouveau.search.DocIdSetIterator;
import org.apache.lucene.ars_nouveau.search.IndexSearcher;
import org.apache.lucene.ars_nouveau.search.Query;
import org.apache.lucene.ars_nouveau.search.ScoreMode;
import org.apache.lucene.ars_nouveau.search.Scorer;
import org.apache.lucene.ars_nouveau.search.Weight;

public abstract class FacetCountsWithFilterQuery
extends Facets {
    protected final Query fastMatchQuery;

    protected FacetCountsWithFilterQuery(Query fastMatchQuery) {
        this.fastMatchQuery = fastMatchQuery;
    }

    protected DocIdSetIterator createIterator(FacetsCollector.MatchingDocs hits, DocIdSetIterator ... iterators) throws IOException {
        ArrayList<DocIdSetIterator> allIterators = new ArrayList<DocIdSetIterator>();
        allIterators.add(hits.bits().iterator());
        allIterators.addAll(Arrays.asList(iterators));
        if (allIterators.stream().anyMatch(Objects::isNull)) {
            return null;
        }
        if (this.fastMatchQuery != null) {
            IndexReaderContext topLevelContext = ReaderUtil.getTopLevelContext(hits.context());
            IndexSearcher searcher = new IndexSearcher(topLevelContext);
            searcher.setQueryCache(null);
            Weight fastMatchWeight = searcher.createWeight(searcher.rewrite(this.fastMatchQuery), ScoreMode.COMPLETE_NO_SCORES, 1.0f);
            Scorer s = fastMatchWeight.scorer(hits.context());
            if (s == null) {
                return null;
            }
            DocIdSetIterator fastMatchQueryIterator = s.iterator();
            allIterators.add(fastMatchQueryIterator);
        }
        if (allIterators.size() == 1) {
            return (DocIdSetIterator)allIterators.get(0);
        }
        return ConjunctionUtils.intersectIterators(allIterators);
    }
}

