/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.ars_nouveau.search.similarities;

import org.apache.lucene.ars_nouveau.search.CollectionStatistics;
import org.apache.lucene.ars_nouveau.search.Explanation;
import org.apache.lucene.ars_nouveau.search.TermStatistics;
import org.apache.lucene.ars_nouveau.search.similarities.Similarity;

public class BooleanSimilarity
extends Similarity {
    @Override
    public Similarity.SimScorer scorer(float boost, CollectionStatistics collectionStats, TermStatistics ... termStats) {
        return new BooleanWeight(boost);
    }

    private static class BooleanWeight
    extends Similarity.SimScorer {
        final float boost;

        BooleanWeight(float boost) {
            this.boost = boost;
        }

        @Override
        public float score(float freq, long norm) {
            return this.boost;
        }

        @Override
        public Explanation explain(Explanation freq, long norm) {
            Explanation queryBoostExpl = Explanation.match((Number)Float.valueOf(this.boost), "boost, query boost", new Explanation[0]);
            return Explanation.match(queryBoostExpl.getValue(), "score(" + this.getClass().getSimpleName() + "), computed from:", queryBoostExpl);
        }
    }
}

