/*
 * Decompiled with CFR 0.152.
 */
package com.mrh0.createaddition.recipe.liquid_burning;

import com.mojang.serialization.MapCodec;
import com.mrh0.createaddition.index.CARecipes;
import com.mrh0.createaddition.recipe.FluidRecipeWrapper;
import com.mrh0.createaddition.recipe.liquid_burning.LiquidBurningRecipeParams;
import com.simibubi.create.content.processing.recipe.ProcessingRecipe;
import com.simibubi.create.content.processing.recipe.ProcessingRecipeBuilder;
import com.simibubi.create.content.processing.recipe.ProcessingRecipeParams;
import com.simibubi.create.foundation.recipe.IRecipeTypeInfo;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeInput;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.material.Fluid;
import net.neoforged.neoforge.fluids.crafting.SizedFluidIngredient;
import org.jetbrains.annotations.NotNull;

public class LiquidBurningRecipe
extends ProcessingRecipe<FluidRecipeWrapper, LiquidBurningRecipeParams> {
    public static final IRecipeTypeInfo TYPE_INFO = new IRecipeTypeInfo(){

        public ResourceLocation getId() {
            return CARecipes.LIQUID_BURNING.getId();
        }

        public <T extends RecipeSerializer<?>> T getSerializer() {
            return (T)((RecipeSerializer)CARecipes.LIQUID_BURNING.get());
        }

        public <V extends RecipeInput, R extends Recipe<V>> RecipeType<R> getType() {
            return CARecipes.LIQUID_BURNING_TYPE.get();
        }
    };
    protected int burnTime;
    protected boolean superheated;

    public LiquidBurningRecipe(LiquidBurningRecipeParams params) {
        super(TYPE_INFO, (ProcessingRecipeParams)params);
        this.burnTime = params.getBurnTime();
        this.superheated = params.isSuperheated();
    }

    public int getBurnTime() {
        return this.burnTime;
    }

    public boolean isSuperheated() {
        return this.superheated;
    }

    public boolean matches(@NotNull FluidRecipeWrapper wrapper, @NotNull Level world) {
        if (this.fluidIngredients == null) {
            return false;
        }
        if (wrapper.fluid == null) {
            return false;
        }
        return this.getFluidInput().test(wrapper.fluid);
    }

    public SizedFluidIngredient getFluidInput() {
        if (this.fluidIngredients.isEmpty()) {
            throw new IllegalStateException("Filling Recipe has no fluid ingredient!");
        }
        return (SizedFluidIngredient)this.fluidIngredients.get(0);
    }

    protected int getMaxInputCount() {
        return 0;
    }

    protected int getMaxOutputCount() {
        return 0;
    }

    protected int getMaxFluidInputCount() {
        return 1;
    }

    public static class Serializer<R extends LiquidBurningRecipe>
    implements RecipeSerializer<R> {
        private final MapCodec<R> codec;
        private final StreamCodec<RegistryFriendlyByteBuf, R> streamCodec;

        public Serializer(ProcessingRecipe.Factory<LiquidBurningRecipeParams, R> factory) {
            this.codec = ProcessingRecipe.codec(factory, LiquidBurningRecipeParams.CODEC);
            this.streamCodec = ProcessingRecipe.streamCodec(factory, LiquidBurningRecipeParams.STREAM_CODEC);
        }

        public MapCodec<R> codec() {
            return this.codec;
        }

        public StreamCodec<RegistryFriendlyByteBuf, R> streamCodec() {
            return this.streamCodec;
        }
    }

    public static class Builder<R extends LiquidBurningRecipe>
    extends ProcessingRecipeBuilder<LiquidBurningRecipeParams, R, Builder<R>> {
        public Builder(Factory<R> factory, ResourceLocation recipeId) {
            super(factory, recipeId);
        }

        protected LiquidBurningRecipeParams createParams() {
            return new LiquidBurningRecipeParams();
        }

        public Builder<R> self() {
            return this;
        }

        public Builder<R> fluid(TagKey<Fluid> fluidTag) {
            return (Builder)this.require(SizedFluidIngredient.of(fluidTag, (int)1000));
        }

        public Builder<R> burnTime(int burnTime) {
            ((LiquidBurningRecipeParams)this.params).burnTime = burnTime;
            return this;
        }

        public Builder<R> superheated() {
            ((LiquidBurningRecipeParams)this.params).superheated = true;
            return this;
        }
    }

    @FunctionalInterface
    public static interface Factory<R extends LiquidBurningRecipe>
    extends ProcessingRecipe.Factory<LiquidBurningRecipeParams, R> {
        public R create(LiquidBurningRecipeParams var1);
    }
}

