/*
 * Decompiled with CFR 0.152.
 */
package com.razz.decocraft.common.containers;

import com.razz.decocraft.common.ModuleScreenHandlers;
import com.razz.decocraft.common.items.DecoBlockItem;
import com.razz.decocraft.common.tileentities.DecomposerTileEntity;
import com.razz.mods.Mods;
import java.util.Map;
import net.minecraft.core.NonNullList;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.Container;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ClickType;
import net.minecraft.world.inventory.ContainerLevelAccess;
import net.minecraft.world.inventory.DataSlot;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;

public class DecomposerScreenHandler
extends AbstractContainerMenu {
    private static final int SPACING = 18;
    private static final int INVENTORY_X = -26;
    private static final int INVENTORY_Y = 117;
    public final NonNullList<ItemStack> items = NonNullList.create();
    private final ContainerLevelAccess context;
    public int[] crafting = new int[2];
    public int[] fuel = new int[1];
    private DecomposerTileEntity decomposerTE;
    private Level world;

    public DecomposerScreenHandler(int syncId, Inventory inventory) {
        this(syncId, inventory, ContainerLevelAccess.NULL);
    }

    public DecomposerScreenHandler(int syncId, Inventory inventory, ContainerLevelAccess context) {
        super((MenuType)ModuleScreenHandlers.DECOMPOSER.get(), syncId);
        this.context = context;
        this.context.execute((world, pos) -> {
            BlockEntity blockEntity = world.getBlockEntity(pos);
            this.decomposerTE = blockEntity instanceof DecomposerTileEntity ? (DecomposerTileEntity)blockEntity : null;
            this.world = world;
        });
        for (int i = 0; i < 9; ++i) {
            this.addSlot(new Slot((Container)inventory, i, -26 + i * 18, 117));
        }
        this.addSlot(new Slot(this, (Container)(this.decomposerTE == null ? new SimpleContainer(1) : this.decomposerTE.getInput()), 0, 28, 38){

            public boolean mayPlace(ItemStack stack) {
                if (stack == ItemStack.EMPTY) {
                    return false;
                }
                boolean found = stack.getItem() instanceof DecoBlockItem;
                if (!found) {
                    for (Map.Entry<String, Integer> entry : Mods.DECOMPOSER_INGREDIENTS.entrySet()) {
                        if (entry.getKey().startsWith("#")) {
                            TagKey tag = TagKey.create((ResourceKey)Registries.ITEM, (ResourceLocation)ResourceLocation.parse((String)entry.getKey().substring(1)));
                            if (!stack.is(tag)) continue;
                            found = true;
                            break;
                        }
                        Item targetItem = (Item)BuiltInRegistries.ITEM.get(ResourceLocation.parse((String)entry.getKey()));
                        if (stack.getItem() != targetItem) continue;
                        found = true;
                        break;
                    }
                }
                return found;
            }
        });
        this.addSlot(new Slot((Container)(this.decomposerTE == null ? new SimpleContainer(1) : this.decomposerTE.getResult()), 0, 63, 38){

            public boolean mayPlace(ItemStack stack) {
                return false;
            }

            public void onTake(Player player, ItemStack stack) {
                super.onTake(player, stack);
                if (DecomposerScreenHandler.this.decomposerTE != null) {
                    DecomposerScreenHandler.this.decomposerTE.setChanged();
                }
            }
        });
        this.addSlot(new Slot(this, (Container)(this.decomposerTE == null ? new SimpleContainer(1) : this.decomposerTE.getFuel()), 0, 10, 84){

            public boolean mayPlace(ItemStack stack) {
                if ("".equals("")) {
                    return stack.getItem() == Items.COAL || stack.getItem() == Items.CHARCOAL || stack.getItem() == Items.BLAZE_ROD || stack.getItem() == Items.LAVA_BUCKET || stack.getItem().toString().contains("log") || stack.getItem().toString().contains("plank");
                }
                Item targetItem = (Item)BuiltInRegistries.ITEM.get(ResourceLocation.parse((String)""));
                return stack.getItem() == targetItem;
            }
        });
        this.addDataSlot(new DataSlot(){

            public int get() {
                return DecomposerScreenHandler.this.decomposerTE != null ? DecomposerScreenHandler.this.decomposerTE.getCraft() : 0;
            }

            public void set(int value) {
                DecomposerScreenHandler.this.crafting[0] = value;
            }
        });
        this.addDataSlot(new DataSlot(){

            public int get() {
                return DecomposerScreenHandler.this.decomposerTE != null ? DecomposerScreenHandler.this.decomposerTE.getCraftingTimer() : 0;
            }

            public void set(int value) {
                DecomposerScreenHandler.this.crafting[1] = value;
            }
        });
        this.addDataSlot(new DataSlot(){

            public int get() {
                return DecomposerScreenHandler.this.decomposerTE != null ? DecomposerScreenHandler.this.decomposerTE.getCurrentFuel() : 0;
            }

            public void set(int value) {
                DecomposerScreenHandler.this.fuel[0] = value;
            }
        });
        this.getTEData();
    }

    private void getTEData() {
        if (this.world != null && !this.world.isClientSide() && this.decomposerTE != null) {
            this.crafting[0] = this.decomposerTE.getCraft();
            this.crafting[1] = this.decomposerTE.getCraftingTimer();
            this.fuel[0] = this.decomposerTE.getCurrentFuel();
        }
    }

    public boolean stillValid(Player player) {
        return (Boolean)this.context.evaluate((world, pos) -> player.distanceToSqr((double)pos.getX() + 0.5, (double)pos.getY() + 0.5, (double)pos.getZ() + 0.5) <= 64.0, (Object)true);
    }

    public void removed(Player player) {
        super.removed(player);
        if (this.decomposerTE != null) {
            this.decomposerTE.setChanged();
        }
    }

    public void broadcastChanges() {
        this.getTEData();
        super.broadcastChanges();
    }

    public ItemStack quickMoveStack(Player player, int index) {
        return ItemStack.EMPTY;
    }

    public void craft(int craft) {
        if (this.decomposerTE != null) {
            this.decomposerTE.setCraft(craft);
        }
    }

    public ContainerLevelAccess getContext() {
        return this.context;
    }

    public void clicked(int slotId, int button, ClickType clickType, Player player) {
        if (clickType == ClickType.THROW) {
            return;
        }
        if (slotId == -999 && clickType == ClickType.PICKUP) {
            return;
        }
        super.clicked(slotId, button, clickType, player);
    }
}

