/*
 * Decompiled with CFR 0.152.
 */
package com.razznature.decocraft.client;

import com.razznature.decocraft.Decocraft;
import com.razznature.decocraft.client.render.AnimatedRenderer;
import com.razznature.decocraft.client.render.DecoPlacementRenderer;
import com.razznature.decocraft.client.screens.DecoStorageScreen;
import com.razznature.decocraft.client.screens.DecobenchScreen;
import com.razznature.decocraft.client.screens.DecomposerScreen;
import com.razznature.decocraft.common.JsonContainer;
import com.razznature.decocraft.common.ModuleBlocks;
import com.razznature.decocraft.common.ModuleScreenHandlers;
import com.razznature.decocraft.common.ModuleTileEntities;
import com.razznature.decocraft.common.blocks.DecoAnimatedBlock;
import com.razznature.decocraft.common.blocks.DecoBedBlock;
import com.razznature.decocraft.common.blocks.DecocraftBlock;
import com.razznature.decocraft.models.bbmodel.BBModel;
import java.util.Map;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.fml.event.lifecycle.FMLClientSetupEvent;
import net.neoforged.neoforge.client.event.EntityRenderersEvent;
import net.neoforged.neoforge.client.event.RegisterMenuScreensEvent;
import net.neoforged.neoforge.client.event.RenderLevelStageEvent;
import net.neoforged.neoforge.common.NeoForge;

@OnlyIn(value=Dist.CLIENT)
@EventBusSubscriber(modid="decocraft_nature", value={Dist.CLIENT})
public class ClientHandler {
    private static boolean initialized = false;

    public static void setup() {
        if (!initialized) {
            ClientHandler.registerScreens();
            ClientHandler.registerBBModels();
            ClientHandler.registerPlacementPreview();
            initialized = true;
        }
    }

    @SubscribeEvent
    public static void onClientSetup(FMLClientSetupEvent event) {
        if (!initialized) {
            event.enqueueWork(() -> {
                ClientHandler.registerScreens();
                ClientHandler.registerBBModels();
                ClientHandler.registerPlacementPreview();
            });
            initialized = true;
        }
    }

    @SubscribeEvent
    public static void onRegisterRenderers(EntityRenderersEvent.RegisterRenderers event) {
        ClientHandler.registerRenderers(event);
    }

    @SubscribeEvent
    public static void onRegisterMenuScreens(RegisterMenuScreensEvent event) {
        event.register((MenuType)ModuleScreenHandlers.DECO_STORAGE.get(), DecoStorageScreen::new);
        event.register((MenuType)ModuleScreenHandlers.DECOBENCH.get(), DecobenchScreen::new);
        event.register((MenuType)ModuleScreenHandlers.DECOMPOSER.get(), DecomposerScreen::new);
    }

    private static void registerPlacementPreview() {
        NeoForge.EVENT_BUS.addListener(event -> {
            if (event.getStage() == RenderLevelStageEvent.Stage.AFTER_BLOCK_ENTITIES) {
                DecoPlacementRenderer.renderPlacementPreview(event);
            }
        });
    }

    private static void registerRenderers(EntityRenderersEvent.RegisterRenderers event) {
        if (ModuleTileEntities.ANIMATED_TE != null) {
            event.registerBlockEntityRenderer((BlockEntityType)ModuleTileEntities.ANIMATED_TE.get(), AnimatedRenderer::new);
        }
    }

    private static void registerScreens() {
    }

    private static void registerBBModels() {
        for (Map.Entry<String, Block> entry : ModuleBlocks.DECOBLOCKS.entrySet()) {
            String materialName = entry.getKey();
            Block block = entry.getValue();
            if (block instanceof DecocraftBlock) {
                DecocraftBlock decoBlock = (DecocraftBlock)block;
                if (decoBlock.model == null) continue;
                ClientHandler.registerBBModelForBlock(materialName, decoBlock.model, decoBlock.meta);
                continue;
            }
            if (block instanceof DecoAnimatedBlock) {
                DecoAnimatedBlock animatedBlock = (DecoAnimatedBlock)block;
                if (animatedBlock.model == null) continue;
                ClientHandler.registerBBModelForBlock(materialName, animatedBlock.model, animatedBlock.meta);
                continue;
            }
            if (!(block instanceof DecoBedBlock)) continue;
            DecoBedBlock bedBlock = (DecoBedBlock)block;
            if (bedBlock.model == null) continue;
            ClientHandler.registerBBModelForBlock(materialName, bedBlock.model, bedBlock.meta);
        }
    }

    private static void registerBBModelForBlock(String materialName, BBModel model, JsonContainer.Entry meta) {
        try {
            float f = meta.scale != 0.0f ? meta.scale : 1.0f;
        }
        catch (Exception e) {
            Decocraft.LOGGER.error("Error registering BBModel for {}: {}", (Object)materialName, (Object)e.getMessage());
        }
    }
}

