/*
 * Decompiled with CFR 0.152.
 */
package com.razznature.decocraft.common.blocks;

import com.razznature.decocraft.common.JsonContainer;
import com.razznature.decocraft.common.blocks.DecocraftBlock;
import com.razznature.decocraft.common.entities.DecoSeatEntity;
import com.razznature.decocraft.models.bbmodel.BBModel;
import com.razznature.decocraft.models.bbmodel.BBModelParts;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.Vec3;

public class DecoSeatBlock
extends DecocraftBlock {
    private final Map<Integer, Vec3> sittingNodes = new TreeMap<Integer, Vec3>();

    public DecoSeatBlock(JsonContainer.Entry meta, BBModel model) {
        super(meta, model);
        this.loadSittingNodes(model, meta.scale);
    }

    private void loadSittingNodes(BBModel model, float scale) {
        for (BBModelParts.ElementBase element : model.outlinerFlatList) {
            if (!(element instanceof BBModelParts.OutlinerGroup)) continue;
            BBModelParts.OutlinerGroup group = (BBModelParts.OutlinerGroup)element;
            if (!"sitting_node".equals(group.name)) continue;
            for (BBModelParts.OutlinerNode child : group.children) {
                if (!(child instanceof BBModelParts.OutlinerCube)) continue;
                BBModelParts.OutlinerCube cube = (BBModelParts.OutlinerCube)child;
                BBModelParts.Element childElement = (BBModelParts.Element)model.uuidMap.get(cube.uuid);
                if (childElement == null) continue;
                Vec3 nodePos = this.getNodePosition(childElement, scale);
                try {
                    int nodeId = Integer.parseInt(childElement.name);
                    this.sittingNodes.put(nodeId, nodePos);
                }
                catch (NumberFormatException numberFormatException) {}
            }
        }
    }

    private Vec3 getNodePosition(BBModelParts.Element element, float scale) {
        if (element.position != null) {
            return new Vec3((double)(element.position.x / 16.0f * scale), (double)(element.position.y / 16.0f * scale), (double)(element.position.z / 16.0f * scale));
        }
        if (element.from != null) {
            return new Vec3((double)(element.from.x / 16.0f * scale), (double)(element.from.y / 16.0f * scale), (double)(element.from.z / 16.0f * scale));
        }
        return Vec3.ZERO;
    }

    @Override
    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        builder.add(new Property[]{BlockStateProperties.HORIZONTAL_FACING});
    }

    @Override
    protected InteractionResult useWithoutItem(BlockState blockState, Level level, BlockPos blockPos, Player player, BlockHitResult blockRayTraceResult) {
        List seats;
        if (!level.isClientSide && (seats = level.getEntitiesOfClass(DecoSeatEntity.class, new AABB((double)blockPos.getX(), (double)blockPos.getY(), (double)blockPos.getZ(), (double)blockPos.getX() + 1.0, (double)blockPos.getY() + 1.0, (double)blockPos.getZ() + 1.0), entity -> true)).isEmpty()) {
            Vec3 offset = this.sittingNodes.get(0);
            if (offset == null) {
                offset = Vec3.ZERO;
            }
            Direction direction = (Direction)blockState.getValue((Property)BlockStateProperties.HORIZONTAL_FACING);
            Vec3 rotatedOffset = DecoSeatBlock.rotatePosition(offset, direction);
            Vec3 vect = new Vec3(0.5 + rotatedOffset.x, rotatedOffset.y, 0.5 + rotatedOffset.z);
            DecoSeatEntity seat = new DecoSeatEntity(level, blockPos, vect);
            level.addFreshEntity((Entity)seat);
            player.startRiding((Entity)seat, false);
        }
        return InteractionResult.SUCCESS;
    }

    private static Vec3 rotatePosition(Vec3 pos, Direction facing) {
        switch (facing) {
            case NORTH: {
                return pos;
            }
            case SOUTH: {
                return new Vec3(-pos.x, pos.y, -pos.z);
            }
            case EAST: {
                return new Vec3(-pos.z, pos.y, pos.x);
            }
            case WEST: {
                return new Vec3(pos.z, pos.y, -pos.x);
            }
        }
        return pos;
    }
}

