/*
 * Decompiled with CFR 0.152.
 */
package com.razznature.decocraft.common.entities;

import com.razznature.decocraft.common.ModuleEntities;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Position;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;

public class DecoSeatEntity
extends Entity {
    private BlockPos source;
    private Vec3 originalPlayerPosition;

    public DecoSeatEntity(EntityType<DecoSeatEntity> type, Level world) {
        super(type, world);
        this.noPhysics = true;
    }

    public DecoSeatEntity(Level world) {
        super((EntityType)ModuleEntities.SEAT.get(), world);
        this.noPhysics = true;
    }

    public DecoSeatEntity(Level world, BlockPos source, Vec3 offset) {
        this(world);
        this.source = source;
        this.setPos((double)source.getX() + offset.x, (double)source.getY() + offset.y, (double)source.getZ() + offset.z);
    }

    public void tick() {
        super.tick();
        if (this.source == null) {
            this.source = this.blockPosition();
        }
        if (!this.level().isClientSide) {
            for (Entity passenger : this.getPassengers()) {
                if (!(passenger instanceof Player)) continue;
                Player player = (Player)passenger;
                player.fallDistance = 0.0f;
            }
            if (this.getPassengers().isEmpty() || this.level().getBlockState(this.source).isAir()) {
                this.discard();
                this.level().updateNeighborsAt(this.blockPosition(), this.level().getBlockState(this.blockPosition()).getBlock());
            }
        }
    }

    public boolean canRide(Entity entity) {
        return true;
    }

    protected void defineSynchedData(SynchedEntityData.Builder builder) {
    }

    protected void readAdditionalSaveData(CompoundTag nbt) {
    }

    protected void addAdditionalSaveData(CompoundTag nbt) {
    }

    protected void addPassenger(Entity passenger) {
        if (passenger instanceof Player) {
            Player player = (Player)passenger;
            this.originalPlayerPosition = player.position();
            player.fallDistance = 0.0f;
            player.setDeltaMovement(Vec3.ZERO);
        }
        super.addPassenger(passenger);
    }

    public Vec3 getDismountPosition(Entity passenger) {
        if (this.source != null) {
            Vec3[] safePositions;
            for (Vec3 pos : safePositions = new Vec3[]{new Vec3((double)this.source.getX() + 1.5, (double)this.source.getY() + 1.0, (double)this.source.getZ() + 0.5), new Vec3((double)this.source.getX() - 0.5, (double)this.source.getY() + 1.0, (double)this.source.getZ() + 0.5), new Vec3((double)this.source.getX() + 0.5, (double)this.source.getY() + 1.0, (double)this.source.getZ() + 1.5), new Vec3((double)this.source.getX() + 0.5, (double)this.source.getY() + 1.0, (double)this.source.getZ() - 0.5), new Vec3((double)this.source.getX() + 1.5, (double)this.source.getY() + 1.0, (double)this.source.getZ() + 1.5), new Vec3((double)this.source.getX() + 1.5, (double)this.source.getY() + 1.0, (double)this.source.getZ() - 0.5), new Vec3((double)this.source.getX() - 0.5, (double)this.source.getY() + 1.0, (double)this.source.getZ() + 1.5), new Vec3((double)this.source.getX() - 0.5, (double)this.source.getY() + 1.0, (double)this.source.getZ() - 0.5), new Vec3((double)this.source.getX() + 2.5, (double)this.source.getY() + 1.0, (double)this.source.getZ() + 0.5), new Vec3((double)this.source.getX() - 1.5, (double)this.source.getY() + 1.0, (double)this.source.getZ() + 0.5), new Vec3((double)this.source.getX() + 0.5, (double)this.source.getY() + 1.0, (double)this.source.getZ() + 2.5), new Vec3((double)this.source.getX() + 0.5, (double)this.source.getY() + 1.0, (double)this.source.getZ() - 1.5), new Vec3((double)this.source.getX() + 0.5, (double)this.source.getY() + 2.0, (double)this.source.getZ() + 0.5), new Vec3((double)this.source.getX() + 0.5, (double)this.source.getY() + 3.0, (double)this.source.getZ() + 0.5)}) {
                BlockPos blockPos = BlockPos.containing((Position)pos);
                BlockPos blockPosAbove = blockPos.above();
                if (!this.level().getBlockState(blockPos).isAir() || !this.level().getBlockState(blockPosAbove).isAir()) continue;
                BlockPos blockPosBelow = blockPos.below();
                if (this.level().getBlockState(blockPosBelow).isAir() && blockPos.getY() <= this.source.getY()) continue;
                return pos;
            }
        }
        return new Vec3((double)this.source.getX() + 0.5, (double)this.source.getY() + 2.0, (double)this.source.getZ() + 0.5);
    }

    protected void removePassenger(Entity passenger) {
        if (passenger instanceof Player) {
            Player player = (Player)passenger;
            Vec3 dismountPos = this.getDismountPosition(passenger);
            player.teleportTo(dismountPos.x, dismountPos.y, dismountPos.z);
            player.fallDistance = 0.0f;
            player.setDeltaMovement(Vec3.ZERO);
        }
        super.removePassenger(passenger);
    }
}

