/*
 * Decompiled with CFR 0.152.
 */
package com.razznature.decocraft.common.storage;

import java.util.HashMap;
import java.util.Map;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.saveddata.SavedData;

public class SharedStorageManager
extends SavedData {
    private final Map<String, StorageData> storageMap = new HashMap<String, StorageData>();
    public static final SavedData.Factory<SharedStorageManager> TYPE = new SavedData.Factory(SharedStorageManager::new, (nbt, registryLookup) -> {
        if (nbt.contains("storages")) {
            CompoundTag storagesTag = nbt.getCompound("storages");
            HashMap<String, StorageData> loadedMap = new HashMap<String, StorageData>();
            for (String key : storagesTag.getAllKeys()) {
                CompoundTag storageTag = storagesTag.getCompound(key);
                int width = storageTag.getInt("width");
                int height = storageTag.getInt("height");
                ListTag itemsList = storageTag.getList("items", 10);
                StorageData data = new StorageData(width, height);
                for (int i = 0; i < itemsList.size() && i < data.inventory.length; ++i) {
                    CompoundTag itemTag = itemsList.getCompound(i);
                    if (itemTag.isEmpty()) continue;
                    data.inventory[i] = ItemStack.parseOptional((HolderLookup.Provider)registryLookup, (CompoundTag)itemTag);
                }
                loadedMap.put(key, data);
            }
            return new SharedStorageManager(loadedMap);
        }
        return new SharedStorageManager();
    }, null);

    public SharedStorageManager() {
    }

    public SharedStorageManager(Map<String, StorageData> storageMap) {
        this.storageMap.putAll(storageMap);
    }

    public static SharedStorageManager getInstance(Level level) {
        if (level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            ServerLevel overworld = serverLevel.getServer().overworld();
            return (SharedStorageManager)overworld.getDataStorage().computeIfAbsent(TYPE, "decocraft_shared_storage");
        }
        return null;
    }

    public CompoundTag save(CompoundTag nbt, HolderLookup.Provider registryLookup) {
        CompoundTag storagesTag = new CompoundTag();
        for (Map.Entry<String, StorageData> entry : this.storageMap.entrySet()) {
            String storageId = entry.getKey();
            StorageData data = entry.getValue();
            CompoundTag storageTag = new CompoundTag();
            storageTag.putInt("width", data.width);
            storageTag.putInt("height", data.height);
            ListTag itemsList = new ListTag();
            for (int i = 0; i < data.inventory.length; ++i) {
                ItemStack stack = data.inventory[i];
                CompoundTag itemTag = new CompoundTag();
                if (!stack.isEmpty()) {
                    stack.save(registryLookup, (Tag)itemTag);
                }
                itemsList.add((Object)itemTag);
            }
            storageTag.put("items", (Tag)itemsList);
            storagesTag.put(storageId, (Tag)storageTag);
        }
        nbt.put("storages", (Tag)storagesTag);
        return nbt;
    }

    public StorageData getOrCreateStorage(String storageId, int width, int height) {
        StorageData existing = this.storageMap.get(storageId);
        if (existing != null) {
            return existing;
        }
        StorageData newData = new StorageData(width, height);
        this.storageMap.put(storageId, newData);
        this.setDirty();
        return newData;
    }

    public StorageData getStorage(String storageId) {
        return this.storageMap.get(storageId);
    }

    public void updateStorage(String storageId, StorageData data) {
        this.storageMap.put(storageId, data);
        this.setDirty();
    }

    public void removeStorage(String storageId) {
        if (this.storageMap.remove(storageId) != null) {
            this.setDirty();
        }
    }

    public int getStorageCount() {
        return this.storageMap.size();
    }

    public static class StorageData {
        public ItemStack[] inventory;
        public int width;
        public int height;

        public StorageData(int width, int height) {
            this.width = width;
            this.height = height;
            this.inventory = new ItemStack[width * height];
            for (int i = 0; i < this.inventory.length; ++i) {
                this.inventory[i] = ItemStack.EMPTY;
            }
        }

        public StorageData(ItemStack[] inventory, int width, int height) {
            this.inventory = inventory;
            this.width = width;
            this.height = height;
        }
    }
}

