/*
 * Decompiled with CFR 0.152.
 */
package com.razznature.decocraft.models.bbmodel;

import com.mojang.math.Transformation;
import com.razznature.decocraft.Decocraft;
import com.razznature.decocraft.common.ModuleBlocks;
import com.razznature.decocraft.models.bbmodel.BBModel;
import com.razznature.decocraft.models.bbmodel.BBUnbakedModel;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.client.resources.model.Material;
import net.minecraft.client.resources.model.ModelBaker;
import net.minecraft.client.resources.model.ModelResourceLocation;
import net.minecraft.client.resources.model.ModelState;
import net.minecraft.resources.ResourceLocation;
import net.neoforged.neoforge.client.event.ModelEvent;

public class BBModelLoadingPlugin {
    public static void registerModels(ModelEvent.RegisterAdditional event) {
        for (String materialName : ModuleBlocks.MAT_TO_BB_MODEL.keySet()) {
            ModelResourceLocation modelId = ModelResourceLocation.standalone((ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"decocraft_nature", (String)("block/" + materialName)));
            event.register(modelId);
        }
    }

    public static void onModelBake(ModelEvent.ModifyBakingResult event) {
        int successCount = 0;
        int failCount = 0;
        int nullCount = 0;
        for (String materialName : ModuleBlocks.MAT_TO_BB_MODEL.keySet()) {
            BBModel bbModel = ModuleBlocks.MAT_TO_BB_MODEL.get(materialName);
            if (bbModel == null) {
                ++nullCount;
                continue;
            }
            ModelResourceLocation modelId = ModelResourceLocation.standalone((ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"decocraft_nature", (String)("block/" + materialName)));
            BBUnbakedModel unbakedModel = new BBUnbakedModel(materialName, bbModel);
            ModelState modelState = new ModelState(){

                public Transformation getRotation() {
                    return Transformation.identity();
                }
            };
            try {
                BakedModel bakedModel = unbakedModel.bake((ModelBaker)event.getModelBakery(), Material::sprite, modelState);
                if (bakedModel != null) {
                    event.getModels().put(modelId, bakedModel);
                    ++successCount;
                    continue;
                }
                ++failCount;
            }
            catch (Exception e) {
                System.err.println("Failed to bake BBModel for " + materialName + ": " + e.getMessage());
                e.printStackTrace();
                ++failCount;
            }
        }
        Decocraft.LOGGER.info("BBModel baking stats: {} succeeded, {} failed, {} null models", new Object[]{successCount, failCount, nullCount});
    }
}

