/*
 * Decompiled with CFR 0.152.
 */
package com.reazip.economycraft;

import com.mojang.authlib.GameProfile;
import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.LongArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.suggestion.Suggestions;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import com.reazip.economycraft.EconomyConfig;
import com.reazip.economycraft.EconomyCraft;
import com.reazip.economycraft.EconomyManager;
import com.reazip.economycraft.orders.OrderManager;
import com.reazip.economycraft.orders.OrderRequest;
import com.reazip.economycraft.orders.OrdersUi;
import com.reazip.economycraft.shop.ShopListing;
import com.reazip.economycraft.shop.ShopManager;
import com.reazip.economycraft.shop.ShopUi;
import java.util.Collection;
import java.util.Optional;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import net.minecraft.ChatFormatting;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.commands.arguments.GameProfileArgument;
import net.minecraft.commands.arguments.ResourceLocationArgument;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;

public final class EconomyCommands {
    public static void register(CommandDispatcher<CommandSourceStack> dispatcher) {
        dispatcher.register(EconomyCommands.buildRoot());
        if (EconomyConfig.get().standaloneCommands) {
            dispatcher.register(EconomyCommands.buildBalance());
            dispatcher.register(EconomyCommands.buildPay());
            dispatcher.register(EconomyCommands.buildShop());
            dispatcher.register(EconomyCommands.buildOrders());
            dispatcher.register(EconomyCommands.buildDaily());
        }
        if (EconomyConfig.get().standaloneAdminCommands) {
            dispatcher.register(EconomyCommands.buildAddMoney());
            dispatcher.register(EconomyCommands.buildSetMoney());
            dispatcher.register(EconomyCommands.buildRemoveMoney());
            dispatcher.register(EconomyCommands.buildRemovePlayer());
            dispatcher.register(EconomyCommands.buildToggleScoreboard());
        }
    }

    private static LiteralArgumentBuilder<CommandSourceStack> buildRoot() {
        LiteralArgumentBuilder root = Commands.literal((String)"eco");
        root.then(EconomyCommands.buildBalance());
        root.then(EconomyCommands.buildPay());
        root.then(EconomyCommands.buildAddMoney());
        root.then(EconomyCommands.buildSetMoney());
        root.then(EconomyCommands.buildRemoveMoney());
        root.then(EconomyCommands.buildRemovePlayer());
        root.then(EconomyCommands.buildShop());
        root.then(EconomyCommands.buildOrders());
        root.then(EconomyCommands.buildDaily());
        root.then(EconomyCommands.buildToggleScoreboard());
        return root;
    }

    private static LiteralArgumentBuilder<CommandSourceStack> buildBalance() {
        return (LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.literal((String)"balance").executes(ctx -> EconomyCommands.showBalance(((CommandSourceStack)ctx.getSource()).getPlayerOrException().getGameProfile(), (CommandSourceStack)ctx.getSource()))).then(Commands.argument((String)"target", (ArgumentType)GameProfileArgument.gameProfile()).executes(ctx -> {
            Collection profiles = GameProfileArgument.getGameProfiles((CommandContext)ctx, (String)"target");
            if (profiles.size() != 1) {
                ((CommandSourceStack)ctx.getSource()).sendFailure((Component)Component.literal((String)"Please specify exactly one player").withStyle(ChatFormatting.RED));
                return 0;
            }
            return EconomyCommands.showBalance((GameProfile)profiles.iterator().next(), (CommandSourceStack)ctx.getSource());
        }));
    }

    private static LiteralArgumentBuilder<CommandSourceStack> buildPay() {
        return (LiteralArgumentBuilder)Commands.literal((String)"pay").then(Commands.argument((String)"player", (ArgumentType)StringArgumentType.word()).suggests((ctx, builder) -> EconomyCommands.suggestPlayers((CommandSourceStack)ctx.getSource(), builder)).then(Commands.argument((String)"amount", (ArgumentType)LongArgumentType.longArg((long)1L, (long)999999999L)).executes(ctx -> EconomyCommands.pay(((CommandSourceStack)ctx.getSource()).getPlayerOrException(), StringArgumentType.getString((CommandContext)ctx, (String)"player"), LongArgumentType.getLong((CommandContext)ctx, (String)"amount"), (CommandSourceStack)ctx.getSource()))));
    }

    private static int showBalance(GameProfile profile, CommandSourceStack source) {
        ServerPlayer executor;
        EconomyManager manager = EconomyCraft.getManager(source.getServer());
        Long bal = manager.getBalance(profile.getId(), false);
        if (bal == null) {
            source.sendFailure((Component)Component.literal((String)"Unknown player").withStyle(ChatFormatting.RED));
            return 0;
        }
        try {
            executor = source.getPlayerOrException();
        }
        catch (Exception e) {
            executor = null;
        }
        if (executor != null && executor.getUUID().equals(profile.getId())) {
            source.sendSuccess(() -> Component.literal((String)("Balance: " + EconomyCraft.formatMoney(bal))).withStyle(ChatFormatting.YELLOW), false);
        } else {
            source.sendSuccess(() -> Component.literal((String)(profile.getName() + "'s balance: " + EconomyCraft.formatMoney(bal))).withStyle(ChatFormatting.YELLOW), false);
        }
        return 1;
    }

    private static int pay(ServerPlayer from, String target, long amount, CommandSourceStack source) {
        Optional profile = source.getServer().getProfileCache().get(target);
        if (profile.isEmpty()) {
            source.sendFailure((Component)Component.literal((String)"Unknown player").withStyle(ChatFormatting.RED));
            return 0;
        }
        EconomyManager manager = EconomyCraft.getManager(source.getServer());
        UUID toId = ((GameProfile)profile.get()).getId();
        if (from.getUUID().equals(toId)) {
            source.sendFailure((Component)Component.literal((String)"You cannot pay yourself").withStyle(ChatFormatting.RED));
            return 0;
        }
        if (!manager.getBalances().containsKey(toId)) {
            source.sendFailure((Component)Component.literal((String)"Unknown player").withStyle(ChatFormatting.RED));
            return 0;
        }
        if (manager.pay(from.getUUID(), toId, amount)) {
            source.sendSuccess(() -> Component.literal((String)("Paid " + EconomyCraft.formatMoney(amount) + " to " + ((GameProfile)profile.get()).getName())).withStyle(ChatFormatting.GREEN), false);
            ServerPlayer to = source.getServer().getPlayerList().getPlayer(toId);
            if (to != null) {
                to.sendSystemMessage((Component)Component.literal((String)(from.getName().getString() + " sent you " + EconomyCraft.formatMoney(amount))).withStyle(ChatFormatting.GREEN));
            }
        } else {
            source.sendFailure((Component)Component.literal((String)"Not enough balance").withStyle(ChatFormatting.RED));
        }
        return 1;
    }

    private static LiteralArgumentBuilder<CommandSourceStack> buildAddMoney() {
        return (LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.literal((String)"addmoney").requires(s -> s.hasPermission(2))).then(Commands.argument((String)"targets", (ArgumentType)GameProfileArgument.gameProfile()).then(Commands.argument((String)"amount", (ArgumentType)LongArgumentType.longArg((long)1L, (long)999999999L)).executes(ctx -> EconomyCommands.addMoney(GameProfileArgument.getGameProfiles((CommandContext)ctx, (String)"targets"), LongArgumentType.getLong((CommandContext)ctx, (String)"amount"), (CommandSourceStack)ctx.getSource()))));
    }

    private static LiteralArgumentBuilder<CommandSourceStack> buildSetMoney() {
        return (LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.literal((String)"setmoney").requires(s -> s.hasPermission(2))).then(Commands.argument((String)"targets", (ArgumentType)GameProfileArgument.gameProfile()).then(Commands.argument((String)"amount", (ArgumentType)LongArgumentType.longArg((long)0L, (long)999999999L)).executes(ctx -> EconomyCommands.setMoney(GameProfileArgument.getGameProfiles((CommandContext)ctx, (String)"targets"), LongArgumentType.getLong((CommandContext)ctx, (String)"amount"), (CommandSourceStack)ctx.getSource()))));
    }

    private static LiteralArgumentBuilder<CommandSourceStack> buildRemoveMoney() {
        return (LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.literal((String)"removemoney").requires(s -> s.hasPermission(2))).then(((RequiredArgumentBuilder)Commands.argument((String)"targets", (ArgumentType)GameProfileArgument.gameProfile()).executes(ctx -> EconomyCommands.removeMoney(GameProfileArgument.getGameProfiles((CommandContext)ctx, (String)"targets"), null, (CommandSourceStack)ctx.getSource()))).then(Commands.argument((String)"amount", (ArgumentType)LongArgumentType.longArg((long)1L, (long)999999999L)).executes(ctx -> EconomyCommands.removeMoney(GameProfileArgument.getGameProfiles((CommandContext)ctx, (String)"targets"), LongArgumentType.getLong((CommandContext)ctx, (String)"amount"), (CommandSourceStack)ctx.getSource()))));
    }

    private static LiteralArgumentBuilder<CommandSourceStack> buildRemovePlayer() {
        return (LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.literal((String)"removeplayer").requires(s -> s.hasPermission(2))).then(Commands.argument((String)"targets", (ArgumentType)GameProfileArgument.gameProfile()).executes(ctx -> EconomyCommands.removePlayers(GameProfileArgument.getGameProfiles((CommandContext)ctx, (String)"targets"), (CommandSourceStack)ctx.getSource())));
    }

    private static int addMoney(Collection<GameProfile> profiles, long amount, CommandSourceStack source) {
        if (profiles.isEmpty()) {
            source.sendFailure((Component)Component.literal((String)"No targets matched").withStyle(ChatFormatting.RED));
            return 0;
        }
        EconomyManager manager = EconomyCraft.getManager(source.getServer());
        if (profiles.size() == 1) {
            GameProfile p = profiles.iterator().next();
            manager.addMoney(p.getId(), amount);
            source.sendSuccess(() -> Component.literal((String)("Added " + EconomyCraft.formatMoney(amount) + " to " + p.getName() + "'s balance.")).withStyle(ChatFormatting.GREEN), true);
            return 1;
        }
        for (GameProfile p : profiles) {
            manager.addMoney(p.getId(), amount);
        }
        int count = profiles.size();
        source.sendSuccess(() -> Component.literal((String)("Added " + EconomyCraft.formatMoney(amount) + " to " + count + " player" + (count > 1 ? "s" : ""))).withStyle(ChatFormatting.GREEN), true);
        return count;
    }

    private static int setMoney(Collection<GameProfile> profiles, long amount, CommandSourceStack source) {
        if (profiles.isEmpty()) {
            source.sendFailure((Component)Component.literal((String)"No targets matched").withStyle(ChatFormatting.RED));
            return 0;
        }
        EconomyManager manager = EconomyCraft.getManager(source.getServer());
        if (profiles.size() == 1) {
            GameProfile p = profiles.iterator().next();
            manager.setMoney(p.getId(), amount);
            source.sendSuccess(() -> Component.literal((String)("Set balance of " + p.getName() + " to " + EconomyCraft.formatMoney(amount))).withStyle(ChatFormatting.GREEN), true);
            return 1;
        }
        for (GameProfile p : profiles) {
            manager.setMoney(p.getId(), amount);
        }
        int count = profiles.size();
        source.sendSuccess(() -> Component.literal((String)("Set balance to " + EconomyCraft.formatMoney(amount) + " for " + count + " player" + (count > 1 ? "s" : ""))).withStyle(ChatFormatting.GREEN), true);
        return count;
    }

    private static int removeMoney(Collection<GameProfile> profiles, Long amount, CommandSourceStack source) {
        if (profiles.isEmpty()) {
            source.sendFailure((Component)Component.literal((String)"No targets matched").withStyle(ChatFormatting.RED));
            return 0;
        }
        EconomyManager manager = EconomyCraft.getManager(source.getServer());
        int success = 0;
        if (profiles.size() == 1) {
            GameProfile p = profiles.iterator().next();
            UUID id = p.getId();
            if (amount == null) {
                if (!manager.getBalances().containsKey(id)) {
                    source.sendFailure((Component)Component.literal((String)("Failed to remove all money from " + p.getName() + "'s balance. Unknown player.")).withStyle(ChatFormatting.RED));
                    return 1;
                }
                manager.setMoney(id, 0L);
                source.sendSuccess(() -> Component.literal((String)("Removed all money from " + p.getName() + "'s balance.")).withStyle(ChatFormatting.GREEN), true);
                return 1;
            }
            if (!manager.removeMoney(id, amount)) {
                source.sendFailure((Component)Component.literal((String)("Failed to remove " + EconomyCraft.formatMoney(amount) + " from " + p.getName() + "'s balance due to insufficient funds.")).withStyle(ChatFormatting.RED));
                return 1;
            }
            source.sendSuccess(() -> Component.literal((String)("Successfully removed " + EconomyCraft.formatMoney(amount) + " from " + p.getName() + "'s balance.")).withStyle(ChatFormatting.GREEN), true);
            return 1;
        }
        for (GameProfile p : profiles) {
            UUID id = p.getId();
            if (amount == null) {
                if (!manager.getBalances().containsKey(id)) {
                    source.sendFailure((Component)Component.literal((String)("Failed to remove all money from " + p.getName() + "'s balance. Unknown player.")).withStyle(ChatFormatting.RED));
                    continue;
                }
                manager.setMoney(id, 0L);
                ++success;
                continue;
            }
            if (manager.removeMoney(id, amount)) {
                ++success;
                continue;
            }
            source.sendFailure((Component)Component.literal((String)("Failed to remove " + EconomyCraft.formatMoney(amount) + " from " + p.getName() + "'s balance due to insufficient funds.")).withStyle(ChatFormatting.RED));
        }
        if (success > 0) {
            int finalSuccess = success;
            if (amount == null) {
                source.sendSuccess(() -> Component.literal((String)("Removed all money from " + finalSuccess + " player" + (finalSuccess > 1 ? "s" : "") + ".")).withStyle(ChatFormatting.GREEN), true);
            } else {
                source.sendSuccess(() -> Component.literal((String)("Successfully removed " + EconomyCraft.formatMoney(amount) + " from " + finalSuccess + " player" + (finalSuccess > 1 ? "s" : "") + ".")).withStyle(ChatFormatting.GREEN), true);
            }
        }
        return profiles.size();
    }

    private static int removePlayers(Collection<GameProfile> profiles, CommandSourceStack source) {
        if (profiles.isEmpty()) {
            source.sendFailure((Component)Component.literal((String)"No targets matched").withStyle(ChatFormatting.RED));
            return 0;
        }
        EconomyManager manager = EconomyCraft.getManager(source.getServer());
        if (profiles.size() == 1) {
            GameProfile p = profiles.iterator().next();
            manager.removePlayer(p.getId());
            source.sendSuccess(() -> Component.literal((String)("Removed " + p.getName() + " from economy")).withStyle(ChatFormatting.GREEN), true);
            return 1;
        }
        for (GameProfile p : profiles) {
            manager.removePlayer(p.getId());
        }
        int count = profiles.size();
        source.sendSuccess(() -> Component.literal((String)("Removed " + count + " player" + (count > 1 ? "s" : "") + " from economy")).withStyle(ChatFormatting.GREEN), true);
        return count;
    }

    private static LiteralArgumentBuilder<CommandSourceStack> buildToggleScoreboard() {
        return (LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.literal((String)"toggleScoreboard").requires(s -> s.hasPermission(2))).executes(ctx -> EconomyCommands.toggleScoreboard((CommandSourceStack)ctx.getSource()));
    }

    private static int toggleScoreboard(CommandSourceStack source) {
        boolean enabled = EconomyCraft.getManager(source.getServer()).toggleScoreboard();
        source.sendSuccess(() -> Component.literal((String)("Scoreboard " + (enabled ? "enabled" : "disabled"))).withStyle(enabled ? ChatFormatting.GREEN : ChatFormatting.RED), false);
        return 1;
    }

    private static LiteralArgumentBuilder<CommandSourceStack> buildShop() {
        return (LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.literal((String)"shop").executes(ctx -> EconomyCommands.openShop(((CommandSourceStack)ctx.getSource()).getPlayerOrException(), (CommandSourceStack)ctx.getSource()))).then(Commands.literal((String)"sell").then(Commands.argument((String)"price", (ArgumentType)LongArgumentType.longArg((long)1L, (long)999999999L)).executes(ctx -> EconomyCommands.sellItem(((CommandSourceStack)ctx.getSource()).getPlayerOrException(), LongArgumentType.getLong((CommandContext)ctx, (String)"price"), (CommandSourceStack)ctx.getSource()))));
    }

    private static int openShop(ServerPlayer player, CommandSourceStack source) {
        ShopUi.open(player, EconomyCraft.getManager(source.getServer()).getShop());
        return 1;
    }

    private static int sellItem(ServerPlayer player, long price, CommandSourceStack source) {
        if (player.getMainHandItem().isEmpty()) {
            source.sendFailure((Component)Component.literal((String)"Hold the item to sell in your hand").withStyle(ChatFormatting.RED));
            return 0;
        }
        ShopManager shop = EconomyCraft.getManager(source.getServer()).getShop();
        ShopListing listing = new ShopListing();
        listing.seller = player.getUUID();
        listing.price = price;
        ItemStack hand = player.getMainHandItem();
        int count = Math.min(hand.getCount(), hand.getMaxStackSize());
        listing.item = hand.copyWithCount(count);
        hand.shrink(count);
        shop.addListing(listing);
        long tax = Math.round((double)price * EconomyConfig.get().taxRate);
        source.sendSuccess(() -> Component.literal((String)("Listed item for " + EconomyCraft.formatMoney(price) + " (buyers pay " + EconomyCraft.formatMoney(price + tax) + ")")).withStyle(ChatFormatting.GREEN), false);
        return 1;
    }

    private static LiteralArgumentBuilder<CommandSourceStack> buildOrders() {
        return (LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.literal((String)"orders").executes(ctx -> EconomyCommands.openOrders(((CommandSourceStack)ctx.getSource()).getPlayerOrException(), (CommandSourceStack)ctx.getSource()))).then(Commands.literal((String)"request").then(Commands.argument((String)"item", (ArgumentType)ResourceLocationArgument.id()).then(Commands.argument((String)"amount", (ArgumentType)LongArgumentType.longArg((long)1L, (long)999999999L)).then(Commands.argument((String)"price", (ArgumentType)LongArgumentType.longArg((long)1L, (long)999999999L)).executes(ctx -> EconomyCommands.requestItem(((CommandSourceStack)ctx.getSource()).getPlayerOrException(), ResourceLocationArgument.getId((CommandContext)ctx, (String)"item"), (int)Math.min(LongArgumentType.getLong((CommandContext)ctx, (String)"amount"), 999999999L), LongArgumentType.getLong((CommandContext)ctx, (String)"price"), (CommandSourceStack)ctx.getSource()))))))).then(Commands.literal((String)"claim").executes(ctx -> EconomyCommands.claimOrders(((CommandSourceStack)ctx.getSource()).getPlayerOrException(), (CommandSourceStack)ctx.getSource())));
    }

    private static int openOrders(ServerPlayer player, CommandSourceStack source) {
        OrdersUi.open(player, EconomyCraft.getManager(source.getServer()));
        return 1;
    }

    private static int requestItem(ServerPlayer player, ResourceLocation item, int amount, long price, CommandSourceStack source) {
        Optional holder = BuiltInRegistries.ITEM.getOptional(item);
        if (holder.isEmpty()) {
            source.sendFailure((Component)Component.literal((String)"Invalid item").withStyle(ChatFormatting.RED));
            return 0;
        }
        OrderManager orders = EconomyCraft.getManager(source.getServer()).getOrders();
        OrderRequest r = new OrderRequest();
        r.requester = player.getUUID();
        r.price = price;
        r.item = new ItemStack((ItemLike)holder.get());
        int maxAmount = 36 * r.item.getMaxStackSize();
        if (amount > maxAmount) {
            source.sendFailure((Component)Component.literal((String)("Amount exceeds 36 stacks (max " + maxAmount + ")")).withStyle(ChatFormatting.RED));
            return 0;
        }
        r.amount = amount;
        orders.addRequest(r);
        long tax = Math.round((double)price * EconomyConfig.get().taxRate);
        source.sendSuccess(() -> Component.literal((String)("Created request (fulfiller receives " + EconomyCraft.formatMoney(price - tax) + ")")).withStyle(ChatFormatting.GREEN), false);
        return 1;
    }

    private static int claimOrders(ServerPlayer player, CommandSourceStack source) {
        OrdersUi.openClaims(player, EconomyCraft.getManager(source.getServer()));
        return 1;
    }

    private static LiteralArgumentBuilder<CommandSourceStack> buildDaily() {
        return (LiteralArgumentBuilder)Commands.literal((String)"daily").executes(ctx -> EconomyCommands.daily(((CommandSourceStack)ctx.getSource()).getPlayerOrException(), (CommandSourceStack)ctx.getSource()));
    }

    private static int daily(ServerPlayer player, CommandSourceStack source) {
        EconomyManager manager = EconomyCraft.getManager(source.getServer());
        if (manager.claimDaily(player.getUUID())) {
            source.sendSuccess(() -> Component.literal((String)("Claimed " + EconomyCraft.formatMoney(EconomyConfig.get().dailyAmount))).withStyle(ChatFormatting.GREEN), false);
        } else {
            source.sendFailure((Component)Component.literal((String)"Already claimed today").withStyle(ChatFormatting.RED));
        }
        return 1;
    }

    private static CompletableFuture<Suggestions> suggestPlayers(CommandSourceStack source, SuggestionsBuilder builder) {
        MinecraftServer server = source.getServer();
        for (ServerPlayer p : server.getPlayerList().getPlayers()) {
            builder.suggest(p.getGameProfile().getName());
        }
        for (UUID id : EconomyCraft.getManager(server).getBalances().keySet()) {
            Optional prof = server.getProfileCache().get(id);
            prof.ifPresent(gameProfile -> builder.suggest(gameProfile.getName()));
        }
        return builder.buildFuture();
    }
}

