/*
 * Decompiled with CFR 0.152.
 */
package com.reazip.economycraft;

import com.google.gson.Gson;
import com.google.gson.annotations.SerializedName;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import net.minecraft.server.MinecraftServer;

public class EconomyConfig {
    private static final Gson GSON = new Gson();
    public long startingBalance = 1000L;
    public long dailyAmount = 100L;
    public double taxRate = 0.1;
    @SerializedName(value="pvp_balance_loss_percentage")
    public double pvpBalanceLossPercentage = 0.0;
    @SerializedName(value="standalone_commands")
    public boolean standaloneCommands = true;
    @SerializedName(value="standalone_admin_commands")
    public boolean standaloneAdminCommands = false;
    @SerializedName(value="scoreboard_enabled")
    public boolean scoreboardEnabled = true;
    private static EconomyConfig INSTANCE = new EconomyConfig();
    private static Path file;

    public static EconomyConfig get() {
        return INSTANCE;
    }

    public static void load(MinecraftServer server) {
        Path dir = server != null ? server.getFile("config/economycraft") : Path.of("config/economycraft", new String[0]);
        try {
            Files.createDirectories(dir, new FileAttribute[0]);
        }
        catch (IOException iOException) {
            // empty catch block
        }
        file = dir.resolve("config.json");
        if (Files.exists(file, new LinkOption[0])) {
            try {
                INSTANCE = (EconomyConfig)GSON.fromJson(Files.readString(file), EconomyConfig.class);
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        EconomyConfig.save();
    }

    public static void save() {
        if (file == null) {
            return;
        }
        try {
            Files.writeString(file, (CharSequence)GSON.toJson((Object)INSTANCE), new OpenOption[0]);
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }
}

