/*
 * Decompiled with CFR 0.152.
 */
package com.reazip.economycraft;

import com.google.gson.Gson;
import com.google.gson.reflect.TypeToken;
import com.reazip.economycraft.EconomyConfig;
import com.reazip.economycraft.EconomyCraft;
import com.reazip.economycraft.orders.OrderManager;
import com.reazip.economycraft.shop.ShopManager;
import java.io.IOException;
import java.lang.reflect.Type;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.time.LocalDate;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.ServerScoreboard;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.scores.DisplaySlot;
import net.minecraft.world.scores.Objective;
import net.minecraft.world.scores.ScoreHolder;
import net.minecraft.world.scores.criteria.ObjectiveCriteria;

public class EconomyManager {
    private static final Gson GSON = new Gson();
    private static final Type TYPE = new TypeToken<Map<UUID, Long>>(){}.getType();
    private final MinecraftServer server;
    private final Path file;
    private final Path dailyFile;
    private final Map<UUID, Long> balances = new HashMap<UUID, Long>();
    private final Map<UUID, Long> lastDaily = new HashMap<UUID, Long>();
    private Objective objective;
    private final ShopManager shop;
    private final OrderManager orders;
    private final Set<UUID> displayed = new HashSet<UUID>();
    public static final long MAX = 999999999L;

    public EconomyManager(MinecraftServer server) {
        this.server = server;
        Path dir = server.getFile("config/economycraft");
        Path dataDir = dir.resolve("data");
        try {
            Files.createDirectories(dataDir, new FileAttribute[0]);
        }
        catch (IOException iOException) {
            // empty catch block
        }
        this.file = dataDir.resolve("balances.json");
        this.dailyFile = dataDir.resolve("daily.json");
        EconomyConfig.load(server);
        this.load();
        this.loadDaily();
        this.shop = new ShopManager(server);
        this.orders = new OrderManager(server);
        if (EconomyConfig.get().scoreboardEnabled) {
            this.setupObjective();
        }
    }

    public MinecraftServer getServer() {
        return this.server;
    }

    public Long getBalance(UUID player, boolean newBalanceIfNonExistent) {
        if (!this.balances.containsKey(player)) {
            if (newBalanceIfNonExistent) {
                long balance = this.clamp(EconomyConfig.get().startingBalance);
                this.balances.put(player, balance);
                this.updateLeaderboard();
                return balance;
            }
            return null;
        }
        return this.balances.get(player);
    }

    public void addMoney(UUID player, long amount) {
        this.balances.put(player, this.clamp(this.getBalance(player, true) + amount));
        this.updateLeaderboard();
        this.save();
    }

    public void setMoney(UUID player, long amount) {
        this.balances.put(player, this.clamp(amount));
        this.updateLeaderboard();
        this.save();
    }

    public boolean removeMoney(UUID player, long amount) {
        long balance = this.getBalance(player, true);
        if (balance < amount) {
            return false;
        }
        this.balances.put(player, this.clamp(balance - amount));
        this.updateLeaderboard();
        this.save();
        return true;
    }

    public boolean pay(UUID from, UUID to, long amount) {
        long balance = this.getBalance(from, false);
        if (balance < amount) {
            return false;
        }
        this.removeMoney(from, amount);
        this.addMoney(to, amount);
        return true;
    }

    public void load() {
        if (Files.exists(this.file, new LinkOption[0])) {
            try {
                String json = Files.readString(this.file);
                Map map = (Map)GSON.fromJson(json, new TypeToken<Map<UUID, Double>>(this){}.getType());
                if (map != null) {
                    for (Map.Entry e : map.entrySet()) {
                        this.balances.put((UUID)e.getKey(), Math.min(((Double)e.getValue()).longValue(), 999999999L));
                    }
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    public void save() {
        try {
            HashMap<UUID, Long> data = new HashMap<UUID, Long>(this.balances);
            String json = GSON.toJson(data, TYPE);
            Files.writeString(this.file, (CharSequence)json, new OpenOption[0]);
        }
        catch (IOException data) {
            // empty catch block
        }
        try {
            String json = GSON.toJson(this.lastDaily, new TypeToken<Map<UUID, Long>>(this){}.getType());
            Files.writeString(this.dailyFile, (CharSequence)json, new OpenOption[0]);
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public Map<UUID, Long> getBalances() {
        return this.balances;
    }

    public void removePlayer(UUID id) {
        this.balances.remove(id);
        this.updateLeaderboard();
        this.save();
    }

    public ShopManager getShop() {
        return this.shop;
    }

    public OrderManager getOrders() {
        return this.orders;
    }

    public boolean claimDaily(UUID player) {
        long today = LocalDate.now().toEpochDay();
        long last = this.lastDaily.getOrDefault(player, -1L);
        if (last == today) {
            return false;
        }
        this.lastDaily.put(player, today);
        this.addMoney(player, EconomyConfig.get().dailyAmount);
        return true;
    }

    private void loadDaily() {
        if (Files.exists(this.dailyFile, new LinkOption[0])) {
            try {
                String json = Files.readString(this.dailyFile);
                Map map = (Map)GSON.fromJson(json, new TypeToken<Map<UUID, Long>>(this){}.getType());
                if (map != null) {
                    this.lastDaily.putAll(map);
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    private void setupObjective() {
        ServerScoreboard board = this.server.getScoreboard();
        this.objective = board.getObjective("eco_balance");
        if (this.objective == null) {
            this.objective = board.addObjective("eco_balance", ObjectiveCriteria.DUMMY, (Component)Component.literal((String)"Balance"), ObjectiveCriteria.RenderType.INTEGER, true, null);
        }
        board.setDisplayObjective(DisplaySlot.SIDEBAR, this.objective);
        this.updateLeaderboard();
    }

    private void updateLeaderboard() {
        if (!EconomyConfig.get().scoreboardEnabled) {
            return;
        }
        ServerScoreboard board = this.server.getScoreboard();
        if (this.objective != null) {
            board.removeObjective(this.objective);
        }
        this.objective = board.addObjective("eco_balance", ObjectiveCriteria.DUMMY, (Component)Component.literal((String)"Balance"), ObjectiveCriteria.RenderType.INTEGER, true, null);
        board.setDisplayObjective(DisplaySlot.SIDEBAR, this.objective);
        this.displayed.clear();
        ArrayList<Map.Entry<UUID, Long>> sorted = new ArrayList<Map.Entry<UUID, Long>>(this.balances.entrySet());
        sorted.sort(Map.Entry.comparingByValue().reversed());
        for (Map.Entry e : sorted.stream().limit(5L).toList()) {
            String name = this.server.getProfileCache().get((UUID)e.getKey()).map(p -> p.getName()).orElse(((UUID)e.getKey()).toString());
            board.getOrCreatePlayerScore(ScoreHolder.forNameOnly((String)name), this.objective).set(((Long)e.getValue()).intValue());
            this.displayed.add((UUID)e.getKey());
        }
    }

    private long clamp(long value) {
        return Math.max(0L, Math.min(999999999L, value));
    }

    public boolean toggleScoreboard() {
        ServerScoreboard board = this.server.getScoreboard();
        EconomyConfig.get().scoreboardEnabled = !EconomyConfig.get().scoreboardEnabled;
        EconomyConfig.save();
        if (EconomyConfig.get().scoreboardEnabled) {
            this.setupObjective();
        } else {
            board.setDisplayObjective(DisplaySlot.SIDEBAR, null);
            if (this.objective != null) {
                board.removeObjective(this.objective);
                this.objective = null;
            }
        }
        return EconomyConfig.get().scoreboardEnabled;
    }

    public void handlePvpKill(ServerPlayer victim, ServerPlayer killer) {
        double pct = EconomyConfig.get().pvpBalanceLossPercentage;
        if (pct <= 0.0) {
            return;
        }
        if (victim == null || killer == null) {
            return;
        }
        if (victim.getUUID().equals(killer.getUUID())) {
            return;
        }
        long victimBal = this.getBalance(victim.getUUID(), true);
        if (victimBal <= 0L) {
            return;
        }
        long loss = (long)Math.floor(pct * (double)victimBal);
        if (loss <= 0L) {
            return;
        }
        this.removeMoney(victim.getUUID(), loss);
        this.addMoney(killer.getUUID(), loss);
        victim.sendSystemMessage((Component)Component.literal((String)("You lost " + EconomyCraft.formatMoney(loss) + " for being killed by " + killer.getName().getString())).withStyle(ChatFormatting.RED));
        killer.sendSystemMessage((Component)Component.literal((String)("You received " + EconomyCraft.formatMoney(loss) + " for killing " + victim.getName().getString())).withStyle(ChatFormatting.GREEN));
    }
}

