/*
 * Decompiled with CFR 0.152.
 */
package mcjty.lib.gui;

import java.io.IOException;
import java.io.PrintWriter;
import java.io.Reader;
import java.io.StreamTokenizer;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import mcjty.lib.varia.Logging;
import org.apache.logging.log4j.util.Strings;

public class GuiParser {
    @Nullable
    private static GuiCommand parseCommand(StreamTokenizer tokenizer) throws IOException, ParserException {
        int token = tokenizer.nextToken();
        if (token == -1) {
            return null;
        }
        if (token != -3) {
            throw new ParserException("Expected a command token, got a '" + (char)token + "' instead!", tokenizer.lineno());
        }
        GuiCommand guiCommand = new GuiCommand(tokenizer.sval);
        token = tokenizer.nextToken();
        if (token == 40) {
            token = tokenizer.nextToken();
            while (token != 41) {
                if (token == -3 || token == 39) {
                    if (token == -3 && "true".equals(tokenizer.sval.toLowerCase())) {
                        guiCommand.parameter(true);
                    } else if (token == -3 && "false".equals(tokenizer.sval.toLowerCase())) {
                        guiCommand.parameter(false);
                    } else {
                        guiCommand.parameter(tokenizer.sval);
                    }
                } else if (token == -2) {
                    guiCommand.parameter((int)tokenizer.nval);
                } else {
                    throw new ParserException("Expected parameter! Got '" + (char)token + "' instead", tokenizer.lineno());
                }
                if ((token = tokenizer.nextToken()) != 44) continue;
                token = tokenizer.nextToken();
            }
            token = tokenizer.nextToken();
        }
        if (token != 123) {
            tokenizer.pushBack();
        } else {
            while (token != 125) {
                if (token != 123) {
                    tokenizer.pushBack();
                }
                guiCommand.command(GuiParser.parseCommand(tokenizer));
                token = tokenizer.nextToken();
            }
        }
        return guiCommand;
    }

    public static List<GuiCommand> parse(Reader reader) throws IOException, ParserException {
        StreamTokenizer tokenizer = new StreamTokenizer(reader);
        tokenizer.slashSlashComments(true);
        tokenizer.eolIsSignificant(false);
        tokenizer.quoteChar(39);
        tokenizer.parseNumbers();
        ArrayList<GuiCommand> commands = new ArrayList<GuiCommand>();
        GuiCommand command = GuiParser.parseCommand(tokenizer);
        while (command != null) {
            commands.add(command);
            command = GuiParser.parseCommand(tokenizer);
        }
        return commands;
    }

    public static void main(String[] args) {
        StringReader reader = new StringReader("                panel() {\n            layout(positional)\n            bgimage('rftools:textures/gui/securitymanager.png')\n            widgetlist('players') {\n                bgthickness(-1)\n                bgfilled1(-7631989)\n            }\n            slider() {\n                scrollable('players')\n                desiredwidth(10)\n            }\n        }");
        try {
            GuiParser.parse(reader).forEach(command -> command.dump(1));
        }
        catch (IOException | ParserException e) {
            Logging.logError("Error parsing!", e);
        }
    }

    public static <T> void put(GuiCommand parent, String name, T value, T def) {
        if (value == null) {
            return;
        }
        if (value.equals(def)) {
            return;
        }
        parent.command(new GuiCommand(name).parameter(value));
    }

    public static <T> T get(GuiCommand parent, String name, T def) {
        return (T)parent.findCommand(name).map(cmd -> cmd.getOptionalPar(0, def)).orElse(def);
    }

    public static <T> T getIndexed(GuiCommand parent, String name, int idx, T def) {
        return (T)parent.findCommand(name).map(cmd -> cmd.getOptionalPar(idx, def)).orElse(def);
    }

    public static class ParserException
    extends Exception {
        public ParserException(String s, int linenr) {
            super(s + " (line " + linenr + ")");
        }
    }

    public static class GuiCommand {
        private final String id;
        private final List<Object> parameters = new ArrayList<Object>();
        private final List<GuiCommand> guiCommands = new ArrayList<GuiCommand>();
        private final Map<String, GuiCommand> commandMap = new HashMap<String, GuiCommand>();

        public GuiCommand(String id) {
            this.id = id;
        }

        public String getId() {
            return this.id;
        }

        public GuiCommand parameter(Object parameter) {
            this.parameters.add(parameter);
            return this;
        }

        public GuiCommand command(GuiCommand guiCommand) {
            this.guiCommands.add(guiCommand);
            this.commandMap.put(guiCommand.getId(), guiCommand);
            return this;
        }

        public List<Object> getParameters() {
            return this.parameters;
        }

        public List<GuiCommand> getGuiCommands() {
            return this.guiCommands;
        }

        public Optional<GuiCommand> findCommand(String cmd) {
            return Optional.ofNullable(this.commandMap.get(cmd));
        }

        public Stream<GuiCommand> commands() {
            return this.guiCommands.stream();
        }

        public void removeParameter(int index) {
            this.parameters.remove(index);
        }

        public Stream<Object> parameters() {
            return this.parameters.stream();
        }

        public <T> T getOptionalPar(int par, T def) {
            if (par >= this.getParameters().size()) {
                return def;
            }
            return (T)this.getParameters().get(par);
        }

        public String toString() {
            return "Command{id='" + this.id + "', parameters=" + String.valueOf(this.parameters) + ", commands=" + String.valueOf(this.guiCommands) + "}";
        }

        private static String ind(int i) {
            return "                                                                        ".substring(0, i);
        }

        public void write(PrintWriter writer, int indent) {
            writer.print(GuiCommand.ind(indent) + this.id);
            if (!this.parameters.isEmpty() && this.parameters().anyMatch(o -> o != null && !"".equals(o))) {
                writer.print('(');
                String comma = "";
                for (Object parameter : this.parameters) {
                    Object par = parameter;
                    if (par instanceof String) {
                        par = Strings.quote((String)((String)par));
                    }
                    writer.print(comma + String.valueOf(par));
                    comma = ",";
                }
                writer.print(')');
            }
            if (this.guiCommands.isEmpty()) {
                writer.println("");
            } else {
                writer.println(" {");
                for (GuiCommand cmd : this.guiCommands) {
                    cmd.write(writer, indent + 4);
                }
                writer.println(GuiCommand.ind(indent) + "}");
            }
        }

        public void dump(int indent) {
            System.out.print(GuiCommand.ind(indent) + this.id + "(");
            String comma = "";
            for (Object parameter : this.parameters) {
                Object par = parameter;
                if (par instanceof String) {
                    par = Strings.quote((String)((String)par));
                }
                System.out.print(comma + String.valueOf(par));
                comma = ",";
            }
            System.out.print(")");
            if (this.guiCommands.isEmpty()) {
                System.out.println("");
            } else {
                System.out.println(" {");
                for (GuiCommand cmd : this.guiCommands) {
                    cmd.dump(indent + 4);
                }
                System.out.println(GuiCommand.ind(indent) + "}");
            }
        }
    }
}

