/*
 * Decompiled with CFR 0.152.
 */
package mcjty.rftoolsbuilder.modules.builder.client;

import java.util.List;
import java.util.stream.Collectors;
import mcjty.lib.base.StyleConfig;
import mcjty.lib.client.GuiTools;
import mcjty.lib.client.RenderHelper;
import mcjty.lib.gui.BaseScreen;
import mcjty.lib.gui.IKeyReceiver;
import mcjty.lib.gui.Window;
import mcjty.lib.gui.WindowManager;
import mcjty.lib.gui.layout.HorizontalAlignment;
import mcjty.lib.gui.layout.Layout;
import mcjty.lib.gui.layout.VerticalLayout;
import mcjty.lib.gui.widgets.AbstractContainerWidget;
import mcjty.lib.gui.widgets.ChoiceLabel;
import mcjty.lib.gui.widgets.Label;
import mcjty.lib.gui.widgets.Panel;
import mcjty.lib.gui.widgets.TextField;
import mcjty.lib.gui.widgets.ToggleButton;
import mcjty.lib.gui.widgets.Widget;
import mcjty.lib.gui.widgets.Widgets;
import mcjty.lib.varia.ComponentFactory;
import mcjty.rftoolsbuilder.modules.builder.BuilderConfiguration;
import mcjty.rftoolsbuilder.modules.builder.items.ShapeCardItem;
import mcjty.rftoolsbuilder.modules.builder.items.ShapeCardType;
import mcjty.rftoolsbuilder.modules.builder.network.PacketOpenBuilderGui;
import mcjty.rftoolsbuilder.modules.builder.network.PacketUpdateCardInInventory;
import mcjty.rftoolsbuilder.modules.builder.network.PacketUpdateCardInPlayer;
import mcjty.rftoolsbuilder.modules.scanner.ScannerConfiguration;
import mcjty.rftoolsbuilder.setup.RFToolsBuilderMessages;
import mcjty.rftoolsbuilder.shapes.IShapeParentGui;
import mcjty.rftoolsbuilder.shapes.Shape;
import mcjty.rftoolsbuilder.shapes.ShapeID;
import mcjty.rftoolsbuilder.shapes.ShapeRenderer;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.core.BlockPos;
import net.minecraft.locale.Language;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.neoforged.neoforge.capabilities.Capabilities;
import net.neoforged.neoforge.items.IItemHandler;

public class GuiShapeCard
extends BaseScreen
implements IShapeParentGui,
IKeyReceiver {
    protected int xSize = 360;
    protected int ySize = 160;
    private int guiLeft;
    private int guiTop;
    private boolean isQuarryCard;
    private ChoiceLabel shapeLabel;
    private ChoiceLabel solidLabel;
    private TextField dimX;
    private TextField dimY;
    private TextField dimZ;
    private TextField offsetX;
    private TextField offsetY;
    private TextField offsetZ;
    private Window window = null;
    private Label blocksLabel;
    private Panel voidPanel;
    private ToggleButton stone;
    private ToggleButton cobble;
    private ToggleButton dirt;
    private ToggleButton gravel;
    private ToggleButton sand;
    private ToggleButton netherrack;
    private ToggleButton endstone;
    private ToggleButton tagMatching;
    public final boolean fromTE;
    public static BlockPos fromTEPos = null;
    public static int fromTEStackSlot = 0;
    private ShapeID shapeID = null;
    private ShapeRenderer shapeRenderer = null;
    private final boolean[] buttons = new boolean[10];
    private static int updateCounter = 20;

    public GuiShapeCard(boolean fromTE) {
        super((Component)ComponentFactory.literal((String)"Shapecard"));
        this.fromTE = fromTE;
    }

    public void removed() {
        super.removed();
        if (this.fromTE) {
            RFToolsBuilderMessages.sendToServer(PacketOpenBuilderGui.create(fromTEPos));
        }
    }

    private ShapeRenderer getShapeRenderer() {
        if (this.shapeID == null) {
            this.shapeID = this.getShapeID();
        } else if (!this.shapeID.equals(this.getShapeID())) {
            this.shapeID = this.getShapeID();
            this.shapeRenderer = null;
        }
        if (this.shapeRenderer == null) {
            this.shapeRenderer = new ShapeRenderer(this.shapeID);
            this.shapeRenderer.initView(this.getPreviewLeft(), this.guiTop);
        }
        return this.shapeRenderer;
    }

    private ShapeID getShapeID() {
        ItemStack stackToEdit = this.getStackToEdit();
        return new ShapeID((ResourceKey<Level>)Level.OVERWORLD, null, ShapeCardItem.getScanId(stackToEdit), false, ShapeCardItem.isSolid(stackToEdit));
    }

    public boolean isPauseScreen() {
        return false;
    }

    private ItemStack getStackToEdit() {
        if (this.fromTE) {
            BlockEntity te = this.minecraft.level.getBlockEntity(fromTEPos);
            IItemHandler capability = (IItemHandler)te.getLevel().getCapability(Capabilities.ItemHandler.BLOCK, fromTEPos, null);
            if (capability == null) {
                return ItemStack.EMPTY;
            }
            return capability.getStackInSlot(fromTEStackSlot);
        }
        return this.minecraft.player.getItemInHand(InteractionHand.MAIN_HAND);
    }

    @Override
    public int getPreviewLeft() {
        return this.guiLeft + 104;
    }

    @Override
    public int getPreviewTop() {
        return this.guiTop - 5 + (this.isQuarryCard ? 0 : 10);
    }

    public void init() {
        Panel toplevel;
        super.init();
        this.guiLeft = (this.width - this.xSize) / 2;
        this.guiTop = (this.height - this.ySize) / 2;
        ItemStack heldItem = this.getStackToEdit();
        if (heldItem.isEmpty()) {
            return;
        }
        ShapeCardType type = ShapeCardItem.getType(heldItem);
        this.isQuarryCard = type.isQuarry();
        if (this.isQuarryCard) {
            this.ySize = 188;
        }
        this.getShapeRenderer().initView(this.getPreviewLeft(), this.guiTop);
        this.shapeLabel = ((ChoiceLabel)((ChoiceLabel)new ChoiceLabel().desiredWidth(100)).desiredHeight(16)).choices(new String[]{Shape.SHAPE_BOX.getDescription(), Shape.SHAPE_TOPDOME.getDescription(), Shape.SHAPE_BOTTOMDOME.getDescription(), Shape.SHAPE_SPHERE.getDescription(), Shape.SHAPE_CYLINDER.getDescription(), Shape.SHAPE_CAPPEDCYLINDER.getDescription(), Shape.SHAPE_PRISM.getDescription(), Shape.SHAPE_TORUS.getDescription(), Shape.SHAPE_CONE.getDescription(), Shape.SHAPE_HEART.getDescription(), Shape.SHAPE_COMPOSITION.getDescription(), Shape.SHAPE_SCAN.getDescription()}).event(newChoice -> this.updateSettings());
        this.solidLabel = ((ChoiceLabel)((ChoiceLabel)new ChoiceLabel().desiredWidth(50)).desiredHeight(16)).choices(new String[]{"Hollow", "Solid"}).event(newChoice -> this.updateSettings());
        Panel shapePanel = (Panel)Widgets.horizontal().children(new Widget[]{this.shapeLabel, this.solidLabel});
        Shape shape = ShapeCardItem.getShape(heldItem);
        this.shapeLabel.choice(shape.getDescription());
        boolean solid = ShapeCardItem.isSolid(heldItem);
        this.solidLabel.choice(solid ? "Solid" : "Hollow");
        this.blocksLabel = (Label)Widgets.label((String)"# ").horizontalAlignment(HorizontalAlignment.ALIGN_LEFT);
        ((Label)this.blocksLabel.desiredWidth(100)).desiredHeight(16);
        Panel modePanel = (Panel)((Panel)Widgets.vertical().desiredWidth(170)).children(new Widget[]{shapePanel, this.blocksLabel});
        BlockPos dim = ShapeCardItem.getDimension(heldItem);
        BlockPos offset = ShapeCardItem.getOffset(heldItem);
        this.dimX = new TextField().event(newText -> {
            if (this.isTorus()) {
                this.dimZ.text(newText);
            }
            this.updateSettings();
        }).text(String.valueOf(dim.getX()));
        this.dimY = new TextField().event(newText -> this.updateSettings()).text(String.valueOf(dim.getY()));
        this.dimZ = new TextField().event(newText -> this.updateSettings()).text(String.valueOf(dim.getZ()));
        Panel dimPanel = (Panel)((Panel)Widgets.horizontal((int)0, (int)5).desiredHeight(18)).children(new Widget[]{((Label)Widgets.label((String)"Dim:").horizontalAlignment(HorizontalAlignment.ALIGN_RIGHT)).desiredWidth(40), this.dimX, this.dimY, this.dimZ});
        this.offsetX = new TextField().event(newText -> this.updateSettings()).text(String.valueOf(offset.getX()));
        this.offsetY = new TextField().event(newText -> this.updateSettings()).text(String.valueOf(offset.getY()));
        this.offsetZ = new TextField().event(newText -> this.updateSettings()).text(String.valueOf(offset.getZ()));
        Panel offsetPanel = (Panel)((Panel)Widgets.horizontal((int)0, (int)5).desiredHeight(18)).children(new Widget[]{((Label)Widgets.label((String)"Offset:").horizontalAlignment(HorizontalAlignment.ALIGN_RIGHT)).desiredWidth(40), this.offsetX, this.offsetY, this.offsetZ});
        Panel settingsPanel = (Panel)new Panel().layout((Layout)((VerticalLayout)((VerticalLayout)new VerticalLayout().setSpacing(1)).setVerticalMargin(1)).setHorizontalMargin(0)).children(new Widget[]{dimPanel, offsetPanel});
        int k = (this.width - this.xSize) / 2;
        int l = (this.height - this.ySize) / 2;
        Panel modeSettingsPanel = (Panel)new Panel().layout((Layout)new VerticalLayout().setHorizontalMargin(0)).children(new Widget[]{modePanel, settingsPanel});
        modeSettingsPanel.hint(0, 0, 180, 160);
        if (this.isQuarryCard) {
            this.setupVoidPanel(heldItem);
            toplevel = (Panel)((Panel)Widgets.positional().filledRectThickness(2)).children(new Widget[]{modeSettingsPanel, this.voidPanel});
        } else {
            toplevel = (Panel)((Panel)Widgets.positional().filledRectThickness(2)).children(new Widget[]{modeSettingsPanel});
        }
        toplevel.bounds(k, l, this.xSize, this.ySize);
        this.window = new Window((Screen)this, (AbstractContainerWidget)toplevel);
    }

    private void setupVoidPanel(ItemStack heldItem) {
        this.voidPanel = (Panel)((Panel)((Panel)Widgets.horizontal().desiredHeight(26)).filledRectThickness(-2)).filledBackground(StyleConfig.colorListBackground);
        this.voidPanel.hint(5, 155, 350, 26);
        Label label = Widgets.label((String)"Void:");
        this.stone = ((ToggleButton)((ToggleButton)((ToggleButton)new ToggleButton().desiredWidth(20)).desiredHeight(20)).tooltips(new String[]{"Void stone"})).event(this::updateVoidSettings);
        this.cobble = ((ToggleButton)((ToggleButton)((ToggleButton)new ToggleButton().desiredWidth(20)).desiredHeight(20)).tooltips(new String[]{"Void cobble"})).event(this::updateVoidSettings);
        this.dirt = ((ToggleButton)((ToggleButton)((ToggleButton)new ToggleButton().desiredWidth(20)).desiredHeight(20)).tooltips(new String[]{"Void dirt"})).event(this::updateVoidSettings);
        this.gravel = ((ToggleButton)((ToggleButton)((ToggleButton)new ToggleButton().desiredWidth(20)).desiredHeight(20)).tooltips(new String[]{"Void gravel"})).event(this::updateVoidSettings);
        this.sand = ((ToggleButton)((ToggleButton)((ToggleButton)new ToggleButton().desiredWidth(20)).desiredHeight(20)).tooltips(new String[]{"Void sand"})).event(this::updateVoidSettings);
        this.netherrack = ((ToggleButton)((ToggleButton)((ToggleButton)new ToggleButton().desiredWidth(20)).desiredHeight(20)).tooltips(new String[]{"Void netherrack"})).event(this::updateVoidSettings);
        this.endstone = ((ToggleButton)((ToggleButton)((ToggleButton)new ToggleButton().desiredWidth(20)).desiredHeight(20)).tooltips(new String[]{"Void end stone"})).event(this::updateVoidSettings);
        this.tagMatching = ((ToggleButton)((ToggleButton)((ToggleButton)((ToggleButton)new ToggleButton().desiredWidth(60)).desiredHeight(15)).tooltips(new String[]{"Enable tag matching"})).text("Tags")).checkMarker(true).event(this::updateVoidSettings);
        this.stone.pressed(ShapeCardItem.isVoiding(heldItem, "stone"));
        this.cobble.pressed(ShapeCardItem.isVoiding(heldItem, "cobble"));
        this.dirt.pressed(ShapeCardItem.isVoiding(heldItem, "dirt"));
        this.gravel.pressed(ShapeCardItem.isVoiding(heldItem, "gravel"));
        this.sand.pressed(ShapeCardItem.isVoiding(heldItem, "sand"));
        this.netherrack.pressed(ShapeCardItem.isVoiding(heldItem, "netherrack"));
        this.endstone.pressed(ShapeCardItem.isVoiding(heldItem, "endstone"));
        this.tagMatching.pressed(ShapeCardItem.isTagMatching(heldItem));
        this.voidPanel.children(new Widget[]{label, this.stone, this.cobble, this.dirt, this.gravel, this.sand, this.netherrack, this.endstone, this.tagMatching});
    }

    private boolean isTorus() {
        Shape shape = this.getCurrentShape();
        return Shape.SHAPE_TORUS.equals((Object)shape);
    }

    private Shape getCurrentShape() {
        return Shape.getShape(this.shapeLabel.getCurrentChoice());
    }

    private boolean isSolid() {
        return "Solid".equals(this.solidLabel.getCurrentChoice());
    }

    private static int parseInt(String s) {
        try {
            return Integer.parseInt(s);
        }
        catch (NumberFormatException e) {
            return 0;
        }
    }

    private void updateSettings() {
        ItemStack stack;
        int dx = GuiShapeCard.parseInt(this.dimX.getText());
        int dy = GuiShapeCard.parseInt(this.dimY.getText());
        int dz = GuiShapeCard.parseInt(this.dimZ.getText());
        int max = Math.max((Integer)ScannerConfiguration.maxScannerDimension.get(), (Integer)BuilderConfiguration.maxBuilderDimension.get());
        if (dx < 0) {
            dx = 0;
        } else if (dx > max) {
            dx = max;
        }
        this.dimX.text(Integer.toString(dx));
        if (dz < 0) {
            dz = 0;
        } else if (dz > max) {
            dz = max;
        }
        this.dimZ.text(Integer.toString(dz));
        if (dy < 0) {
            dy = 0;
        }
        this.dimY.text(Integer.toString(dy));
        if (this.isTorus()) {
            this.dimZ.text(this.dimX.getText());
        }
        if (!(stack = this.getStackToEdit()).isEmpty()) {
            ShapeCardItem.setShape(stack, this.getCurrentShape(), this.isSolid());
            ShapeCardItem.setDimension(stack, dx, dy, dz);
            ShapeCardItem.setOffset(stack, GuiShapeCard.parseInt(this.offsetX.getText()), GuiShapeCard.parseInt(this.offsetY.getText()), GuiShapeCard.parseInt(this.offsetZ.getText()));
            if (this.fromTE) {
                RFToolsBuilderMessages.sendToServer(PacketUpdateCardInInventory.create(fromTEPos, fromTEStackSlot, stack));
            } else {
                RFToolsBuilderMessages.sendToServer(PacketUpdateCardInPlayer.create(stack));
            }
        }
    }

    private void updateVoidSettings() {
        ItemStack stack = this.getStackToEdit();
        if (!stack.isEmpty()) {
            ShapeCardItem.clearVoiding(stack);
            if (this.stone.isPressed()) {
                ShapeCardItem.addVoiding(stack, "stone");
            }
            if (this.cobble.isPressed()) {
                ShapeCardItem.addVoiding(stack, "cobble");
            }
            if (this.dirt.isPressed()) {
                ShapeCardItem.addVoiding(stack, "dirt");
            }
            if (this.gravel.isPressed()) {
                ShapeCardItem.addVoiding(stack, "gravel");
            }
            if (this.sand.isPressed()) {
                ShapeCardItem.addVoiding(stack, "sand");
            }
            if (this.netherrack.isPressed()) {
                ShapeCardItem.addVoiding(stack, "netherrack");
            }
            if (this.endstone.isPressed()) {
                ShapeCardItem.addVoiding(stack, "endstone");
            }
            ShapeCardItem.setTagMatching(stack, this.tagMatching.isPressed());
            if (this.fromTE) {
                RFToolsBuilderMessages.sendToServer(PacketUpdateCardInInventory.create(fromTEPos, fromTEStackSlot, stack));
            } else {
                RFToolsBuilderMessages.sendToServer(PacketUpdateCardInPlayer.create(stack));
            }
        }
    }

    public void mouseMoved(double xx, double yy) {
        if (this.window == null) {
            return;
        }
        this.window.mouseDragged(xx, yy, 0);
        int x = GuiTools.getRelativeX((Screen)this);
        int y = GuiTools.getRelativeY((Screen)this);
        this.getShapeRenderer().handleShapeDragging(x -= this.guiLeft, y -= this.guiTop, this.buttons);
    }

    public boolean mouseClicked(double x, double y, int button) {
        if (this.window == null) {
            return false;
        }
        if (button < this.buttons.length) {
            this.buttons[button] = true;
        }
        boolean rc = super.mouseClicked(x, y, button);
        this.window.mouseClicked(x, y, button);
        return rc;
    }

    public boolean mouseReleased(double mouseX, double mouseY, int button) {
        if (this.window == null) {
            return false;
        }
        if (button < this.buttons.length) {
            this.buttons[button] = false;
        }
        boolean rc = super.mouseReleased(mouseX, mouseY, button);
        this.window.mouseReleased(mouseX, mouseY, button);
        return rc;
    }

    public boolean keyPressed(int keyCode, int scanCode, int modifiers) {
        if (this.window == null) {
            return false;
        }
        boolean rc = false;
        if (!this.window.keyTyped(keyCode, scanCode)) {
            rc = super.keyPressed(keyCode, scanCode, modifiers);
        }
        return rc;
    }

    public Window getWindow() {
        return this.window;
    }

    public void keyTypedFromEvent(int keyCode, int scanCode) {
        if (this.window != null && this.window.keyTyped(keyCode, scanCode)) {
            super.keyPressed(keyCode, scanCode, 0);
        }
    }

    public void charTypedFromEvent(char codePoint) {
        if (this.window != null && this.window.charTyped(codePoint)) {
            super.charTyped(codePoint, 0);
        }
    }

    public boolean mouseClickedFromEvent(double x, double y, int button) {
        WindowManager manager = this.getWindow().getWindowManager();
        manager.mouseClicked(x, y, button);
        return true;
    }

    public boolean mouseReleasedFromEvent(double x, double y, int button) {
        WindowManager manager = this.getWindow().getWindowManager();
        manager.mouseReleased(x, y, button);
        return true;
    }

    public boolean mouseScrolledFromEvent(double x, double y, double dx, double dy) {
        WindowManager manager = this.getWindow().getWindowManager();
        manager.mouseScrolled(x, y, dx, dy);
        return true;
    }

    public boolean mouseScrolled(double x, double y, double wheelX, double wheelY) {
        if (this.window == null) {
            return false;
        }
        this.getShapeRenderer().handleMouseWheel(wheelX, wheelY);
        return super.mouseScrolled(x, y, wheelX, wheelY);
    }

    protected void renderInternal(GuiGraphics graphics, int pMouseX, int pMouseY, float pPartialTick) {
        List tooltips;
        ItemStack stack;
        if (this.window == null) {
            return;
        }
        this.dimZ.enabled(!this.isTorus());
        if (--updateCounter <= 0) {
            updateCounter = 10;
            int count = this.getShapeRenderer().getCount();
            if (count >= 50000000) {
                this.blocksLabel.text("#Blocks: ++" + count);
            } else {
                this.blocksLabel.text("#Blocks: " + count);
            }
        }
        this.window.draw(graphics);
        if (this.isQuarryCard) {
            int x = (int)(this.window.getToplevel().getBounds().getX() + this.voidPanel.getBounds().getX()) + 1;
            int y = (int)(this.window.getToplevel().getBounds().getY() + this.voidPanel.getBounds().getY() + this.stone.getBounds().getY()) + 1;
            this.renderVoidBlock(graphics, x, y, this.stone, Blocks.STONE);
            this.renderVoidBlock(graphics, x, y, this.cobble, Blocks.COBBLESTONE);
            this.renderVoidBlock(graphics, x, y, this.dirt, Blocks.DIRT);
            this.renderVoidBlock(graphics, x, y, this.gravel, Blocks.GRAVEL);
            this.renderVoidBlock(graphics, x, y, this.sand, Blocks.SAND);
            this.renderVoidBlock(graphics, x, y, this.netherrack, Blocks.NETHERRACK);
            this.renderVoidBlock(graphics, x, y, this.endstone, Blocks.END_STONE);
        }
        if (!(stack = this.getStackToEdit()).isEmpty()) {
            // empty if block
        }
        if ((tooltips = this.window.getTooltips()) != null) {
            int guiLeft = (this.width - this.xSize) / 2;
            int guiTop = (this.height - this.ySize) / 2;
            int x = GuiTools.getRelativeX((Screen)this);
            int y = GuiTools.getRelativeY((Screen)this);
            List properties = tooltips.stream().map(ComponentFactory::literal).collect(Collectors.toList());
            List processors = Language.getInstance().getVisualOrder(properties);
            graphics.renderTooltip(Minecraft.getInstance().font, processors, x - guiLeft, y - guiTop);
        }
    }

    private void renderVoidBlock(GuiGraphics graphics, int x, int y, ToggleButton button, Block block) {
        RenderHelper.renderObject((GuiGraphics)graphics, (int)(x += (int)button.getBounds().getX()), (int)y, (Object)new ItemStack((ItemLike)block), (boolean)button.isPressed());
        if (button.isPressed()) {
            RenderHelper.drawFlatBox((GuiGraphics)graphics, (int)x, (int)y, (int)(x + 17), (int)(y + 17), (int)0x55FF0000, (int)0x55FF0000);
        }
    }

    public static void open(boolean fromTE) {
        Minecraft.getInstance().setScreen((Screen)new GuiShapeCard(fromTE));
    }
}

