/*
 * Decompiled with CFR 0.152.
 */
package mcjty.rftoolsbuilder.modules.mover.blocks;

import mcjty.rftoolsbuilder.modules.mover.MoverModule;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderGetter;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.registries.Registries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtUtils;
import net.minecraft.nbt.Tag;
import net.minecraft.network.Connection;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import org.jetbrains.annotations.Nullable;

public class InvisibleMoverBE
extends BlockEntity {
    private BlockState originalState;

    public InvisibleMoverBE(BlockPos pos, BlockState state) {
        super(MoverModule.TYPE_INVISIBLE_MOVER.get(), pos, state);
    }

    public void onDataPacket(Connection net, ClientboundBlockEntityDataPacket pkt, HolderLookup.Provider provider) {
        this.loadInt(pkt.getTag(), provider);
    }

    @Nullable
    public Packet<ClientGamePacketListener> getUpdatePacket() {
        CompoundTag tag = this.getUpdateTag((HolderLookup.Provider)this.level.registryAccess());
        return ClientboundBlockEntityDataPacket.create((BlockEntity)this, (entity, access) -> tag);
    }

    public CompoundTag getUpdateTag(HolderLookup.Provider provider) {
        return this.saveInt(super.getUpdateTag(provider));
    }

    public BlockState getOriginalState() {
        return this.originalState;
    }

    public void setOriginalState(BlockState originalState) {
        this.originalState = originalState;
        this.setChanged();
    }

    public void loadAdditional(CompoundTag tag, HolderLookup.Provider provider) {
        super.loadAdditional(tag, provider);
        this.loadInt(tag, provider);
    }

    private void loadInt(CompoundTag tag, HolderLookup.Provider provider) {
        this.originalState = NbtUtils.readBlockState((HolderGetter)((HolderGetter)provider.lookup(Registries.BLOCK).get()), (CompoundTag)tag.getCompound("originalState"));
    }

    protected void saveAdditional(CompoundTag tag, HolderLookup.Provider provider) {
        super.saveAdditional(tag, provider);
        this.saveInt(tag);
    }

    private CompoundTag saveInt(CompoundTag tag) {
        if (this.originalState != null) {
            CompoundTag tagState = NbtUtils.writeBlockState((BlockState)this.originalState);
            tag.put("originalState", (Tag)tagState);
        }
        return tag;
    }
}

