/*
 * Decompiled with CFR 0.152.
 */
package mcjty.rftoolscontrol.modules.craftingstation.blocks;

import java.util.ArrayList;
import java.util.List;
import java.util.function.Function;
import java.util.function.Supplier;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import mcjty.lib.api.container.DefaultContainerProvider;
import mcjty.lib.api.container.ItemInventory;
import mcjty.lib.blockcommands.Command;
import mcjty.lib.blockcommands.ListCommand;
import mcjty.lib.blockcommands.ServerCommand;
import mcjty.lib.container.ContainerFactory;
import mcjty.lib.container.GenericItemHandler;
import mcjty.lib.container.SlotDefinition;
import mcjty.lib.setup.Registration;
import mcjty.lib.tileentity.Cap;
import mcjty.lib.tileentity.CapType;
import mcjty.lib.tileentity.GenericTileEntity;
import mcjty.lib.typed.Key;
import mcjty.lib.typed.Type;
import mcjty.lib.varia.BlockPosTools;
import mcjty.lib.varia.ItemStackList;
import mcjty.rftoolsbase.api.control.parameters.Inventory;
import mcjty.rftoolscontrol.modules.craftingstation.CraftingStationModule;
import mcjty.rftoolscontrol.modules.craftingstation.client.GuiCraftingStation;
import mcjty.rftoolscontrol.modules.craftingstation.data.CraftingStationData;
import mcjty.rftoolscontrol.modules.craftingstation.util.CraftingRequest;
import mcjty.rftoolscontrol.modules.processor.blocks.ProcessorTileEntity;
import mcjty.rftoolscontrol.modules.processor.logic.running.ExceptionType;
import mcjty.rftoolscontrol.modules.processor.logic.running.ProgException;
import mcjty.rftoolscontrol.setup.Config;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.component.DataComponentMap;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.neoforged.neoforge.common.util.Lazy;
import net.neoforged.neoforge.items.IItemHandler;
import net.neoforged.neoforge.items.ItemHandlerHelper;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.tuple.Pair;

public class CraftingStationTileEntity
extends GenericTileEntity {
    public static final int SLOT_OUTPUT = 0;
    public static final Lazy<ContainerFactory> CONTAINER_FACTORY = Lazy.of(() -> new ContainerFactory(9).box(SlotDefinition.generic(), 0, 6, 157, 3, 3).playerSlots(66, 157));
    private final GenericItemHandler items = GenericItemHandler.basic((GenericTileEntity)this, CONTAINER_FACTORY);
    @Cap(type=CapType.ITEMS_AUTOMATION)
    private static final Function<CraftingStationTileEntity, GenericItemHandler> ITEM_CAP = te -> te.items;
    @Cap(type=CapType.CONTAINER)
    private static final Function<CraftingStationTileEntity, MenuProvider> screenHandler = tile -> new DefaultContainerProvider("Crafter").containerSupplier(DefaultContainerProvider.container(CraftingStationModule.CRAFTING_STATION_CONTAINER, CONTAINER_FACTORY, (GenericTileEntity)tile)).itemHandler(() -> tile.items).setupSync((GenericTileEntity)tile);
    private final List<BlockPos> processorList = new ArrayList<BlockPos>();
    private List<CraftingRequest> activeCraftingRequests = new ArrayList<CraftingRequest>();
    private int cleanupCounter = 50;
    public static final Key<ItemStack> PARAM_ITEM = new Key("item", Type.ITEMSTACK);
    public static final Key<Integer> PARAM_AMOUNT = new Key("amount", Type.INTEGER);
    @ServerCommand
    public static final Command<?> CMD_REQUEST = Command.create((String)"station.request", (te, player, params) -> {
        ItemStack stack = (ItemStack)params.get(PARAM_ITEM);
        int index = te.findItem(stack);
        if (index == -1) {
            return;
        }
        te.startCraft(index, (Integer)params.get(PARAM_AMOUNT));
    });
    public static final Key<Integer> PARAM_INDEX = new Key("index", Type.INTEGER);
    @ServerCommand
    public static final Command<?> CMD_CANCEL = Command.create((String)"station.cancel", (te, player, params) -> te.cancelCraft((Integer)params.get(PARAM_INDEX)));
    @ServerCommand(type=ItemStack.class)
    public static final ListCommand<?, ?> CMD_GETCRAFTABLE = ListCommand.create((String)"rftoolscontrol.station.getCraftable", (te, player, params) -> te.getCraftableItems(), (te, player, params, list) -> GuiCraftingStation.storeCraftableForClient(list));
    @ServerCommand(type=CraftingRequest.class, serializer=CraftingRequest.Serializer.class)
    public static final ListCommand<?, ?> CMD_GETREQUESTS = ListCommand.create((String)"rftoolscontrol.station.getRequests", (te, player, params) -> te.getRequests(), (te, player, params, list) -> GuiCraftingStation.storeRequestsForClient(list));

    public CraftingStationTileEntity(BlockPos pos, BlockState state) {
        super((BlockEntityType)CraftingStationModule.CRAFTING_STATION.be().get(), pos, state);
    }

    public void registerProcessor(BlockPos pos) {
        if (!this.processorList.contains(pos)) {
            this.processorList.add(pos);
        }
        this.setChanged();
    }

    public ItemStack getCraftResult(String craftId) {
        for (CraftingRequest request : this.activeCraftingRequests) {
            if (!craftId.equals(request.getTicket())) continue;
            return request.getStack();
        }
        return ItemStack.EMPTY;
    }

    private Pair<ProcessorTileEntity, ItemStack> findCraftableItem(int index) {
        for (BlockPos p : this.processorList) {
            BlockEntity te = this.level.getBlockEntity(p);
            if (!(te instanceof ProcessorTileEntity)) continue;
            ProcessorTileEntity processor = (ProcessorTileEntity)te;
            ItemStackList items = ItemStackList.create();
            processor.getCraftableItems((List<ItemStack>)items);
            for (ItemStack item : items) {
                if (index == 0) {
                    return Pair.of((Object)((Object)processor), (Object)item);
                }
                --index;
            }
        }
        return null;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public ItemStack craftOk(ProcessorTileEntity processor, String ticket, ItemStack stack) {
        CraftingRequest foundRequest = null;
        for (CraftingRequest request : this.activeCraftingRequests) {
            if (!ticket.equals(request.getTicket())) continue;
            foundRequest = request;
            break;
        }
        if (foundRequest == null) return stack;
        this.setChanged();
        foundRequest.decrTodo();
        if (foundRequest.getTodo() <= 0) {
            foundRequest.setOk(System.currentTimeMillis() + 1000L);
        } else {
            processor.fireCraftEvent(ticket, foundRequest.getStack());
        }
        if (stack.isEmpty()) return stack;
        Inventory inventory = this.getInventoryFromTicket(ticket);
        if (inventory == null) return ItemHandlerHelper.insertItem((IItemHandler)this.items, (ItemStack)stack, (boolean)false);
        IItemHandler inv = processor.getItemHandlerAt(inventory);
        if (inv == null) throw new ProgException(ExceptionType.EXCEPT_INVALIDINVENTORY);
        return ItemHandlerHelper.insertItem((IItemHandler)inv, (ItemStack)stack, (boolean)false);
    }

    public void craftFail(String ticket) {
        for (CraftingRequest request : this.activeCraftingRequests) {
            if (!ticket.equals(request.getTicket())) continue;
            request.setFailed(System.currentTimeMillis() + 2000L);
            this.setChanged();
        }
    }

    private void cancelCraft(int index) {
        try {
            this.activeCraftingRequests.remove(index);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void startCraft(int index, int amount) {
        Pair<ProcessorTileEntity, ItemStack> pair = this.findCraftableItem(index);
        if (pair == null) {
            System.out.println("What? Can't happen");
            return;
        }
        String ticket = this.getNewTicket(null);
        ItemStack stack = (ItemStack)pair.getValue();
        int count = (amount + stack.getCount() - 1) / stack.getCount();
        CraftingRequest request = new CraftingRequest(ticket, stack, count);
        if (!this.checkRequestAmount()) {
            return;
        }
        this.activeCraftingRequests.add(request);
        ((ProcessorTileEntity)((Object)pair.getKey())).fireCraftEvent(ticket, stack);
        --this.cleanupCounter;
        if (this.cleanupCounter <= 0) {
            this.cleanupCounter = 50;
            this.cleanupStaleRequests();
        }
    }

    private boolean checkRequestAmount() {
        if (this.activeCraftingRequests.size() >= (Integer)Config.maxCraftRequests.get()) {
            this.cleanupCounter = 50;
            this.cleanupStaleRequests();
            if (this.activeCraftingRequests.size() >= (Integer)Config.maxCraftRequests.get()) {
                return false;
            }
        }
        return true;
    }

    public boolean isRequested(Ingredient item) {
        for (CraftingRequest request : this.activeCraftingRequests) {
            long failed = request.getFailed();
            long ok = request.getOk();
            if (failed != -1L || ok != -1L || !item.test(request.getStack())) continue;
            return true;
        }
        return false;
    }

    public boolean request(@Nonnull Ingredient item, @Nullable Inventory destination) {
        for (BlockPos p : this.processorList) {
            BlockEntity te = this.level.getBlockEntity(p);
            if (!(te instanceof ProcessorTileEntity)) continue;
            ProcessorTileEntity processor = (ProcessorTileEntity)te;
            ItemStackList items = ItemStackList.create();
            processor.getCraftableItems((List<ItemStack>)items);
            for (ItemStack i : items) {
                if (!item.test(i)) continue;
                String ticket = this.getNewTicket(destination);
                if (!this.checkRequestAmount()) {
                    return false;
                }
                this.activeCraftingRequests.add(new CraftingRequest(ticket, i, 1));
                processor.fireCraftEvent(ticket, i);
                return true;
            }
        }
        return false;
    }

    private String getNewTicket(@Nullable Inventory destInv) {
        int craftId = this.nextCraftId();
        if (destInv != null) {
            return destInv.serialize() + "#" + craftId;
        }
        return BlockPosTools.toString((BlockPos)this.worldPosition) + ":" + craftId;
    }

    private int nextCraftId() {
        CraftingStationData data = (CraftingStationData)this.getData(CraftingStationModule.CRAFTING_STATION_DATA);
        int next = data.craftId() + 1;
        this.setData(CraftingStationModule.CRAFTING_STATION_DATA, data.withCraftId(next));
        return next;
    }

    @Nullable
    private Inventory getInventoryFromTicket(String ticket) {
        if (ticket.startsWith("#")) {
            return Inventory.deserialize((String)ticket);
        }
        return null;
    }

    @Nullable
    private BlockPos getPositionFromTicket(String ticket) {
        if (ticket.startsWith("#")) {
            return null;
        }
        String[] splitted = StringUtils.split((String)ticket, (char)';');
        String[] poss = StringUtils.split((String)splitted[0], (char)',');
        return new BlockPos(Integer.parseInt(poss[0]), Integer.parseInt(poss[1]), Integer.parseInt(poss[2]));
    }

    public ItemStackList getCraftableItems() {
        ItemStackList items = ItemStackList.create();
        for (BlockPos p : this.processorList) {
            BlockEntity te = this.level.getBlockEntity(p);
            if (!(te instanceof ProcessorTileEntity)) continue;
            ProcessorTileEntity processor = (ProcessorTileEntity)te;
            processor.getCraftableItems((List<ItemStack>)items);
        }
        return items;
    }

    private void cleanupStaleRequests() {
        long time = System.currentTimeMillis();
        List<CraftingRequest> oldRequests = this.activeCraftingRequests;
        this.activeCraftingRequests = new ArrayList<CraftingRequest>();
        for (CraftingRequest request : oldRequests) {
            long failed = request.getFailed();
            long ok = request.getOk();
            if (failed != -1L && time > failed || ok != -1L && time > ok) continue;
            this.activeCraftingRequests.add(request);
        }
    }

    public List<CraftingRequest> getRequests() {
        this.cleanupStaleRequests();
        return new ArrayList<CraftingRequest>(this.activeCraftingRequests);
    }

    public void loadAdditional(CompoundTag tag, HolderLookup.Provider provider) {
        super.loadAdditional(tag, provider);
        this.readProcessorList(tag);
        this.readRequests(tag, provider);
        this.items.load(tag, "items", provider);
    }

    private void readRequests(CompoundTag tagCompound, HolderLookup.Provider provider) {
        ListTag list = tagCompound.getList("requests", 10);
        this.activeCraftingRequests.clear();
        for (int i = 0; i < list.size(); ++i) {
            CompoundTag requestTag = list.getCompound(i);
            String craftId = requestTag.getString("craftId");
            ItemStack stack = ItemStack.parseOptional((HolderLookup.Provider)provider, (CompoundTag)requestTag.getCompound("stack"));
            int count = requestTag.getInt("count");
            CraftingRequest request = new CraftingRequest(craftId, stack, count);
            request.setFailed(requestTag.getLong("failed"));
            request.setOk(requestTag.getLong("ok"));
            this.activeCraftingRequests.add(request);
        }
    }

    private void readProcessorList(CompoundTag tagCompound) {
        ListTag list = tagCompound.getList("processors", 10);
        this.processorList.clear();
        for (int i = 0; i < list.size(); ++i) {
            CompoundTag tag = list.getCompound(i);
            this.processorList.add(new BlockPos(tag.getInt("x"), tag.getInt("y"), tag.getInt("z")));
        }
    }

    public void saveAdditional(@Nonnull CompoundTag tag, HolderLookup.Provider provider) {
        super.saveAdditional(tag, provider);
        this.writeProcessorList(tag);
        this.writeRequests(tag, provider);
        this.items.save(tag, "items", provider);
    }

    private void writeRequests(CompoundTag tagCompound, HolderLookup.Provider provider) {
        ListTag list = new ListTag();
        for (CraftingRequest request : this.activeCraftingRequests) {
            CompoundTag requestTag = new CompoundTag();
            requestTag.putString("craftId", request.getTicket());
            CompoundTag stackNbt = new CompoundTag();
            request.getStack().save(provider, (Tag)stackNbt);
            requestTag.put("stack", (Tag)stackNbt);
            requestTag.putInt("count", request.getTodo());
            requestTag.putLong("failed", request.getFailed());
            requestTag.putLong("ok", request.getOk());
            list.add((Object)requestTag);
        }
        tagCompound.put("requests", (Tag)list);
    }

    private void writeProcessorList(CompoundTag tagCompound) {
        ListTag list = new ListTag();
        for (BlockPos p : this.processorList) {
            CompoundTag tag = new CompoundTag();
            tag.putInt("x", p.getX());
            tag.putInt("y", p.getY());
            tag.putInt("z", p.getZ());
            list.add((Object)tag);
        }
        tagCompound.put("processors", (Tag)list);
    }

    protected void applyImplicitComponents(BlockEntity.DataComponentInput input) {
        super.applyImplicitComponents(input);
        CraftingStationData data = (CraftingStationData)input.get(CraftingStationModule.ITEM_CRAFTING_STATION_DATA);
        if (data != null) {
            this.setData(CraftingStationModule.CRAFTING_STATION_DATA, data);
        }
        this.items.applyImplicitComponents((ItemInventory)input.get((Supplier)Registration.ITEM_INVENTORY));
    }

    protected void collectImplicitComponents(DataComponentMap.Builder builder) {
        super.collectImplicitComponents(builder);
        builder.set(CraftingStationModule.ITEM_CRAFTING_STATION_DATA, (Object)((CraftingStationData)this.getData(CraftingStationModule.CRAFTING_STATION_DATA)));
        this.items.collectImplicitComponents(builder);
    }

    private int findItem(ItemStack stack) {
        int index = 0;
        for (BlockPos p : this.processorList) {
            BlockEntity te = this.level.getBlockEntity(p);
            if (!(te instanceof ProcessorTileEntity)) continue;
            ProcessorTileEntity processor = (ProcessorTileEntity)te;
            ItemStackList items = ItemStackList.create();
            processor.getCraftableItems((List<ItemStack>)items);
            for (ItemStack item : items) {
                if (ItemStack.isSameItemSameComponents((ItemStack)item, (ItemStack)stack)) {
                    return index;
                }
                ++index;
            }
        }
        return -1;
    }
}

