/*
 * Decompiled with CFR 0.152.
 */
package mcjty.rftoolscontrol.modules.processor.client;

import com.mojang.blaze3d.vertex.PoseStack;
import java.util.List;
import javax.annotation.Nonnull;
import mcjty.lib.blocks.BaseBlock;
import mcjty.lib.blocks.RotationType;
import mcjty.lib.client.RenderHelper;
import mcjty.lib.network.Networking;
import mcjty.lib.network.PacketGetListFromServer;
import mcjty.lib.network.PacketSendServerCommand;
import mcjty.lib.typed.TypedMap;
import mcjty.rftoolscontrol.CommandHandler;
import mcjty.rftoolscontrol.modules.processor.ProcessorModule;
import mcjty.rftoolscontrol.modules.processor.blocks.ProcessorTileEntity;
import mcjty.rftoolscontrol.modules.processor.data.HudMode;
import mcjty.rftoolscontrol.modules.processor.network.PacketGetLog;
import mcjty.rftoolscontrol.modules.processor.vectorart.GfxOp;
import mcjty.rftoolscontrol.setup.RFToolsCtrlMessages;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderers;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import org.joml.Matrix3fc;
import org.joml.Matrix4fc;

public class ProcessorRenderer
implements BlockEntityRenderer<ProcessorTileEntity> {
    public ProcessorRenderer(BlockEntityRendererProvider.Context context) {
    }

    public void render(ProcessorTileEntity te, float partialTicks, @Nonnull PoseStack matrixStack, @Nonnull MultiBufferSource buffer, int combinedLightIn, int combinedOverlayIn) {
        if (te.getShowHud() == HudMode.OFF) {
            return;
        }
        BlockState state = te.getLevel().getBlockState(te.getBlockPos());
        Block block = state.getBlock();
        if (!(block instanceof BaseBlock)) {
            return;
        }
        BaseBlock baseBlock = (BaseBlock)block;
        matrixStack.pushPose();
        Direction facing = BaseBlock.getFrontDirection((RotationType)baseBlock.getRotationType(), (BlockState)state);
        matrixStack.translate(0.5f, 1.5f, 0.5f);
        if (facing == Direction.UP) {
            RenderHelper.rotateXP((PoseStack)matrixStack, (float)-90.0f);
        } else if (facing == Direction.DOWN) {
            RenderHelper.rotateXP((PoseStack)matrixStack, (float)90.0f);
        } else {
            float rotY = switch (facing) {
                case Direction.NORTH -> 180.0f;
                case Direction.WEST -> 90.0f;
                case Direction.EAST -> -90.0f;
                default -> 0.0f;
            };
            RenderHelper.rotateYP((PoseStack)matrixStack, (float)(-rotY));
        }
        if (te.getLevel().isEmptyBlock(te.getBlockPos().above())) {
            matrixStack.translate(0.0f, 0.0f, -0.037499994f);
        } else {
            matrixStack.translate(0.0f, 0.0f, 0.46249998f);
        }
        GuiGraphics graphics = new GuiGraphics(Minecraft.getInstance(), Minecraft.getInstance().renderBuffers().bufferSource());
        graphics.pose().last().pose().set((Matrix4fc)matrixStack.last().pose());
        graphics.pose().last().normal().set((Matrix3fc)matrixStack.last().normal());
        this.renderHud(graphics, buffer, Minecraft.getInstance().font, te);
        matrixStack.popPose();
    }

    private void renderHud(GuiGraphics graphics, MultiBufferSource buffer, Font fontrenderer, ProcessorTileEntity tileEntity) {
        float factor = 1.0f;
        int currenty = 7;
        PoseStack matrixStack = graphics.pose();
        matrixStack.translate(-0.5f, 0.5f, 0.07f);
        float f3 = 0.0075f;
        matrixStack.scale(f3 * factor, -f3 * factor, f3);
        if (tileEntity.getShowHud() == HudMode.GFX) {
            this.renderGfx(graphics, buffer, tileEntity);
        } else {
            this.renderLog(matrixStack, buffer, fontrenderer, tileEntity, currenty);
        }
    }

    private void renderLog(PoseStack matrixStack, MultiBufferSource buffer, Font fontrenderer, ProcessorTileEntity tileEntity, int currenty) {
        List<String> log = tileEntity.getShowHud() == HudMode.DB ? tileEntity.getClientDebugLog() : tileEntity.getClientLog();
        long t = System.currentTimeMillis();
        if (t - tileEntity.clientTime > 250L) {
            if (tileEntity.getShowHud() == HudMode.DB) {
                Networking.sendToServer((CustomPacketPayload)PacketGetListFromServer.create((BlockPos)tileEntity.getBlockPos(), (String)ProcessorTileEntity.CMD_GETDEBUGLOG.name()));
            } else {
                RFToolsCtrlMessages.sendToServer(PacketGetLog.create(tileEntity.getDimension(), tileEntity.getBlockPos(), false));
            }
            tileEntity.clientTime = t;
        }
        int height = 10;
        int logsize = log.size();
        int i = 0;
        for (String s : log) {
            if (i >= logsize - 11 && currenty + height <= 124) {
                RenderHelper.renderText((Font)fontrenderer, (String)fontrenderer.plainSubstrByWidth(s, 115), (int)7, (int)currenty, (int)-1, (PoseStack)matrixStack, (MultiBufferSource)buffer, (int)0xF000F0);
                currenty += height;
            }
            ++i;
        }
    }

    private void renderGfx(GuiGraphics graphics, MultiBufferSource buffer, ProcessorTileEntity tileEntity) {
        List<GfxOp> ops;
        long t = System.currentTimeMillis();
        if (t - tileEntity.clientTime > 250L) {
            RFToolsCtrlMessages.sendToServer(PacketSendServerCommand.create((String)"rftoolscontrol", (String)"getGraphics", (TypedMap)TypedMap.builder().put(CommandHandler.PARAM_POS, (Object)tileEntity.getBlockPos()).build()));
            tileEntity.clientTime = t;
        }
        if ((ops = tileEntity.getClientGfxOps()) != null) {
            for (GfxOp op : ops) {
                op.render(graphics, buffer);
            }
        }
    }

    public static void register() {
        BlockEntityRenderers.register((BlockEntityType)((BlockEntityType)ProcessorModule.PROCESSOR.be().get()), ProcessorRenderer::new);
    }

    public AABB getRenderBoundingBox(ProcessorTileEntity blockEntity) {
        BlockPos pos = blockEntity.getBlockPos();
        int xCoord = pos.getX();
        int yCoord = pos.getY();
        int zCoord = pos.getZ();
        return new AABB((double)xCoord, (double)yCoord, (double)zCoord, (double)(xCoord + 1), (double)(yCoord + 21), (double)(zCoord + 1));
    }
}

