/*
 * Decompiled with CFR 0.152.
 */
package mcjty.rftoolscontrol.modules.processor.network;

import java.util.List;
import mcjty.rftoolsbase.api.control.parameters.Parameter;
import mcjty.rftoolsbase.api.control.parameters.ParameterType;
import mcjty.rftoolsbase.api.control.parameters.ParameterValue;
import mcjty.rftoolscontrol.modules.processor.blocks.ProcessorTileEntity;
import mcjty.rftoolscontrol.modules.processor.logic.ParameterTypeTools;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.neoforged.neoforge.network.handling.IPayloadContext;

public record PacketVariableToServer(BlockPos pos, int varIndex, CompoundTag tagCompound) implements CustomPacketPayload
{
    public static final ResourceLocation ID = ResourceLocation.fromNamespaceAndPath((String)"rftoolscontrol", (String)"variable_to_server");
    public static final CustomPacketPayload.Type<PacketVariableToServer> TYPE = new CustomPacketPayload.Type(ID);
    public static final StreamCodec<RegistryFriendlyByteBuf, PacketVariableToServer> CODEC = StreamCodec.of((buf, packet) -> {
        buf.writeBlockPos(packet.pos);
        buf.writeInt(packet.varIndex);
        buf.writeNbt((Tag)packet.tagCompound);
    }, buf -> new PacketVariableToServer(buf.readBlockPos(), buf.readInt(), buf.readNbt()));

    public static PacketVariableToServer create(BlockPos blockPos, int varIdx, CompoundTag tag) {
        return new PacketVariableToServer(blockPos, varIdx, tag);
    }

    public CustomPacketPayload.Type<? extends CustomPacketPayload> type() {
        return TYPE;
    }

    public void handle(IPayloadContext ctx) {
        ctx.enqueueWork(() -> {
            ProcessorTileEntity processor;
            List<Parameter> variables;
            BlockEntity te = ctx.player().getCommandSenderWorld().getBlockEntity(this.pos);
            if (te instanceof ProcessorTileEntity && this.varIndex < (variables = (processor = (ProcessorTileEntity)te).getVariables()).size()) {
                Parameter parameter = variables.get(this.varIndex);
                ParameterType type = parameter.getParameterType();
                ParameterValue value = ParameterTypeTools.readFromNBT(this.tagCompound, type, (HolderLookup.Provider)ctx.player().registryAccess());
                variables.set(this.varIndex, Parameter.builder().type(type).value(value).build());
                processor.setChanged();
            }
        });
    }
}

