/*
 * Decompiled with CFR 0.152.
 */
package mcjty.rftoolscontrol.modules.processor.util;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import mcjty.rftoolscontrol.modules.processor.logic.compiled.CompiledCard;
import mcjty.rftoolscontrol.modules.processor.logic.running.ExceptionType;
import mcjty.rftoolscontrol.modules.processor.logic.running.ProgException;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;

public class CardInfo {
    public static final Codec<CardInfo> CODEC = RecordCodecBuilder.create(inst -> inst.group((App)Codec.INT.fieldOf("itemAlloc").forGetter(CardInfo::getItemAllocation), (App)Codec.INT.fieldOf("varAlloc").forGetter(CardInfo::getVarAllocation), (App)Codec.INT.fieldOf("fluidAlloc").forGetter(CardInfo::getFluidAllocation)).apply((Applicative)inst, (itemAlloc, varAlloc, fluidAlloc) -> {
        CardInfo info = new CardInfo();
        info.itemAllocation = itemAlloc;
        info.varAllocation = varAlloc;
        info.fluidAllocation = fluidAlloc;
        return info;
    }));
    public static final StreamCodec<RegistryFriendlyByteBuf, CardInfo> STREAM_CODEC = StreamCodec.of((buf, value) -> {
        ByteBufCodecs.INT.encode(buf, (Object)value.itemAllocation);
        ByteBufCodecs.INT.encode(buf, (Object)value.varAllocation);
        ByteBufCodecs.INT.encode(buf, (Object)value.fluidAllocation);
    }, buf -> {
        CardInfo info = new CardInfo();
        info.itemAllocation = (Integer)ByteBufCodecs.INT.decode(buf);
        info.varAllocation = (Integer)ByteBufCodecs.INT.decode(buf);
        info.fluidAllocation = (Integer)ByteBufCodecs.INT.decode(buf);
        return info;
    });
    private int itemAllocation;
    private int varAllocation;
    private int fluidAllocation;
    private CompiledCard compiledCard;
    private int[] slotCache = null;
    private int[] varCache = null;
    private int[] fluidCache = null;

    public int getFluidAllocation() {
        return this.fluidAllocation;
    }

    public void setFluidAllocation(int fluidAllocation) {
        this.fluidAllocation = fluidAllocation;
        this.fluidCache = null;
    }

    public int getItemAllocation() {
        return this.itemAllocation;
    }

    public void setItemAllocation(int itemAllocation) {
        this.itemAllocation = itemAllocation;
        this.slotCache = null;
    }

    public int getVarAllocation() {
        return this.varAllocation;
    }

    public void setVarAllocation(int varAllocation) {
        this.varAllocation = varAllocation;
        this.varCache = null;
    }

    public void setCompiledCard(CompiledCard compiledCard) {
        this.compiledCard = compiledCard;
    }

    public CompiledCard getCompiledCard() {
        return this.compiledCard;
    }

    public Integer getRealFluidSlot(Integer virtualSlot) {
        if (virtualSlot == null) {
            return null;
        }
        return this.getRealFluidSlot((int)virtualSlot);
    }

    public int getRealFluidSlot(int virtualSlot) {
        int realSlot;
        if (this.fluidCache == null) {
            this.fluidCache = new int[24];
            int idx = 0;
            for (int i = 0; i < 24; ++i) {
                if ((this.fluidAllocation >> i & 1) != 1) continue;
                this.fluidCache[idx] = i;
                ++idx;
            }
            while (idx < 24) {
                this.fluidCache[idx] = -1;
                ++idx;
            }
        }
        if ((realSlot = this.fluidCache[virtualSlot]) == -1) {
            throw new ProgException(ExceptionType.EXCEPT_NOINTERNALFLUIDSLOT);
        }
        return realSlot;
    }

    public Integer getRealSlot(Integer virtualSlot) {
        if (virtualSlot == null) {
            return null;
        }
        return this.getRealSlot((int)virtualSlot);
    }

    public int getRealSlot(int virtualSlot) {
        int realSlot;
        if (this.slotCache == null) {
            this.slotCache = new int[24];
            int idx = 0;
            for (int i = 0; i < 24; ++i) {
                if ((this.itemAllocation >> i & 1) != 1) continue;
                this.slotCache[idx] = i;
                ++idx;
            }
            while (idx < 24) {
                this.slotCache[idx] = -1;
                ++idx;
            }
        }
        if ((realSlot = this.slotCache[virtualSlot]) == -1) {
            throw new ProgException(ExceptionType.EXCEPT_NOINTERNALSLOT);
        }
        return realSlot + 22;
    }

    public int getRealVar(int virtualVar) {
        if (this.varCache == null) {
            this.varCache = new int[32];
            int idx = 0;
            for (int i = 0; i < 32; ++i) {
                if ((this.varAllocation >> i & 1) != 1) continue;
                this.varCache[idx] = i;
                ++idx;
            }
            while (idx < 32) {
                this.varCache[idx] = -1;
                ++idx;
            }
        }
        return this.varCache[virtualVar];
    }

    public Integer getRealVar(Integer virtualVar) {
        if (virtualVar == null) {
            return null;
        }
        return this.getRealVar((int)virtualVar);
    }
}

