/*
 * Decompiled with CFR 0.152.
 */
package mcjty.rftoolscontrol.modules.various.items.consolemodule;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.List;
import mcjty.lib.varia.BlockPosTools;
import mcjty.lib.varia.LevelTools;
import mcjty.rftoolsbase.api.screens.IScreenDataHelper;
import mcjty.rftoolsbase.api.screens.IScreenModule;
import mcjty.rftoolscontrol.compat.rftoolssupport.ModuleDataLog;
import mcjty.rftoolscontrol.modules.processor.ProcessorModule;
import mcjty.rftoolscontrol.modules.processor.blocks.ProcessorTileEntity;
import mcjty.rftoolscontrol.setup.Config;
import net.minecraft.core.BlockPos;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import org.jetbrains.annotations.NotNull;

public class ConsoleScreenModule
implements IScreenModule<ConsoleScreenModule, ModuleDataLog> {
    public static final ConsoleScreenModule DEFAULT = new ConsoleScreenModule((ResourceKey<Level>)Level.OVERWORLD, BlockPosTools.INVALID);
    public static final Codec<ConsoleScreenModule> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)ResourceKey.codec((ResourceKey)Registries.DIMENSION).fieldOf("dim").forGetter(ConsoleScreenModule::getDim), (App)BlockPos.CODEC.fieldOf("pos").forGetter(ConsoleScreenModule::getCoordinate)).apply((Applicative)instance, ConsoleScreenModule::new));
    public static final StreamCodec<RegistryFriendlyByteBuf, ConsoleScreenModule> STREAM_CODEC = StreamCodec.composite((StreamCodec)ResourceKey.streamCodec((ResourceKey)Registries.DIMENSION), ConsoleScreenModule::getDim, (StreamCodec)BlockPos.STREAM_CODEC, ConsoleScreenModule::getCoordinate, ConsoleScreenModule::new);
    private final ResourceKey<Level> dim;
    private final BlockPos coordinate;

    public ConsoleScreenModule(ResourceKey<Level> dim, BlockPos coordinate) {
        this.dim = dim;
        this.coordinate = coordinate;
    }

    public ResourceKey<Level> getDim() {
        return this.dim;
    }

    public BlockPos getCoordinate() {
        return this.coordinate;
    }

    public ConsoleScreenModule withDim(ResourceKey<Level> dim) {
        return new ConsoleScreenModule(dim, this.coordinate);
    }

    public ConsoleScreenModule withCoordinate(BlockPos pos) {
        return new ConsoleScreenModule(this.dim, pos);
    }

    public ModuleDataLog getData(IScreenDataHelper h, Level worldObj, long millis) {
        ServerLevel world = LevelTools.getLevel((Level)worldObj, this.dim);
        if (world == null) {
            return null;
        }
        if (!LevelTools.isLoaded((Level)world, (BlockPos)this.coordinate)) {
            return null;
        }
        Block block = world.getBlockState(this.coordinate).getBlock();
        if (block != ProcessorModule.PROCESSOR.block().get()) {
            return null;
        }
        BlockEntity te = world.getBlockEntity(this.coordinate);
        if (te instanceof ProcessorTileEntity) {
            ProcessorTileEntity processor = (ProcessorTileEntity)te;
            List<String> lastMessages = processor.getLastMessages(12);
            return new ModuleDataLog(lastMessages);
        }
        return null;
    }

    public int getRfPerTick() {
        return (Integer)Config.CONSOLEMODULE_RFPERTICK.get();
    }

    public ConsoleScreenModule validate(Level world, BlockPos pos, boolean isPlus) {
        return this;
    }

    @NotNull
    public ItemStack mouseClick(ItemStack moduleStack, Level world, int x, int y, boolean clicked, Player player) {
        return moduleStack;
    }
}

