/*
 * Decompiled with CFR 0.152.
 */
package mcjty.rftoolscontrol.modules.various.items.interactionmodule;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Objects;
import mcjty.lib.varia.BlockPosTools;
import mcjty.lib.varia.ComponentFactory;
import mcjty.lib.varia.CompositeStreamCodec;
import mcjty.lib.varia.LevelTools;
import mcjty.rftoolsbase.api.screens.IScreenDataHelper;
import mcjty.rftoolsbase.api.screens.IScreenModule;
import mcjty.rftoolsbase.api.screens.TextAlign;
import mcjty.rftoolsbase.api.screens.data.IModuleDataBoolean;
import mcjty.rftoolscontrol.modules.processor.ProcessorModule;
import mcjty.rftoolscontrol.modules.processor.blocks.ProcessorTileEntity;
import mcjty.rftoolscontrol.setup.Config;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import org.jetbrains.annotations.NotNull;

public record InteractionScreenModule(String line, String button, String signal, int color, int buttonColor, TextAlign align, ResourceKey<Level> dim, BlockPos coordinate) implements IScreenModule<InteractionScreenModule, IModuleDataBoolean>
{
    public static final InteractionScreenModule DEFAULT = new InteractionScreenModule("", "", "", 0xFFFFFF, 0xFFFFFF, TextAlign.ALIGN_LEFT, (ResourceKey<Level>)Level.OVERWORLD, BlockPosTools.INVALID);
    public static final Codec<InteractionScreenModule> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)Codec.STRING.fieldOf("line").forGetter(InteractionScreenModule::line), (App)Codec.STRING.fieldOf("button").forGetter(InteractionScreenModule::button), (App)Codec.STRING.fieldOf("signal").forGetter(InteractionScreenModule::signal), (App)Codec.INT.fieldOf("color").forGetter(InteractionScreenModule::color), (App)Codec.INT.fieldOf("buttonColor").forGetter(InteractionScreenModule::buttonColor), (App)Codec.STRING.fieldOf("align").forGetter(module -> module.align().getSerializedName()), (App)ResourceKey.codec((ResourceKey)Registries.DIMENSION).fieldOf("dim").forGetter(InteractionScreenModule::dim), (App)BlockPos.CODEC.fieldOf("coordinate").forGetter(InteractionScreenModule::coordinate)).apply((Applicative)instance, InteractionScreenModule::create));
    public static final StreamCodec<RegistryFriendlyByteBuf, InteractionScreenModule> STREAM_CODEC = CompositeStreamCodec.composite((StreamCodec)ByteBufCodecs.STRING_UTF8, InteractionScreenModule::line, (StreamCodec)ByteBufCodecs.STRING_UTF8, InteractionScreenModule::button, (StreamCodec)ByteBufCodecs.STRING_UTF8, InteractionScreenModule::signal, (StreamCodec)ByteBufCodecs.INT, InteractionScreenModule::color, (StreamCodec)ByteBufCodecs.INT, InteractionScreenModule::buttonColor, (StreamCodec)ByteBufCodecs.STRING_UTF8, module -> module.align().getSerializedName(), (StreamCodec)ResourceKey.streamCodec((ResourceKey)Registries.DIMENSION), InteractionScreenModule::dim, (StreamCodec)BlockPos.STREAM_CODEC, InteractionScreenModule::coordinate, InteractionScreenModule::create);

    private static InteractionScreenModule create(String line, String button, String signal, int color, int buttonColor, String align, ResourceKey<Level> dim, BlockPos coordinate) {
        return new InteractionScreenModule(line, button, signal, color, buttonColor, TextAlign.get((String)align), dim, coordinate);
    }

    public InteractionScreenModule withLine(String line) {
        return new InteractionScreenModule(line, this.button, this.signal, this.color, this.buttonColor, this.align, this.dim, this.coordinate);
    }

    public InteractionScreenModule withButton(String button) {
        return new InteractionScreenModule(this.line, button, this.signal, this.color, this.buttonColor, this.align, this.dim, this.coordinate);
    }

    public InteractionScreenModule withSignal(String signal) {
        return new InteractionScreenModule(this.line, this.button, signal, this.color, this.buttonColor, this.align, this.dim, this.coordinate);
    }

    public InteractionScreenModule withColor(int color) {
        return new InteractionScreenModule(this.line, this.button, this.signal, color, this.buttonColor, this.align, this.dim, this.coordinate);
    }

    public InteractionScreenModule withButtonColor(int buttonColor) {
        return new InteractionScreenModule(this.line, this.button, this.signal, this.color, buttonColor, this.align, this.dim, this.coordinate);
    }

    public InteractionScreenModule withAlign(TextAlign align) {
        return new InteractionScreenModule(this.line, this.button, this.signal, this.color, this.buttonColor, align, this.dim, this.coordinate);
    }

    public InteractionScreenModule withDim(ResourceKey<Level> dim) {
        return new InteractionScreenModule(this.line, this.button, this.signal, this.color, this.buttonColor, this.align, dim, this.coordinate);
    }

    public InteractionScreenModule withCoordinate(BlockPos coordinate) {
        return new InteractionScreenModule(this.line, this.button, this.signal, this.color, this.buttonColor, this.align, this.dim, coordinate);
    }

    public InteractionScreenModule withTarget(ResourceKey<Level> dim, BlockPos coordinate) {
        return new InteractionScreenModule(this.line, this.button, this.signal, this.color, this.buttonColor, this.align, dim, coordinate);
    }

    public IModuleDataBoolean getData(IScreenDataHelper helper, Level worldObj, long millis) {
        return null;
    }

    public int getRfPerTick() {
        return (Integer)Config.INTERACTMODULE_RFPERTICK.get();
    }

    public InteractionScreenModule validate(Level world, BlockPos pos, boolean isPlus) {
        if (!Objects.equals(world.dimension(), this.dim)) {
            return this.withCoordinate(BlockPosTools.INVALID);
        }
        if (!BlockPosTools.isValid((BlockPos)this.coordinate)) {
            return this;
        }
        int dx = Math.abs(this.coordinate.getX() - pos.getX());
        int dy = Math.abs(this.coordinate.getY() - pos.getY());
        int dz = Math.abs(this.coordinate.getZ() - pos.getZ());
        if (dx <= 64 && dy <= 64 && dz <= 64) {
            return this;
        }
        return this.withCoordinate(BlockPosTools.INVALID);
    }

    @NotNull
    public ItemStack mouseClick(ItemStack moduleStack, Level world, int x, int y, boolean clicked, Player player) {
        BlockEntity te;
        int xoffset;
        int n = xoffset = this.line.isEmpty() ? 5 : 80;
        if (x < xoffset) {
            return moduleStack;
        }
        if (!BlockPosTools.isValid((BlockPos)this.coordinate)) {
            if (player != null) {
                player.displayClientMessage((Component)ComponentFactory.literal((String)(String.valueOf(ChatFormatting.RED) + "Module is not linked to a processor!")), false);
            }
            return moduleStack;
        }
        if (!Objects.equals(world.dimension(), this.dim)) {
            return moduleStack;
        }
        if (!LevelTools.isLoaded((Level)world, (BlockPos)this.coordinate)) {
            return moduleStack;
        }
        Block block = world.getBlockState(this.coordinate).getBlock();
        if (block != ProcessorModule.PROCESSOR.block().get()) {
            return moduleStack;
        }
        if (clicked && (te = world.getBlockEntity(this.coordinate)) instanceof ProcessorTileEntity) {
            ProcessorTileEntity processor = (ProcessorTileEntity)te;
            processor.signal(this.signal);
        }
        return moduleStack;
    }
}

